/* Copyright 2008 we-lab-doc! (http://www.we-lab-doc.com/)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.we_lab_doc.spacecard.model.abstracts

import com.we_lab_doc.spacecard.model.*
import com.we_lab_doc.spacecard.utils.*

/**
 * @author Shigeru GOUGI
 * @since 0.1
 *        <p/>
 *        Created: February 13, 2008
 */ 
/* abstract */ class Footprint implements SpaceCardDomainModel{
	boolean remove() {
		return ModelUtils.delete(this)
	}
	Footprint update() {
		date = new Date()
		return this
	}
	/////////////////////////////////////////////
	def beforeInsert = {
		ModelUtils.insertLog(this)
		onBeforeInsert(delegate)
	}
	def beforeUpdate = {
		ModelUtils.updateLog(this)
		onBeforeUpdate(delegate)
	}
	def beforeDelete = {
		ModelUtils.deleteLog(this)
		onBeforeDelete(delegate)
	}
	/////////////////////////////////////////////
	protected onBeforeInsert(obj) {
		obj.ip = RequestUtils.getExternalIpForLogging()		
	}
	protected onBeforeUpdate(obj) {
		obj.ip = RequestUtils.getExternalIpForLogging()
	}
	protected onBeforeDelete(obj) {
		/* don't delete*/		
	}	
	/////////////////////////////////////////////
	static constraints = {
		user(nullable:false)
		date(nullable:false)
		ip(nullable:true)
	}
	/////////////////////////////////////////////
	User user
	Date date = new Date()
	String ip
}
