/*
 * Decompiled with CFR 0.152.
 */
package macromedia.abc;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class BytecodeBuffer {
    private byte[] bytecodes;
    private int pos;
    private int size;

    public BytecodeBuffer(byte[] byArray) {
        this.bytecodes = byArray;
        this.size = byArray.length;
        this.pos = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BytecodeBuffer(String string) throws IOException {
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
            this.bytecodes = new byte[bufferedInputStream.available()];
            bufferedInputStream.read(this.bytecodes);
            this.size = this.bytecodes.length;
            this.pos = 0;
        }
        finally {
            if (bufferedInputStream != null) {
                try {
                    bufferedInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public BytecodeBuffer(int n) {
        n = n <= 0 ? 1000 : n;
        this.bytecodes = new byte[n];
        this.size = 0;
        this.pos = 0;
    }

    public void clear() {
        this.pos = 0;
        this.size = 0;
    }

    public int pos() {
        return this.pos;
    }

    public int size() {
        return this.size;
    }

    public void delete(int n) {
        this.size -= n;
    }

    public void writeS8(int n) {
        this.writeU8(n);
    }

    public void writeU8(int n) {
        this.resize(1);
        this.bytecodes[this.size++] = (byte)n;
    }

    public void writeU8(int n, int n2) {
        this.bytecodes[n] = (byte)n2;
    }

    public void writeU16(int n) {
        this.resize(2);
        this.bytecodes[this.size++] = (byte)n;
        this.bytecodes[this.size++] = (byte)(n >> 8);
    }

    public void writeS24(int n) {
        this.writeU24(n);
    }

    public void writeS24(int n, int n2) {
        this.bytecodes[n] = (byte)n2;
        this.bytecodes[n + 1] = (byte)(n2 >> 8);
        this.bytecodes[n + 2] = (byte)(n2 >> 16);
    }

    public void writeU24(int n) {
        this.resize(3);
        this.bytecodes[this.size++] = (byte)n;
        this.bytecodes[this.size++] = (byte)(n >> 8);
        this.bytecodes[this.size++] = (byte)(n >> 16);
    }

    public void writeU32(long l) {
        this.resize(4);
        if (l < 128L && l > -1L) {
            this.bytecodes[this.size++] = (byte)l;
        } else if (l < 16384L && l > -1L) {
            this.bytecodes[this.size++] = (byte)(l & 0x7FL | 0x80L);
            this.bytecodes[this.size++] = (byte)(l >> 7 & 0x7FL);
        } else if (l < 0x200000L && l > -1L) {
            this.bytecodes[this.size++] = (byte)(l & 0x7FL | 0x80L);
            this.bytecodes[this.size++] = (byte)(l >> 7 | 0x80L);
            this.bytecodes[this.size++] = (byte)(l >> 14 & 0x7FL);
        } else if (l < 0x10000000L && l > -1L) {
            this.bytecodes[this.size++] = (byte)(l & 0x7FL | 0x80L);
            this.bytecodes[this.size++] = (byte)(l >> 7 | 0x80L);
            this.bytecodes[this.size++] = (byte)(l >> 14 | 0x80L);
            this.bytecodes[this.size++] = (byte)(l >> 21 & 0x7FL);
        } else {
            this.bytecodes[this.size++] = (byte)(l & 0x7FL | 0x80L);
            this.bytecodes[this.size++] = (byte)(l >> 7 | 0x80L);
            this.bytecodes[this.size++] = (byte)(l >> 14 | 0x80L);
            this.bytecodes[this.size++] = (byte)(l >> 21 | 0x80L);
            this.bytecodes[this.size++] = (byte)(l >> 28 & 0xFL);
        }
    }

    public void writeDouble(double d) {
        this.resize(8);
        long l = Double.doubleToLongBits(d);
        this.bytecodes[this.size++] = (byte)l;
        this.bytecodes[this.size++] = (byte)(l >> 8);
        this.bytecodes[this.size++] = (byte)(l >> 16);
        this.bytecodes[this.size++] = (byte)(l >> 24);
        this.bytecodes[this.size++] = (byte)(l >> 32);
        this.bytecodes[this.size++] = (byte)(l >> 40);
        this.bytecodes[this.size++] = (byte)(l >> 48);
        this.bytecodes[this.size++] = (byte)(l >> 56);
    }

    public void writeBytes(BytecodeBuffer bytecodeBuffer, int n, int n2) {
        this.resize(n2 - n);
        for (int i = n; i < n2; ++i) {
            this.bytecodes[this.size++] = bytecodeBuffer.bytecodes[i];
        }
    }

    private void resize(int n) {
        if (this.size + n > this.bytecodes.length) {
            byte[] byArray = new byte[this.bytecodes.length * 3 / 2 + 1];
            System.arraycopy(this.bytecodes, 0, byArray, 0, this.bytecodes.length);
            this.bytecodes = byArray;
        }
    }

    public int readU8() {
        int n = this.bytecodes[this.pos] & 0xFF;
        ++this.pos;
        return n;
    }

    public int readU8(int n) {
        return this.bytecodes[n] & 0xFF;
    }

    public int readU16() {
        return this.readU8() | this.readU8() << 8;
    }

    public int readU32() {
        int n = this.readU8();
        if (0 == (n & 0x80)) {
            return n;
        }
        if (0 == ((n = n & 0x7F | this.readU8() << 7) & 0x4000)) {
            return n;
        }
        if (0 == ((n = n & 0x3FFF | this.readU8() << 14) & 0x200000)) {
            return n;
        }
        if (0 == ((n = n & 0x1FFFFF | this.readU8() << 21) & 0x10000000)) {
            return n;
        }
        return n & 0xFFFFFFF | this.readU8() << 28;
    }

    public long readU32(int n) {
        int n2;
        if (0 == ((n2 = this.readU8(n++)) & 0x80)) {
            return n2;
        }
        if (0 == ((n2 = n2 & 0x7F | this.readU8(n++) << 7) & 0x4000)) {
            return n2;
        }
        if (0 == ((n2 = n2 & 0x3FFF | this.readU8(n++) << 14) & 0x200000)) {
            return n2;
        }
        if (0 == ((n2 = n2 & 0x1FFFFF | this.readU8(n++) << 21) & 0x10000000)) {
            return n2;
        }
        return n2 & 0xFFFFFFF | this.readU8(n++) << 28;
    }

    public int readS8() {
        byte by = this.bytecodes[this.pos];
        ++this.pos;
        return by;
    }

    public int readS24() {
        return this.readU8() | this.readU8() << 8 | this.readS8() << 16;
    }

    public double readDouble() {
        long l = this.readU8() | this.readU8() << 8 | this.readU8() << 16 | this.readU8() << 24;
        long l2 = this.readU8() | this.readU8() << 8 | this.readU8() << 16 | this.readU8() << 24;
        return Double.longBitsToDouble(l & 0xFFFFFFFFL | l2 << 32);
    }

    public byte[] readBytes(int n) {
        byte[] byArray = new byte[n];
        System.arraycopy(this.bytecodes, this.pos, byArray, 0, n);
        this.pos += n;
        return byArray;
    }

    public String readString(int n) {
        try {
            return new String(this.bytecodes, this.pos, n, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public void close() {
        this.pos = 0;
    }

    public void skip(long l) {
        this.pos = (int)((long)this.pos + l);
    }

    public void skipEntries(long l) {
        for (long i = 0L; i < l; ++i) {
            this.readU32();
        }
    }

    public void seek(int n) {
        this.pos = n;
    }

    public boolean same(BytecodeBuffer bytecodeBuffer, int n, int n2, int n3, int n4) {
        if (n2 - n != n4 - n3) {
            return false;
        }
        int n5 = n;
        int n6 = n3;
        while (n5 < n2) {
            if (this.bytecodes[n5] != bytecodeBuffer.bytecodes[n6]) {
                return false;
            }
            ++n5;
            ++n6;
        }
        return true;
    }

    public int hashCode(int n, int n2) {
        long l = 1234L;
        for (int i = n; i < n2; ++i) {
            l ^= (long)this.bytecodes[i];
        }
        return (int)(l >> 32 ^ l);
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.bytecodes, 0, this.size);
    }

    public int minorVersion() {
        return this.bytecodes[0] & 0xFF | (this.bytecodes[1] & 0xFF) << 8;
    }
}

