/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.mxml.rep;

import flash.util.StringUtils;
import flex2.compiler.CompilationUnit;
import flex2.compiler.Context;
import flex2.compiler.css.Styles;
import flex2.compiler.css.StylesContainer;
import flex2.compiler.mxml.Configuration;
import flex2.compiler.mxml.gen.CodeFragmentList;
import flex2.compiler.mxml.gen.DescriptorGenerator;
import flex2.compiler.mxml.gen.TextGen;
import flex2.compiler.mxml.lang.FrameworkDefs;
import flex2.compiler.mxml.lang.StandardDefs;
import flex2.compiler.mxml.reflect.Property;
import flex2.compiler.mxml.reflect.Type;
import flex2.compiler.mxml.reflect.TypeTable;
import flex2.compiler.mxml.rep.AtEmbed;
import flex2.compiler.mxml.rep.AtResource;
import flex2.compiler.mxml.rep.BindingExpression;
import flex2.compiler.mxml.rep.DocumentInfo;
import flex2.compiler.mxml.rep.Model;
import flex2.compiler.mxml.rep.MovieClip;
import flex2.compiler.mxml.rep.Script;
import flex2.compiler.mxml.rep.decl.InitializedPropertyDeclaration;
import flex2.compiler.mxml.rep.decl.PropertyDeclaration;
import flex2.compiler.mxml.rep.decl.UninitializedPropertyDeclaration;
import flex2.compiler.mxml.rep.init.ValueInitializer;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.DualModeLineNumberMap;
import flex2.compiler.util.IteratorList;
import flex2.compiler.util.NameFormatter;
import flex2.compiler.util.QName;
import flex2.compiler.util.ThreadLocalToolkit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.iterators.FilterIterator;
import org.apache.commons.collections.iterators.IteratorChain;

public final class MxmlDocument {
    private final CompilationUnit unit;
    private final TypeTable typeTable;
    private final DocumentInfo info;
    private Model root;
    private final Map declarations;
    private final List bindingExpressions;
    private final Map atEmbeds;
    private final Map atResources;
    private final Set typeRefs;
    private final StylesContainer stylesContainer;
    private String preloader;
    private boolean usePreloader;
    private DualModeLineNumberMap lineNumberMap;
    private Map anonIdCounts;
    private boolean bindingImportsAdded;
    static final /* synthetic */ boolean $assertionsDisabled;

    public MxmlDocument(CompilationUnit unit, TypeTable typeTable, DocumentInfo info, Configuration configuration) {
        this.unit = unit;
        this.typeTable = typeTable;
        this.info = info;
        this.root = null;
        this.declarations = new TreeMap();
        this.bindingExpressions = new ArrayList();
        this.atEmbeds = new TreeMap();
        this.atResources = new TreeMap();
        this.typeRefs = new TreeSet();
        this.stylesContainer = new StylesContainer(unit, typeTable.getPerCompileData(), configuration);
        this.stylesContainer.setMxmlDocument(this);
        this.preloader = NameFormatter.toDot("mx.preloaders:DownloadProgressBar");
        this.usePreloader = true;
        this.lineNumberMap = null;
        this.anonIdCounts = new HashMap();
        this.bindingImportsAdded = false;
        Context context = unit.getContext();
        context.setAttribute("BindingExpressions", this.bindingExpressions);
    }

    public final CompilationUnit getCompilationUnit() {
        return this.unit;
    }

    public final String getSourcePath() {
        return this.unit.getSource().getName();
    }

    public final boolean getIsMain() {
        return this.unit.isRoot();
    }

    public final TypeTable getTypeTable() {
        return this.typeTable;
    }

    public final String getClassName() {
        return this.info.getClassName();
    }

    public final String getConvertedClassName() {
        return "_" + StringUtils.substitute((String)this.getClassName(), (String)".", (String)"_");
    }

    public final String getPackageName() {
        return this.info.getPackageName();
    }

    public final QName getQName() {
        return this.info.getQName();
    }

    public final Type getSuperClass() {
        return this.getRoot().getType();
    }

    public final String getSuperClassName() {
        return NameFormatter.toDot(this.getSuperClass().getName());
    }

    public final boolean getHasInterfaces() {
        return this.info.getInterfaceNames().size() > 0;
    }

    public final boolean getIsInlineComponent() {
        return this.info.getRootNode().isInlineComponent();
    }

    public void setRoot(Model root) {
        String outerDocClassName;
        this.root = root;
        if (this.getIsContainer()) {
            this.addImport(NameFormatter.toDot(StandardDefs.CLASS_UICOMPONENTDESCRIPTOR), root.getXmlLineNumber());
        }
        if ((outerDocClassName = this.info.getRootNode().getOuterDocumentClassName()) != null) {
            this.addDeclaration("outerDocument", outerDocClassName, 0, false, true, false);
        }
    }

    public final Model getRoot() {
        if (!$assertionsDisabled && this.root == null) {
            throw new AssertionError((Object)"root component not set");
        }
        return this.root;
    }

    public final void addDeclaration(Model model, boolean topLevel) {
        if (!this.inheritedPropertyUsageError(model.getId(), model.getType(), model.getXmlLineNumber())) {
            this.declarations.put(model.getId(), new InitializedPropertyDeclaration(model, topLevel, model.getXmlLineNumber()));
        }
    }

    public final void addDeclaration(String id, String typeName, int line, boolean inspectable, boolean topLevel, boolean idIsAutogenerated) {
        if (!this.inheritedPropertyUsageError(id, this.root.getType().getTypeTable().getType(typeName), line)) {
            this.declarations.put(id, new UninitializedPropertyDeclaration(id, typeName, line, inspectable, topLevel, idIsAutogenerated));
        }
    }

    public final void ensureDeclaration(Model model) {
        if (!this.isDeclared(model)) {
            this.addDeclaration(model, false);
        }
    }

    public final boolean isDeclared(Model model) {
        String id = model.getId();
        return id != null && this.isDeclared(id);
    }

    public final boolean isDeclared(String id) {
        return this.declarations.containsKey(id);
    }

    public final Iterator getDeclarationIterator() {
        final Type superType = this.getSuperClass();
        return new FilterIterator(this.declarations.values().iterator(), new Predicate(){

            public boolean evaluate(Object object) {
                return superType.getProperty(((PropertyDeclaration)object).getName()) == null;
            }
        });
    }

    private final Iterator getTopLevelDeclarationIterator() {
        return new FilterIterator(this.declarations.values().iterator(), new Predicate(){

            public boolean evaluate(Object object) {
                return ((PropertyDeclaration)object).getTopLevel();
            }
        });
    }

    private final Iterator getTopLevelInitializerIterator() {
        return new FilterIterator(this.getTopLevelDeclarationIterator(), new Predicate(){

            public boolean evaluate(Object object) {
                return object instanceof InitializedPropertyDeclaration;
            }
        });
    }

    public final Iterator getPropertyInitializerIterator() {
        return new IteratorChain(this.root.getPropertyInitializerIterator(false), this.getTopLevelInitializerIterator());
    }

    public final Iterator getProceduralVisualChildInitializerIterator() {
        if (this.root instanceof MovieClip) {
            return new FilterIterator(((MovieClip)this.root).getChildInitializerIterator(), new Predicate(){

                public boolean evaluate(Object object) {
                    ValueInitializer init = (ValueInitializer)object;
                    Object value = init.getValue();
                    return !(value instanceof Model) || !((Model)value).isDescribed();
                }
            });
        }
        return Collections.EMPTY_LIST.iterator();
    }

    public final boolean getDescribeVisualChildren() {
        return true;
    }

    public final Iterator getDefinitionIterator() {
        IteratorList iterList = new IteratorList();
        Model.addDefinitionIterators(iterList, this.getTopLevelInitializerIterator());
        iterList.add(this.root.getSubDefinitionsIterator());
        return iterList.toIterator();
    }

    public final void addBindingExpression(BindingExpression expr) {
        expr.setId(this.bindingExpressions.size());
        this.bindingExpressions.add(expr);
        this.info.addInterfaceName(NameFormatter.toDot(StandardDefs.INTERFACE_IBINDINGCLIENT), -1);
    }

    public final List getBindingExpressions() {
        return this.bindingExpressions;
    }

    public final boolean addAtEmbed(AtEmbed atEmbed) {
        if (!this.atEmbeds.containsKey(atEmbed.getPropName())) {
            this.atEmbeds.put(atEmbed.getPropName(), atEmbed);
        }
        return true;
    }

    public final Collection getAtEmbeds() {
        return this.atEmbeds.values();
    }

    public final boolean addAtResource(AtResource atResource) {
        this.addImport(NameFormatter.toDot(StandardDefs.CLASS_RESOURCEMANAGER), atResource.getXmlLineNumber());
        this.atResources.put(atResource.getBundle(), atResource);
        return true;
    }

    public final Collection getAtResources() {
        return this.atResources.values();
    }

    public final void addTypeRef(String typeRef, int line) {
        this.addImport(typeRef, line);
        this.typeRefs.add(typeRef);
    }

    public final Collection getTypeRefs() {
        return this.typeRefs;
    }

    public final void addImport(String name, int line) {
        this.info.addImportName(name, line);
    }

    public final Collection getImports() {
        this.ensureBindingImports();
        return this.info.getImportNames();
    }

    private final void ensureBindingImports() {
        if (!this.bindingImportsAdded) {
            Iterator iter = this.bindingExpressions.iterator();
            while (iter.hasNext()) {
                BindingExpression expr = (BindingExpression)iter.next();
                this.addImport(expr.getDestinationTypeName(), expr.getXmlLineNumber());
            }
            this.bindingImportsAdded = true;
        }
    }

    public final void addScript(Script script) {
        this.info.addScript(script);
    }

    public final List getScripts() {
        return this.info.getScripts();
    }

    public final void addMetadata(Script metaDataSource) {
        String text = metaDataSource.getText();
        if (!$assertionsDisabled && text == null) {
            throw new AssertionError();
        }
        if (!text.startsWith("[")) {
            this.info.getMetadata().add(0, metaDataSource);
        } else {
            this.info.addMetadata(metaDataSource);
        }
    }

    public final List getMetadata() {
        return this.info.getMetadata();
    }

    public StylesContainer getStylesContainer() {
        return this.stylesContainer;
    }

    public Iterator getInheritingStyleNameIterator() {
        final Styles styles = this.typeTable.getStyles();
        return new FilterIterator(styles.getStyleNames(), new Predicate(){

            public boolean evaluate(Object obj) {
                return styles.isInheritingStyle((String)obj);
            }
        });
    }

    public boolean getIsContainer() {
        return StandardDefs.isContainer(this.root.getType());
    }

    public boolean getIsIUIComponent() {
        return StandardDefs.isIUIComponent(this.root.getType());
    }

    public final void setLineNumberMap(DualModeLineNumberMap lineNumberMap) {
        this.lineNumberMap = lineNumberMap;
    }

    public final DualModeLineNumberMap getLineNumberMap() {
        return this.lineNumberMap;
    }

    public final void setPreloader(String preloader) {
        this.preloader = preloader;
    }

    public final String getPreloader() {
        return this.preloader;
    }

    public void setUsePreloader(boolean usePreloader) {
        this.usePreloader = usePreloader;
    }

    public final boolean getUsePreloader() {
        return this.usePreloader;
    }

    public final boolean superHasPublicProperty(String name) {
        return this.getSuperClass().getProperty(name) != null;
    }

    void ensureId(Model model) {
        if (model.getId() == null) {
            Type type = model.getType();
            if (!$assertionsDisabled && type == null) {
                throw new AssertionError();
            }
            int i = this.getAnonIndex(model.getType());
            String id = "_" + NameFormatter.toDot(this.info.getClassName()).replace('.', '_') + "_" + NameFormatter.retrieveClassName(type.getName()) + i;
            model.setId(id, true);
        }
    }

    private int getAnonIndex(Type type) {
        String typeName = NameFormatter.retrieveClassName(type.getName());
        Integer cell = (Integer)this.anonIdCounts.get(typeName);
        int i = cell == null ? 1 : cell;
        this.anonIdCounts.put(typeName, new Integer(i + 1));
        return i;
    }

    public void resolveTwoWayBindings() {
        HashMap<String, BindingExpression> destinationMap = new HashMap<String, BindingExpression>();
        Iterator iterator = this.bindingExpressions.iterator();
        while (iterator.hasNext()) {
            BindingExpression bindingExpression = (BindingExpression)iterator.next();
            String sourceExpression = TextGen.stripParens(bindingExpression.getSourceExpression());
            String destinationPath = bindingExpression.getDestinationPath(false);
            BindingExpression match = (BindingExpression)destinationMap.get(sourceExpression);
            if (match != null && destinationPath.equals(TextGen.stripParens(match.getSourceExpression()))) {
                bindingExpression.setTwoWayCounterpart(match);
                continue;
            }
            destinationMap.put(destinationPath, bindingExpression);
        }
    }

    public String getInterfaceList() {
        ArrayList<String> names = new ArrayList<String>(this.info.getInterfaceNames().size());
        Iterator i = this.info.getInterfaceNames().iterator();
        while (i.hasNext()) {
            names.add(((DocumentInfo.NameInfo)i.next()).getName());
        }
        return TextGen.toCommaList(names.iterator());
    }

    public String getWatcherSetupUtilClassName() {
        StringBuffer stringBuffer = new StringBuffer("_");
        String packageName = this.getPackageName();
        if (packageName != null && packageName.length() > 0) {
            stringBuffer.append(packageName.replace('.', '_'));
            stringBuffer.append("_");
        }
        stringBuffer.append(this.getClassName());
        stringBuffer.append("WatcherSetupUtil");
        return stringBuffer.toString();
    }

    public CodeFragmentList getDescriptorDeclaration(String name) {
        CodeFragmentList fragList = DescriptorGenerator.getDescriptorInitializerFragments(this.getRoot(), FrameworkDefs.requiredTopLevelDescriptorProperties);
        fragList.add(0, "private var " + name + " : " + NameFormatter.toDot(StandardDefs.CLASS_UICOMPONENTDESCRIPTOR) + " = ", 0);
        return fragList;
    }

    private final boolean inheritedPropertyUsageError(String name, Type type, int line) {
        if (!$assertionsDisabled && this.root == null) {
            throw new AssertionError((Object)"root null in checkInherited");
        }
        Property prop = this.root.getType().getProperty(name);
        if (prop != null) {
            if (!prop.hasPublic()) {
                ThreadLocalToolkit.log((CompilerMessage)new NonPublicInheritedPropertyInit(name), this.getSourcePath(), line);
                return true;
            }
            if (prop.readOnly()) {
                ThreadLocalToolkit.log((CompilerMessage)new ReadOnlyInheritedPropertyInit(name), this.getSourcePath(), line);
                return true;
            }
            if (!type.isAssignableTo(prop.getType())) {
                ThreadLocalToolkit.log((CompilerMessage)new TypeIncompatibleInheritedPropertyInit(name, NameFormatter.toDot(prop.getType().getName()), NameFormatter.toDot(type.getName())), this.getSourcePath(), line);
                return true;
            }
        }
        return false;
    }

    public static List getBindingManagementVars() {
        return FrameworkDefs.bindingManagementVars;
    }

    static {
        $assertionsDisabled = !MxmlDocument.class.desiredAssertionStatus();
    }

    public static class TypeIncompatibleInheritedPropertyInit
    extends CompilerMessage.CompilerError {
        public String name;
        public String propertyType;
        public String valueType;

        public TypeIncompatibleInheritedPropertyInit(String name, String propertyType, String valueType) {
            this.name = name;
            this.propertyType = propertyType;
            this.valueType = valueType;
        }
    }

    public static class ReadOnlyInheritedPropertyInit
    extends CompilerMessage.CompilerError {
        public String name;

        public ReadOnlyInheritedPropertyInit(String name) {
            this.name = name;
        }
    }

    public static class NonPublicInheritedPropertyInit
    extends CompilerMessage.CompilerError {
        public String name;

        public NonPublicInheritedPropertyInit(String name) {
            this.name = name;
        }
    }
}

