/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.io;

import com.adobe.internal.io.ByteReader;
import com.adobe.internal.io.ProxyRandomAccessFile;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import junit.framework.TestCase;

public abstract class ByteReaderTestsBase
extends TestCase {
    private static final long MAX_FILE_CREATION_SIZE = 0x100000L;
    private RandomAccessFile brRAF = null;
    private RandomAccessFile testRAF = null;
    private File testFile = null;
    private ByteReader byteReader;
    private static final long DEFAULT_TESTFILE_LENGTH = 666666L;
    private static final int backStepIteration = 4;
    private static final double backStepAmount = 2.5;
    private static final int LINEAR_MAX_BUFFER_SIZE = 730000;

    protected void setUp() throws Exception {
        super.setUp();
        long testFileLength = Long.getLong("com.adobe.internal.rideau.io.TestFileLength", this.getTestFileLength());
        if (this.needsRealFile()) {
            testFileLength = Math.min(testFileLength, 0x100000L);
        }
        this.testRAF = new ProxyRandomAccessFile(testFileLength);
        if (this.needsRealFile()) {
            this.testFile = this.buildTestFile(this.testRAF);
            this.brRAF = new RandomAccessFile(this.testFile, "r");
        } else {
            this.testFile = null;
            this.brRAF = this.testRAF;
        }
        this.byteReader = this.createByteReader(this.brRAF);
    }

    private File buildTestFile(RandomAccessFile source) throws IOException {
        File tempFilePath = new File("logs/output/com/adobe/internal/io");
        tempFilePath.mkdirs();
        File tempFile = File.createTempFile("BRTempFile", "tmp", tempFilePath);
        RandomAccessFile copyRAF = new RandomAccessFile(tempFile, "rw");
        byte[] buffer = new byte[4096];
        int bytesRead = 0;
        while ((bytesRead = source.read(buffer)) != -1) {
            copyRAF.write(buffer, 0, bytesRead);
        }
        copyRAF.close();
        return tempFile;
    }

    protected abstract ByteReader createByteReader(RandomAccessFile var1) throws IOException;

    protected boolean needsRealFile() {
        return false;
    }

    protected File getRealFile() {
        return this.testFile;
    }

    protected long getTestFileLength() {
        return 666666L;
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.byteReader.close();
        this.testRAF.close();
        if (this.testFile != null) {
            this.testFile.delete();
        }
    }

    private int readFromRepository(long position) throws IOException {
        this.testRAF.seek(position);
        return this.testRAF.read();
    }

    private long lengthRepository() throws IOException {
        return this.testRAF.length();
    }

    public final void testEOF() throws Exception {
        System.out.print("\tEOF Test - ");
        int byteRead = this.byteReader.read(this.byteReader.length());
        ByteReaderTestsBase.assertTrue((byteRead == -1 ? 1 : 0) != 0);
        byteRead = this.byteReader.read(this.byteReader.length() + 1L);
        ByteReaderTestsBase.assertTrue((byteRead == -1 ? 1 : 0) != 0);
        byteRead = this.byteReader.read(this.byteReader.length() * 2L);
        ByteReaderTestsBase.assertTrue((byteRead == -1 ? 1 : 0) != 0);
        System.out.println("Completed");
    }

    public final void testLinearSingleByteRead() throws Exception {
        System.out.print("\tLinear Single Byte Read Test - ");
        ByteReaderTestsBase.assertTrue((this.lengthRepository() == this.byteReader.length() ? 1 : 0) != 0);
        for (long i = 0L; i < this.byteReader.length(); ++i) {
            ByteReaderTestsBase.assertTrue(((this.readFromRepository(i) & 0xFF) == this.byteReader.read(i) ? 1 : 0) != 0);
        }
        System.out.println("Completed");
    }

    public final void testNonLinearSingleByteRead() throws Exception {
        System.out.print("\tNon-Linear Single Byte Read Test - ");
        ByteReaderTestsBase.assertTrue((this.lengthRepository() == this.byteReader.length() ? 1 : 0) != 0);
        int numberOfPasses = 5;
        for (int offset = 0; offset < numberOfPasses; ++offset) {
            for (long i = (long)offset; i < this.byteReader.length(); i += (long)numberOfPasses) {
                ByteReaderTestsBase.assertTrue(((this.readFromRepository(i) & 0xFF) == this.byteReader.read(i) ? 1 : 0) != 0);
            }
        }
        System.out.println("Completed");
    }

    public final void testLinearMultiByteRead() throws Exception {
        System.out.print("\tLinear Multibyte Read Test - ");
        for (int bufferSize = 7; bufferSize < 730000; bufferSize *= 7) {
            int bytesRead;
            long position = 0L;
            byte[] buffer = new byte[bufferSize];
            int iteration = 0;
            while ((bytesRead = this.byteReader.read(position, buffer, 0, bufferSize)) != -1) {
                for (int i = 0; i < Math.min(buffer.length, bytesRead); ++i) {
                    ByteReaderTestsBase.assertTrue(((buffer[i] & 0xFF) == (this.readFromRepository(position + (long)i) & 0xFF) ? 1 : 0) != 0);
                }
                if (iteration % 4 == 0) {
                    position = (long)((double)position - (double)bufferSize * 2.5);
                    continue;
                }
                position += (long)bytesRead;
            }
        }
        System.out.println("Completed");
    }

    public final void testNonLinearMultiByteRead() throws Exception {
        System.out.print("\tNon-Linear Multibyte Read Test - ");
        for (int bufferStep = 1; bufferStep < 6; ++bufferStep) {
            int bufferSize = (int)(Math.pow(bufferStep, 5.0) * 7.0);
            byte[] buffer = new byte[bufferSize];
            int numberOfPasses = 5;
            int stepSize = numberOfPasses * bufferSize;
            for (int pass = 0; pass < numberOfPasses; ++pass) {
                int bytesRead;
                long position = stepSize * pass;
                while ((bytesRead = this.byteReader.read(position, buffer, 0, bufferSize)) != -1) {
                    for (int i = 0; i < Math.min(buffer.length, bytesRead); ++i) {
                        ByteReaderTestsBase.assertTrue(((buffer[i] & 0xFF) == (this.readFromRepository(position + (long)i) & 0xFF) ? 1 : 0) != 0);
                    }
                    position += (long)stepSize;
                }
            }
        }
        System.out.println("Completed");
    }
}

