/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.services.remoting.adapters;

import flex.management.BaseControl;
import flex.management.runtime.messaging.services.remoting.adapters.JavaAdapterControl;
import flex.messaging.Destination;
import flex.messaging.FactoryInstance;
import flex.messaging.FlexComponent;
import flex.messaging.MessageException;
import flex.messaging.config.ConfigMap;
import flex.messaging.config.ConfigurationException;
import flex.messaging.config.SecurityConstraint;
import flex.messaging.log.Log;
import flex.messaging.messages.Message;
import flex.messaging.messages.RemotingMessage;
import flex.messaging.security.SecurityException;
import flex.messaging.services.ServiceAdapter;
import flex.messaging.services.remoting.RemotingDestination;
import flex.messaging.services.remoting.adapters.RemotingMethod;
import flex.messaging.util.ExceptionUtil;
import flex.messaging.util.MethodMatcher;
import flex.messaging.util.StringUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class JavaAdapter
extends ServiceAdapter {
    static final String LOG_CATEGORY = "Message.Remoting";
    public static final String[] PROTECTED_PACKAGES = new String[]{"jrun", "jrunx", "macromedia", "flex", "flex2", "coldfusion", "allaire", "com.allaire", "com.macromedia"};
    private static final int REMOTING_METHOD_NULL_NAME_ERRMSG = 10658;
    private static final int REMOTING_METHOD_REFS_UNDEFINED_CONSTRAINT_ERRMSG = 10659;
    private static final int REMOTING_METHOD_NOT_DEFINED_ERRMSG = 10660;
    private static final String PROPERTY_INCLUDE_METHODS = "include-methods";
    private static final String PROPERTY_EXCLUDE_METHODS = "exclude-methods";
    private static final String METHOD_ELEMENT = "method";
    private static final String NAME_ELEMENT = "name";
    private JavaAdapterControl controller;
    private Map excludeMethods;
    private Map includeMethods;

    public JavaAdapter() {
        this(false);
    }

    public JavaAdapter(boolean enableManagement) {
        super(enableManagement);
    }

    public void setDestination(Destination destination) {
        RemotingDestination dest = (RemotingDestination)destination;
        super.setDestination((Destination)dest);
    }

    public Iterator getExcludeMethodIterator() {
        if (this.excludeMethods == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return this.excludeMethods.values().iterator();
    }

    public void addExcludeMethod(RemotingMethod value) {
        String name = value.getName();
        if (name == null) {
            ConfigurationException ce = new ConfigurationException();
            ce.setMessage(10658, new Object[]{this.getDestination().getId()});
            throw ce;
        }
        if (!this.isMethodDefinedBySource(name)) {
            ConfigurationException ce = new ConfigurationException();
            ce.setMessage(10660, new Object[]{name, this.getDestination().getId()});
            throw ce;
        }
        if (this.excludeMethods == null) {
            this.excludeMethods = new HashMap();
            this.excludeMethods.put(name, value);
        } else if (!this.excludeMethods.containsKey(name)) {
            this.excludeMethods.put(name, value);
        }
    }

    public void removeExcludeMethod(RemotingMethod value) {
        this.excludeMethods.remove(value.getName());
    }

    public Iterator getIncludeMethodIterator() {
        if (this.includeMethods == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return this.includeMethods.values().iterator();
    }

    public void addIncludeMethod(RemotingMethod value) {
        String name = value.getName();
        if (name == null) {
            ConfigurationException ce = new ConfigurationException();
            ce.setMessage(10658, new Object[]{this.getDestination().getId()});
            throw ce;
        }
        if (!this.isMethodDefinedBySource(name)) {
            ConfigurationException ce = new ConfigurationException();
            ce.setMessage(10660, new Object[]{name, this.getDestination().getId()});
            throw ce;
        }
        if (this.includeMethods == null) {
            this.includeMethods = new HashMap();
            this.includeMethods.put(name, value);
        } else if (!this.includeMethods.containsKey(name)) {
            this.includeMethods.put(name, value);
        }
    }

    public void removeIncludeMethod(RemotingMethod value) {
        this.includeMethods.remove(value.getName());
    }

    public void initialize(String id, ConfigMap properties) {
        ConfigMap methodsToExclude;
        List methods;
        ConfigMap methodsToInclude = properties.getPropertyAsMap(PROPERTY_INCLUDE_METHODS, null);
        if (methodsToInclude != null && (methods = methodsToInclude.getPropertyAsList(METHOD_ELEMENT, null)) != null && !methods.isEmpty()) {
            int n = methods.size();
            for (int i = 0; i < n; ++i) {
                ConfigMap methodSettings = (ConfigMap)methods.get(i);
                String name = methodSettings.getPropertyAsString(NAME_ELEMENT, null);
                RemotingMethod method = new RemotingMethod();
                method.setName(name);
                String constraintRef = methodSettings.getPropertyAsString("security-constraint", null);
                if (constraintRef != null) {
                    try {
                        method.setSecurityConstraint(this.getDestination().getService().getMessageBroker().getSecurityConstraint(constraintRef));
                    }
                    catch (SecurityException se) {
                        ConfigurationException ce = new ConfigurationException();
                        ce.setMessage(10659, new Object[]{name, this.getDestination().getId(), constraintRef});
                        throw ce;
                    }
                }
                this.addIncludeMethod(method);
            }
        }
        if ((methodsToExclude = properties.getPropertyAsMap(PROPERTY_EXCLUDE_METHODS, null)) != null) {
            List methods2;
            if (this.includeMethods != null) {
                RemotingDestination dest = (RemotingDestination)this.getDestination();
                if (Log.isWarn()) {
                    Log.getLogger((String)"Configuration").warn("The remoting destination '" + dest.getId() + "' contains both <include-methods/> and <exclude-methods/> configuration. The <exclude-methods/> block will be ignored.");
                }
            }
            if ((methods2 = methodsToExclude.getPropertyAsList(METHOD_ELEMENT, null)) != null && !methods2.isEmpty()) {
                int n = methods2.size();
                for (int i = 0; i < n; ++i) {
                    ConfigMap methodSettings = (ConfigMap)methods2.get(i);
                    String name = methodSettings.getPropertyAsString(NAME_ELEMENT, null);
                    RemotingMethod method = new RemotingMethod();
                    method.setName(name);
                    String constraintRef = methodSettings.getPropertyAsString("security-constraint", null);
                    if (this.includeMethods != null) continue;
                    if (constraintRef != null) {
                        RemotingDestination dest = (RemotingDestination)this.getDestination();
                        if (Log.isWarn()) {
                            Log.getLogger((String)"Configuration").warn("The method '" + name + "' for remoting destination '" + dest.getId() + "' is configured to use a security constraint, but security constraints are not applicable for excluded methods.");
                        }
                    }
                    this.addExcludeMethod(method);
                }
            }
        }
    }

    public void start() {
        if (this.isStarted()) {
            return;
        }
        super.start();
        this.validateInstanceSettings();
        RemotingDestination remotingDestination = (RemotingDestination)this.getDestination();
        if ("application".equals(remotingDestination.getScope())) {
            FactoryInstance factoryInstance = remotingDestination.getFactoryInstance();
            this.createInstance(factoryInstance.getInstanceClass());
        }
    }

    public Object invoke(Message message) {
        RemotingDestination remotingDestination = (RemotingDestination)this.getDestination();
        RemotingMessage remotingMessage = (RemotingMessage)message;
        FactoryInstance factoryInstance = remotingDestination.getFactoryInstance();
        String className = factoryInstance.getSource();
        remotingMessage.setSource(className);
        String methodName = remotingMessage.getOperation();
        List parameters = remotingMessage.getParameters();
        Object result = null;
        try {
            if (this.includeMethods != null) {
                SecurityConstraint constraint;
                RemotingMethod method = (RemotingMethod)this.includeMethods.get(methodName);
                if (method == null) {
                    MethodMatcher.methodNotFound((String)methodName, null, (MethodMatcher.Match)new MethodMatcher.Match(null));
                }
                if ((constraint = method.getSecurityConstraint()) != null) {
                    this.getDestination().getService().getMessageBroker().getLoginManager().checkConstraint(constraint);
                }
            } else if (this.excludeMethods != null && this.excludeMethods.containsKey(methodName)) {
                MethodMatcher.methodNotFound((String)methodName, null, (MethodMatcher.Match)new MethodMatcher.Match(null));
            }
            Object instance = this.createInstance(factoryInstance.getInstanceClass());
            if (instance == null) {
                MessageException me = new MessageException("Null instance returned from: " + factoryInstance);
                me.setCode("Server.Processing");
                throw me;
            }
            Class<?> c = instance.getClass();
            MethodMatcher methodMatcher = remotingDestination.getMethodMatcher();
            Method method = methodMatcher.getMethod(c, methodName, parameters);
            result = method.invoke(instance, parameters.toArray());
            this.saveInstance(instance);
        }
        catch (InvocationTargetException ex) {
            Throwable cause = ex.getCause();
            if (cause != null && cause instanceof MessageException) {
                throw (MessageException)cause;
            }
            if (cause != null) {
                if (Log.isError()) {
                    Log.getLogger((String)LOG_CATEGORY).error("Error processing remote invocation: " + cause.toString() + StringUtils.NEWLINE + "  incomingMessage: " + message + StringUtils.NEWLINE + ExceptionUtil.toString((Throwable)cause));
                }
                MessageException me = new MessageException(cause.getClass().getName() + " : " + cause.getMessage());
                me.setCode("Server.Processing");
                me.setRootCause(cause);
                throw me;
            }
            MessageException me = new MessageException(ex.getMessage());
            me.setCode("Server.Processing");
            throw me;
        }
        catch (IllegalAccessException ex) {
            MessageException me = new MessageException(ex.getMessage());
            me.setCode("Server.Processing");
            throw me;
        }
        return result;
    }

    protected Object createInstance(Class cl) {
        RemotingDestination remotingDestination = (RemotingDestination)this.getDestination();
        FactoryInstance factoryInstance = remotingDestination.getFactoryInstance();
        Object instance = factoryInstance.lookup();
        if (this.isStarted() && instance instanceof FlexComponent && !((FlexComponent)instance).isStarted()) {
            ((FlexComponent)instance).start();
        }
        return instance;
    }

    protected void saveInstance(Object instance) {
        RemotingDestination remotingDestination = (RemotingDestination)this.getDestination();
        FactoryInstance factoryInstance = remotingDestination.getFactoryInstance();
        factoryInstance.operationComplete(instance);
    }

    protected void assertAccess(String serviceClass) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            if (serviceClass.indexOf(".") != -1) {
                StringBuffer permissionData = new StringBuffer("accessClassInPackage.");
                permissionData.append(serviceClass.substring(0, serviceClass.lastIndexOf(".")));
                RuntimePermission perm = new RuntimePermission(permissionData.toString());
                AccessController.checkPermission(perm);
            }
        } else {
            for (int i = 0; i < PROTECTED_PACKAGES.length; ++i) {
                if (!serviceClass.startsWith(PROTECTED_PACKAGES[i])) continue;
                StringBuffer permissionData = new StringBuffer("accessClassInPackage.");
                permissionData.append(PROTECTED_PACKAGES[i].substring(0, PROTECTED_PACKAGES[i].length()));
                RuntimePermission perm = new RuntimePermission(permissionData.toString());
                AccessController.checkPermission(perm);
            }
        }
    }

    protected void validateInstanceSettings() {
        RemotingDestination remotingDestination = (RemotingDestination)this.getDestination();
        remotingDestination.getFactoryInstance();
    }

    protected String getLogCategory() {
        return LOG_CATEGORY;
    }

    protected void setupAdapterControl(Destination destination) {
        this.controller = new JavaAdapterControl(this, destination.getControl());
        this.controller.register();
        this.setControl((BaseControl)this.controller);
    }

    private boolean isMethodDefinedBySource(String methodName) {
        RemotingDestination remotingDestination = (RemotingDestination)this.getDestination();
        FactoryInstance factoryInstance = remotingDestination.getFactoryInstance();
        Class c = factoryInstance.getInstanceClass();
        if (c == null) {
            return true;
        }
        Method[] methods = c.getMethods();
        int n = methods.length;
        for (int i = 0; i < n; ++i) {
            if (!methods[i].getName().equals(methodName)) continue;
            return true;
        }
        return false;
    }
}

