/*
 * Decompiled with CFR 0.152.
 */
package macromedia.asc.embedding;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import macromedia.asc.embedding.Main;
import macromedia.asc.util.ObjectList;

public class Shell {
    private static int counter;
    private static boolean exit;
    private static Map targets;
    private static Map processes;

    public static void main(String[] stringArray) throws IOException {
        String string;
        exit = false;
        counter = 1;
        targets = new HashMap();
        processes = new HashMap();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        Shell.intro();
        Shell.prompt();
        while ((string = bufferedReader.readLine()) != null) {
            try {
                Shell.process(string);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            if (exit) break;
            Shell.prompt();
        }
    }

    private static void process(String string) {
        block44: {
            if (string.startsWith("asc")) {
                StringTokenizer stringTokenizer = new StringTokenizer(string.substring("asc".length()).trim(), " ");
                String[] stringArray = new String[stringTokenizer.countTokens()];
                int n = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    stringArray[n] = stringTokenizer.nextToken();
                    ++n;
                }
                if (stringArray.length == 1) {
                    try {
                        n = Integer.parseInt(stringArray[0]);
                        Target target = (Target)targets.get("" + n);
                        if (target == null) {
                            System.out.println("ash: Target " + n + " not found");
                            break block44;
                        }
                        Shell.asc(target.args, n);
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("ash: Assigned " + counter + " as the compile target id");
                        Shell.asc(stringArray, counter++);
                    }
                } else {
                    System.out.println("ash: Assigned " + counter + " as the compile target id");
                    Shell.asc(stringArray, counter++);
                }
            } else if (string.startsWith("run")) {
                String string2 = string.substring("run".length()).trim();
                if (targets.containsKey(string2)) {
                    Shell.run(string2);
                } else {
                    System.out.println("ash: Target " + string2 + " not found");
                }
            } else if (string.startsWith("trace")) {
                String string3 = string.substring("trace".length()).trim();
                if ("on".equalsIgnoreCase(string3)) {
                    Shell.trace(true);
                } else if ("off".equalsIgnoreCase(string3)) {
                    Shell.trace(false);
                }
            } else if (string.equals("mm.cfg")) {
                Shell.mmcfg();
            } else if (string.startsWith("clear")) {
                String string4 = string.substring("clear".length()).trim();
                if (string4.length() == 0) {
                    HashSet hashSet = new HashSet(targets.keySet());
                    Iterator iterator = hashSet.iterator();
                    while (iterator.hasNext()) {
                        Shell.clear((String)iterator.next());
                    }
                } else if (targets.containsKey(string4)) {
                    Shell.clear(string4);
                } else {
                    System.out.println("ash: Target " + string4 + " not found");
                }
            } else if (string.startsWith("info")) {
                String string5 = string.substring("info".length()).trim();
                if (string5.length() == 0) {
                    HashSet hashSet = new HashSet(targets.keySet());
                    Iterator iterator = hashSet.iterator();
                    while (iterator.hasNext()) {
                        Shell.info((String)iterator.next());
                    }
                } else if (targets.containsKey(string5)) {
                    Shell.info(string5);
                } else {
                    System.out.println("ash: Target " + string5 + " not found");
                }
            } else if (string.startsWith("touch")) {
                String string6 = string.substring("touch".length()).trim();
                StringTokenizer stringTokenizer = new StringTokenizer(string6);
                while (stringTokenizer.hasMoreTokens()) {
                    String string7 = stringTokenizer.nextToken();
                    if (!new File(string7).canWrite()) {
                        System.out.println("touch: cannot write " + string7);
                        continue;
                    }
                    System.out.println("touched file: " + string7);
                    new File(string7).setLastModified(System.currentTimeMillis());
                }
            } else if (string.equals("quit")) {
                HashSet hashSet = new HashSet(targets.keySet());
                Iterator iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    Shell.process("clear " + (String)iterator.next());
                }
                exit = true;
            } else if (string.equals("memory")) {
                Shell.peakMemoryUsage();
            } else if (string.equals("gc")) {
                System.gc();
            } else {
                Shell.cmdList();
            }
        }
    }

    private static MemoryUsage getMemoryUsageInBytes() {
        long l = 0L;
        long l2 = 0L;
        try {
            Class<?> clazz = Class.forName("java.lang.management.ManagementFactory");
            Class<?> clazz2 = Class.forName("java.lang.management.MemoryPoolMXBean");
            Class<?> clazz3 = Class.forName("java.lang.management.MemoryUsage");
            Class<?> clazz4 = Class.forName("java.lang.management.MemoryType");
            Class[] classArray = new Class[]{};
            Object[] objectArray = new Object[]{};
            Method method = clazz.getMethod("getMemoryPoolMXBeans", classArray);
            Method method2 = clazz2.getMethod("getPeakUsage", classArray);
            Method method3 = clazz2.getMethod("getType", classArray);
            Field field = clazz4.getField("HEAP");
            Method method4 = clazz2.getMethod("resetPeakUsage", classArray);
            Method method5 = clazz3.getMethod("getUsed", classArray);
            List list = (List)method.invoke(null, objectArray);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                Object object = method2.invoke(e, objectArray);
                Object object2 = method3.invoke(e, objectArray);
                Long l3 = (Long)method5.invoke(object, objectArray);
                if (field.get(clazz4) == object2) {
                    l += l3.longValue();
                } else {
                    l2 += l3.longValue();
                }
                method4.invoke(e, objectArray);
            }
            return new MemoryUsage(l, l2);
        }
        catch (Exception exception) {
            return new MemoryUsage(l, l2);
        }
    }

    public static long peakMemoryUsage() {
        return Shell.peakMemoryUsage(true);
    }

    public static long peakMemoryUsage(boolean bl) {
        MemoryUsage memoryUsage = Shell.getMemoryUsageInBytes();
        long l = memoryUsage.heap / 0x100000L;
        long l2 = memoryUsage.nonHeap / 0x100000L;
        if (bl && memoryUsage.heap != 0L && memoryUsage.nonHeap != 0L) {
            System.out.println(new MemoryUsage(l, l2));
        }
        return l + l2;
    }

    private static void clear(String string) {
        Process process = (Process)processes.remove(string);
        if (process != null) {
            process.destroy();
        }
        Target target = (Target)targets.remove(string);
    }

    private static void info(String string) {
        Target target = (Target)targets.get(string);
        System.out.println("id: " + target.id);
        StringBuffer stringBuffer = new StringBuffer();
        int n = target.args.length;
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(target.args[i]);
            stringBuffer.append(' ');
        }
        System.out.println("asc: " + stringBuffer);
    }

    private static void run(String string) {
        Object object;
        Process process = (Process)processes.get(string);
        Target target = (Target)targets.get(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < target.args.length; ++i) {
            object = target.args[i];
            if (((String)object).startsWith("-") || ((String)object).equalsIgnoreCase("global.abc") || !((String)object).endsWith(".as") && !((String)object).endsWith(".abc")) continue;
            if (((String)object).endsWith(".as")) {
                object = ((String)object).substring(0, ((String)object).length() - 3) + ".abc";
            }
            arrayList.add((String)object);
        }
        String[] stringArray = new String[arrayList.size() + 1];
        object = null;
        BufferedInputStream bufferedInputStream = null;
        try {
            int n;
            File file = new File(new File(System.getProperty("application.home"), "bin"), "avmplus.exe");
            if (process != null) {
                process.destroy();
            }
            stringArray[0] = file.getAbsolutePath();
            for (n = 0; n < arrayList.size(); ++n) {
                stringArray[n + 1] = (String)arrayList.get(n);
            }
            System.out.print("Using ");
            for (n = 0; n < stringArray.length; ++n) {
                System.out.print(stringArray[n] + " ");
            }
            System.out.println();
            process = Runtime.getRuntime().exec(stringArray);
            processes.put(string, process);
            object = new BufferedInputStream(process.getInputStream());
            bufferedInputStream = new BufferedInputStream(process.getErrorStream());
            Shell.streamOutput((InputStream)object, System.out);
            Shell.streamOutput((InputStream)object, System.err);
            process.waitFor();
        }
        catch (Throwable throwable) {
            if (process != null) {
                process.destroy();
            }
            if (object != null) {
                try {
                    ((BufferedInputStream)object).close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (bufferedInputStream != null) {
                try {
                    bufferedInputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            System.err.println(throwable.getMessage());
            throwable.printStackTrace();
        }
    }

    public static void streamOutput(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n = 8192;
        byte[] byArray = new byte[n];
        while ((n = inputStream.read(byArray, 0, n)) != -1) {
            outputStream.write(byArray, 0, n);
        }
        outputStream.flush();
    }

    private static void asc(String[] stringArray, int n) {
        Target target = new Target();
        target.id = n;
        target.args = stringArray;
        targets.put("" + n, target);
        try {
            Main.show_parsetrees = false;
            Main.show_instructions = false;
            Main.show_linenums = false;
            Main.show_bytes = false;
            Main.show_machinecode = false;
            Main.show_flow = false;
            Main.emit_debug_info = false;
            Main.emit_doc_info = false;
            Main.do_test = false;
            Main.do_help = false;
            Main.filespecFound = false;
            Main.make_movieclip = false;
            Main.lint_mode = false;
            Main.use_static_semantics = false;
            Main.sanity_mode = false;
            Main.emit_metadata = false;
            Main.log = false;
            Main.earliest_dialect = 7;
            Main.latest_dialect = 10;
            Main.dialect = Main.default_dialect = 9;
            Main.optimize = false;
            Main.include_filespecs = new ObjectList();
            Main.import_filespecs = new ObjectList();
            Main.swf_options = "";
            Main.language = "EN";
            Main.main(stringArray);
            System.setErr(Main.stderr);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void trace(boolean bl) {
        Shell.modifyPlayerConfiguration("TraceOutputFileEnable=", bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(File file) {
        BufferedReader bufferedReader = null;
        StringBuffer stringBuffer = new StringBuffer((int)file.length());
        String string = System.getProperty("line.separator");
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string2);
                stringBuffer.append(string);
            }
            String string3 = stringBuffer.toString();
            return string3;
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string4 = null;
            return string4;
        }
        catch (IOException iOException) {
            String string5 = null;
            return string5;
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(String string, String string2) throws FileNotFoundException, IOException {
        File file = new File(string);
        if (file == null) {
            throw new FileNotFoundException(string);
        }
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF8"));
        try {
            bufferedWriter.write(string2);
            ((Writer)bufferedWriter).flush();
        }
        finally {
            ((Writer)bufferedWriter).close();
        }
    }

    private static void modifyPlayerConfiguration(String string, boolean bl) {
        String string2;
        int n;
        File file = new File(System.getProperty("user.home"));
        File file2 = new File(file, "mm.cfg");
        if (file2 != null && file2.exists() && (n = (string2 = Shell.readFile(file2)).indexOf(string)) != -1) {
            string2 = string2.substring(0, n + string.length()) + (bl ? "1" : "0") + string2.substring(n + string.length() + 1);
            try {
                Shell.writeFile(file2.getAbsolutePath(), string2);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            Shell.mmcfg();
        }
    }

    private static void mmcfg() {
        File file = new File(System.getProperty("user.home"));
        System.out.println("ash: Trying to open mm.cfg in " + file);
        File file2 = new File(file, "mm.cfg");
        if (file2 != null && file2.exists()) {
            System.out.println(Shell.readFile(file2).trim());
        }
    }

    private static void intro() {
        System.out.println("Actionscript compiler SHell (ash)");
        System.out.println("Copyright (c) 2006 Adobe Systems Incorporated. All rights reserved.");
        System.out.println("");
    }

    private static void prompt() {
        System.out.print("(ash) ");
    }

    private static void cmdList() {
        System.out.println("List of ash commands:");
        System.out.println("asc arg1 arg2 ...        compile; return a target id");
        System.out.println("run id                   run avmplus");
        System.out.println("clear [id]               clear target(s)");
        System.out.println("info [id]                display compile target info");
        System.out.println("gc                       run garbage collection");
        System.out.println("memory                   display current memory usage");
        System.out.println("mm.cfg                   display mm.cfg information");
        System.out.println("trace on|off             set tracing in mm.cfg");
        System.out.println("touch file1 file2...     modifies file timestamp");
        System.out.println("quit                     quit");
    }

    static class Target {
        public int id;
        public String[] args;

        Target() {
        }
    }

    public static class MemoryUsage {
        public long heap;
        public long nonHeap;
        public long total;

        public MemoryUsage(long l, long l2) {
            this.heap = l;
            this.nonHeap = l2;
            this.total = l + l2;
        }

        public void add(MemoryUsage memoryUsage) {
            this.heap += memoryUsage.heap;
            this.nonHeap += memoryUsage.nonHeap;
            this.total += memoryUsage.total;
        }

        public void subtract(MemoryUsage memoryUsage) {
            this.heap -= memoryUsage.heap;
            this.nonHeap -= memoryUsage.nonHeap;
            this.total -= memoryUsage.total;
        }

        public String toString() {
            return "Peak Memory Usage: " + this.total + " Mb (Heap: " + this.heap + " Mb, Non-Heap: " + this.nonHeap + " Mb)";
        }
    }
}

