/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.agl.text;

import com.adobe.agl.impl.CalendarData;
import com.adobe.agl.impl.ICULocaleData;
import com.adobe.agl.impl.ICUResourceBundle;
import com.adobe.agl.impl.Utility;
import com.adobe.agl.impl.ZoneMeta;
import com.adobe.agl.util.Calendar;
import com.adobe.agl.util.GregorianCalendar;
import com.adobe.agl.util.ULocale;
import com.adobe.agl.util.UResourceBundle;
import java.io.Serializable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class DateFormatSymbols
implements Serializable,
Cloneable {
    String[] eras = null;
    String[] months = null;
    String[] shortMonths = null;
    String[] weekdays = null;
    String[] shortWeekdays = null;
    String[] ampms = null;
    String[][] zoneStrings = null;
    static final String patternChars = "GyMdkHmsSEDFwWahKzYeugAZ";
    String localPatternChars = null;
    static final long serialVersionUID = -5987973545549424702L;
    static final int millisPerHour = 3600000;
    private ULocale validLocale;
    private ULocale actualLocale;

    public DateFormatSymbols() {
        this.initializeData(ULocale.getDefault(), "");
    }

    public DateFormatSymbols(Locale locale) {
        this.initializeData(ULocale.forLocale(locale), "");
    }

    public DateFormatSymbols(ULocale locale) {
        this.initializeData(locale, "");
    }

    public String[] getEras() {
        return this.duplicate(this.eras);
    }

    public void setEras(String[] newEras) {
        this.eras = this.duplicate(newEras);
    }

    public String[] getMonths() {
        return this.duplicate(this.months);
    }

    public void setMonths(String[] newMonths) {
        this.months = this.duplicate(newMonths);
    }

    public String[] getShortMonths() {
        return this.duplicate(this.shortMonths);
    }

    public void setShortMonths(String[] newShortMonths) {
        this.shortMonths = this.duplicate(newShortMonths);
    }

    public String[] getWeekdays() {
        return this.duplicate(this.weekdays);
    }

    public void setWeekdays(String[] newWeekdays) {
        this.weekdays = this.duplicate(newWeekdays);
    }

    public String[] getShortWeekdays() {
        return this.duplicate(this.shortWeekdays);
    }

    public void setShortWeekdays(String[] newShortWeekdays) {
        this.shortWeekdays = this.duplicate(newShortWeekdays);
    }

    public String[] getAmPmStrings() {
        return this.duplicate(this.ampms);
    }

    public void setAmPmStrings(String[] newAmpms) {
        this.ampms = this.duplicate(newAmpms);
    }

    public String[][] getZoneStrings() {
        return this.duplicate(this.zoneStrings);
    }

    public void setZoneStrings(String[][] newZoneStrings) {
        this.zoneStrings = this.duplicate(newZoneStrings);
    }

    public String getLocalPatternChars() {
        return new String(this.localPatternChars);
    }

    public void setLocalPatternChars(String newLocalPatternChars) {
        this.localPatternChars = newLocalPatternChars;
    }

    public Object clone() {
        try {
            DateFormatSymbols other = (DateFormatSymbols)super.clone();
            this.copyMembers(this, other);
            return other;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public int hashCode() {
        int hashcode = 0;
        for (int index = 0; index < this.zoneStrings[0].length; ++index) {
            hashcode ^= this.zoneStrings[0][index].hashCode();
        }
        return hashcode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DateFormatSymbols that = (DateFormatSymbols)obj;
        return Utility.arrayEquals(this.eras, (Object)that.eras) && Utility.arrayEquals(this.months, (Object)that.months) && Utility.arrayEquals(this.shortMonths, (Object)that.shortMonths) && Utility.arrayEquals(this.weekdays, (Object)that.weekdays) && Utility.arrayEquals(this.shortWeekdays, (Object)that.shortWeekdays) && Utility.arrayEquals(this.ampms, (Object)that.ampms) && Utility.arrayEquals((Object[])this.zoneStrings, (Object)that.zoneStrings) && Utility.arrayEquals(this.localPatternChars, (Object)that.localPatternChars);
    }

    protected void initializeData(ULocale desiredLocale, String type) {
        CalendarData calData = new CalendarData(desiredLocale, type);
        this.initializeData(desiredLocale, calData);
    }

    protected void initializeData(ULocale desiredLocale, CalendarData calData) {
        this.eras = calData.getEras("abbreviated");
        this.months = calData.getStringArray("monthNames", "wide");
        this.shortMonths = calData.getStringArray("monthNames", "abbreviated");
        String[] lWeekdays = calData.getStringArray("dayNames", "wide");
        this.weekdays = new String[8];
        this.weekdays[0] = "";
        System.arraycopy(lWeekdays, 0, this.weekdays, 1, lWeekdays.length);
        String[] sWeekdays = calData.getStringArray("dayNames", "abbreviated");
        this.shortWeekdays = new String[8];
        this.shortWeekdays[0] = "";
        System.arraycopy(sWeekdays, 0, this.shortWeekdays, 1, sWeekdays.length);
        this.ampms = calData.getStringArray("AmPmMarkers");
        ICUResourceBundle rb = (ICUResourceBundle)UResourceBundle.getBundleInstance("com/adobe/agl/impl/data/icudt32b", desiredLocale);
        ICUResourceBundle zoneObject = rb.get("zoneStrings");
        this.zoneStrings = new String[zoneObject.getSize()][];
        for (int i = 0; i < zoneObject.getSize(); ++i) {
            ICUResourceBundle zoneArr = zoneObject.get(i);
            String[] strings = new String[zoneArr.getSize()];
            for (int j = 0; j < zoneArr.getSize(); ++j) {
                strings[j] = zoneArr.get(j).getString();
            }
            this.zoneStrings[i] = strings;
        }
        this.localPatternChars = rb.getString("localPatternChars");
        ULocale uloc = rb.getULocale();
        this.setLocale(uloc, uloc);
    }

    final int getZoneIndex(String ID) {
        int result = this._getZoneIndex(ID);
        if (result >= 0) {
            return result;
        }
        int n = ZoneMeta.countEquivalentIDs(ID);
        if (n > 1) {
            for (int i = 0; i < n; ++i) {
                int equivResult;
                String equivID = ZoneMeta.getEquivalentID(ID, i);
                if (equivID.equals(ID) || (equivResult = this._getZoneIndex(equivID)) < 0) continue;
                return equivResult;
            }
        }
        return -1;
    }

    private int _getZoneIndex(String ID) {
        for (int index = 0; index < this.zoneStrings.length; ++index) {
            if (!ID.equalsIgnoreCase(this.zoneStrings[index][0])) continue;
            return index;
        }
        return -1;
    }

    private final String[] duplicate(String[] srcArray) {
        return (String[])srcArray.clone();
    }

    private final String[][] duplicate(String[][] srcArray) {
        String[][] aCopy = new String[srcArray.length][];
        for (int i = 0; i < srcArray.length; ++i) {
            aCopy[i] = this.duplicate(srcArray[i]);
        }
        return aCopy;
    }

    private final void copyMembers(DateFormatSymbols src, DateFormatSymbols dst) {
        dst.eras = this.duplicate(src.eras);
        dst.months = this.duplicate(src.months);
        dst.shortMonths = this.duplicate(src.shortMonths);
        dst.weekdays = this.duplicate(src.weekdays);
        dst.shortWeekdays = this.duplicate(src.shortWeekdays);
        dst.ampms = this.duplicate(src.ampms);
        dst.zoneStrings = this.duplicate(src.zoneStrings);
        dst.localPatternChars = new String(src.localPatternChars);
    }

    public DateFormatSymbols(Calendar cal, Locale locale) {
        this.initializeData(ULocale.forLocale(locale), cal.getType());
    }

    public DateFormatSymbols(Calendar cal, ULocale locale) {
        this.initializeData(locale, cal.getType());
    }

    public DateFormatSymbols(Class calendarClass, Locale locale) {
        this(calendarClass, ULocale.forLocale(locale));
    }

    public DateFormatSymbols(Class calendarClass, ULocale locale) {
        String fullName = calendarClass.getName();
        int lastDot = fullName.lastIndexOf(46);
        String className = fullName.substring(lastDot + 1);
        String calType = className.replaceAll("Calendar", "").toLowerCase();
        this.initializeData(locale, calType);
    }

    public DateFormatSymbols(ResourceBundle bundle, Locale locale) {
        this(bundle, ULocale.forLocale(locale));
    }

    public DateFormatSymbols(ResourceBundle bundle, ULocale locale) {
        this.initializeData(locale, new CalendarData((ICUResourceBundle)bundle, null));
    }

    public static ResourceBundle getDateFormatBundle(Class calendarClass, Locale locale) throws MissingResourceException {
        return DateFormatSymbols.getDateFormatBundle(calendarClass, ULocale.forLocale(locale));
    }

    public static ResourceBundle getDateFormatBundle(Class calendarClass, ULocale locale) throws MissingResourceException {
        ResourceBundle result;
        block2: {
            String fullName = calendarClass.getName();
            int lastDot = fullName.lastIndexOf(46);
            String className = fullName.substring(lastDot + 1);
            String bundleName = className + "Symbols";
            result = null;
            try {
                result = ICULocaleData.getResourceBundle(bundleName, locale);
            }
            catch (MissingResourceException e) {
                if (GregorianCalendar.class.isAssignableFrom(calendarClass)) break block2;
                throw e;
            }
        }
        return result;
    }

    public static ResourceBundle getDateFormatBundle(Calendar cal, Locale locale) throws MissingResourceException {
        return DateFormatSymbols.getDateFormatBundle(cal.getClass(), ULocale.forLocale(locale));
    }

    public static ResourceBundle getDateFormatBundle(Calendar cal, ULocale locale) throws MissingResourceException {
        return DateFormatSymbols.getDateFormatBundle(cal.getClass(), locale);
    }

    public final ULocale getLocale(ULocale.Type type) {
        return type == ULocale.ACTUAL_LOCALE ? this.actualLocale : this.validLocale;
    }

    final void setLocale(ULocale valid, ULocale actual) {
        if (valid == null != (actual == null)) {
            throw new IllegalArgumentException();
        }
        this.validLocale = valid;
        this.actualLocale = actual;
    }
}

