/*-- Copyright 2008 we-lab-doc! (http://www.we-lab-doc.com/)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package scripts
{
	import flash.display.NativeWindowSystemChrome;
	
	import mx.core.Window;
	import mx.core.WindowedApplication;
	
	import mxs.components.mainWindow.workspace.*;
	import mxs.window.*;

		
	public final class WindowManager
	{
		//////
    	public static const PRIVATE_WORKSPACE:String = "PRIVATE";
    	public static const PROJECT_WORKSPACE:String = "PROJECT";
    	public static const ORGANIZATION_WORKSPACE:String = "ORGANIZATION";		
		//////
		private static var windows:Object = {loginWindow:null, supervisorWindow:null, mainWindow:null};
		////
		private static var windowedApplication:WindowedApplication = null;
		//////		
		public static function setWindowedApplication(aWindowedApplication:WindowedApplication):void {
			windowedApplication = aWindowedApplication;
		}
		public static function getWindowedApplication():WindowedApplication {
			return windowedApplication;
		}
		//////
		public static function changeToMainWindow():void {
			unvisibleWindows(windows.mainWindow);
			closeMainWindow();
	        windows.mainWindow = new MainWindow();
        	windows.mainWindow.systemChrome = NativeWindowSystemChrome.STANDARD;
			closeWindows(windows.mainWindow);			
        	windows.mainWindow.open();			
        	windows.mainWindow.visible = true;
		}
		public static function changeToSupervisorWindow():void {
			unvisibleWindows(windows.supervisorWindow);				
			closeSupervisorWindow();
	        windows.supervisorWindow = new SupervisorWindow();
        	windows.supervisorWindow.systemChrome = NativeWindowSystemChrome.STANDARD;
			closeWindows(windows.supervisorWindow);			
        	windows.supervisorWindow.open();			
        	windows.supervisorWindow.visible = true;
		}		
		public static function changeToLoginWindow():void {
			unvisibleWindows(windows.loginWindow);
			closeLoginWindow();
			windows.loginWindow = new LoginWindow();
        	windows.loginWindow.systemChrome = NativeWindowSystemChrome.STANDARD;
			closeWindows(windows.loginWindow);
        	windows.loginWindow.open();			
			windows.loginWindow.visible = true;
		}
		private static function unvisibleWindows(excludesWindow:Window = null) :void {
			for(var key:String in windows) {
				if(windows[key] != null && (excludesWindow == null || excludesWindow != windows[key] ) )
					windows[key].visible = false;
			}			
		}
		private static function closeWindows(excludesWindow:Window = null) :void {
			for(var key:String in windows ) {
				if(windows[key] != null && (excludesWindow == null || excludesWindow != windows[key] )) {
					windows[key].close();
					windows[key] = null;
				}
			}
		}
		public static function closeLoginWindow():void {
			closeWindow(windows.loginWindow)						
		}		
		public static function closeMainWindow():void {
			closeWindow(windows.mainWindow)						
		}
		public static function closeSupervisorWindow():void {
			closeWindow(windows.supervisorWindow)
		}
		private static function closeWindow(window:Window) : void {
			if(window == null) return; 
			for(var key:String in windows ) {
				if(windows[key] == window ) {
					windows[key].close();
					windows[key] = null;
					break;
				}
			}			
		}		
		public static function exitApplicationIfNeeds(eventer:Window):void {
			var wCnt:int = 0;
			for(var key:String in windows) {
				if( windows[key] != eventer && windows[key] != null) wCnt++; 
			}
			if(wCnt == 0) getWindowedApplication().exit();
		}		
		//////
		public static function showWorkspaceView(workspaceType:String, workspaceId:String):void {
			windows.mainWindow.globalStack.selectedIndex = 1;
			var workspaceView:WorkspaceView = windows.mainWindow.globalStack.getChildAt(1) as WorkspaceView;
/*			
			if(workspaceView.tabNav == null) {
				workspaceView.createComponentsFromDescriptors(true);
			}
*/						
			workspaceView.selectWorkspaceItem(workspaceType, workspaceId);
		}
		public static function noshowWorkspaceView():void {
			windows.mainWindow.globalStack.selectedIndex = 0;
		}

	}
}