/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.io;

import com.adobe.internal.io.ByteWriter;
import com.adobe.internal.io.FilterByteWriter;
import java.io.IOException;

public class RangedByteWriter
extends FilterByteWriter {
    private final long start;

    public RangedByteWriter(ByteWriter byteWriter, long offset) {
        super(byteWriter);
        this.start = offset;
    }

    public long length() throws IOException {
        return Math.max(super.length() - this.start, 0L);
    }

    public int read(long position, byte[] b, int offset, int length) throws IOException {
        return super.read(position + this.start, b, offset, length);
    }

    public int read(long position) throws IOException {
        return super.read(position + this.start);
    }

    public void write(long position, byte[] b, int offset, int length) throws IOException {
        super.write(position + this.start, b, offset, length);
    }

    public void write(long position, int b) throws IOException {
        super.write(position + this.start, b);
    }
}

