/*
 * Decompiled with CFR 0.152.
 */
package flex.webtier.server.j2ee.events;

import flex.webtier.server.j2ee.MxmlContext;
import flex.webtier.server.j2ee.events.CompileEvent;
import flex.webtier.services.ServiceFactory;
import flex.webtier.util.Trace;
import flex2.compiler.ILocalizableMessage;
import flex2.compiler.Logger;
import flex2.compiler.util.AbstractLogger;
import java.util.Locale;

public class CompileEventLogger
extends AbstractLogger
implements Logger {
    private MxmlContext context;
    private int warningCount;
    private int errorCount;
    private flex.webtier.services.logging.Logger logger;
    static final /* synthetic */ boolean $assertionsDisabled;

    public CompileEventLogger(MxmlContext context) {
        this.context = context;
        this.logger = ServiceFactory.getLogger();
        this.init(this.getLocalizationManager());
    }

    public void needsCompilation(String path, String reason) {
        this.logger.logDebug("Needs compilation path: " + path);
        this.logger.logDebug("Needs compilation reason: " + reason);
    }

    public void includedFileAffected(String path) {
    }

    public void includedFileUpdated(String path) {
    }

    public int errorCount() {
        return this.errorCount;
    }

    public int warningCount() {
        return this.warningCount;
    }

    public void logInfo(String info) {
        this.logger.logDebug(info);
    }

    public void logDebug(String debug) {
        this.logger.logDebug(debug);
    }

    public void logWarning(String warning) {
        this.logWarning(warning, false);
    }

    public void logWarning(String warning, boolean oneTime) {
        ++this.warningCount;
        this.context.addEvent(new CompileEvent(2, this.WARNING, 0, 0, null, 0, null, warning, oneTime));
        if (Trace.error) {
            Thread.dumpStack();
        }
    }

    public void logError(String error) {
        ++this.errorCount;
        this.context.addEvent(new CompileEvent(1, this.ERROR, 0, 0, null, 0, null, error, false));
        if (Trace.error) {
            Thread.dumpStack();
        }
    }

    public void logInfo(String path, String info) {
        this.logger.logDebug(path);
        this.logger.logDebug(info);
    }

    public void logDebug(String path, String debug) {
        this.logger.logDebug(path);
        this.logger.logDebug(debug);
    }

    public void logWarning(String path, String warning) {
        ++this.warningCount;
        this.context.addEvent(new CompileEvent(2, this.WARNING, 0, 0, null, 0, null, warning, false));
        if (Trace.error) {
            Thread.dumpStack();
        }
    }

    public void logWarning(String path, String warning, int errorCode) {
        this.logWarning(path, warning);
    }

    public void logError(String path, String error) {
        ++this.errorCount;
        this.context.addEvent(new CompileEvent(1, this.ERROR, 0, 0, null, 0, null, error, false));
        if (Trace.error) {
            Thread.dumpStack();
        }
    }

    public void logError(String path, String error, int errorCode) {
        this.logError(path, error);
    }

    public void logInfo(String path, int line, String info) {
        this.logger.logDebug(path + ":" + line);
        this.logger.logDebug(info);
    }

    public void logDebug(String path, int line, String debug) {
        this.logger.logDebug(path + ":" + line);
        this.logger.logDebug(debug);
    }

    public void logWarning(String path, int line, String warning) {
        ++this.warningCount;
        this.context.addEvent(new CompileEvent(2, this.WARNING, 0, line, path, 0, null, warning, false));
        if (Trace.error) {
            Thread.dumpStack();
        }
    }

    public void logWarning(String path, int line, String warning, int errorCode) {
        this.logWarning(path, line, warning);
    }

    public void logError(String path, int line, String error) {
        ++this.errorCount;
        this.context.addEvent(new CompileEvent(1, this.ERROR, 0, line, path, 0, null, error, false));
        if (Trace.error) {
            Thread.dumpStack();
        }
    }

    public void logError(String path, int line, String error, int errorCode) {
        this.logError(path, line, error);
    }

    public void logInfo(String path, int line, int col, String info) {
        this.logger.logDebug(path + ":" + line + ":" + col);
        this.logger.logDebug(info);
    }

    public void logDebug(String path, int line, int col, String debug) {
        this.logger.logDebug(path + ":" + line + ":" + col);
        this.logger.logDebug(debug);
    }

    public void logWarning(String path, int line, int col, String warning) {
        this.logWarning(path, line, warning);
    }

    public void logError(String path, int line, int col, String error) {
        this.logError(path, line, error);
    }

    public void logWarning(String path, int line, int col, String warning, String source) {
        this.logWarning(path, line, warning);
    }

    public void logWarning(String path, int line, int col, String warning, String source, int errorCode) {
        this.logWarning(path, line, warning);
    }

    public void logError(String path, int line, int col, String error, String source) {
        this.logError(path, line, error);
    }

    public void logError(String path, int line, int col, String error, String source, int errorCode) {
        this.logError(path, line, error);
    }

    public void log(ILocalizableMessage m, String source) {
        this.log(m);
    }

    public void log(ILocalizableMessage m) {
        boolean found = true;
        String text = this.getLocalizationManager().getLocalizedTextString(Locale.getDefault(), (Object)m);
        if (text == null) {
            text = m.getClass().getName();
            found = false;
        }
        if (!$assertionsDisabled && !found) {
            throw new AssertionError((Object)("Localized text missing for " + m.getClass().getName()));
        }
        if (m.getLevel() == "error") {
            if (m.getPath() != null && m.getLine() != -1) {
                this.logError(m.getPath(), m.getLine(), text);
            } else if (m.getPath() != null) {
                this.logError(m.getPath(), text);
            } else {
                this.logError(text);
            }
        } else if (m.getLevel() == "warning") {
            if (m.getPath() != null && m.getLine() != -1) {
                this.logWarning(m.getPath(), m.getLine(), text);
            } else if (m.getPath() != null) {
                this.logWarning(m.getPath(), text);
            } else {
                this.logWarning(text);
            }
        } else if (m.getPath() != null && m.getLine() != -1) {
            this.logInfo(m.getPath(), m.getLine(), text);
        } else if (m.getPath() != null) {
            this.logInfo(m.getPath(), text);
        } else {
            this.logInfo(text);
        }
    }

    static {
        $assertionsDisabled = !CompileEventLogger.class.desiredAssertionStatus();
    }
}

