/*
 * Decompiled with CFR 0.152.
 */
package flex.webtier.server.j2ee.jsp;

import flash.util.LRUCache;
import flex.webtier.server.j2ee.jsp.SourceCacheEntry;
import flex.webtier.services.ServiceFactory;
import flex.webtier.services.config.CacheConfiguration;
import flex.webtier.services.config.Configurator;
import flex.webtier.util.Hex;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.servlet.ServletContext;

public class SourceCache
extends LRUCache
implements Serializable {
    private static final String ATTRNAME = SourceCache.class.getClassLoader().hashCode() + SourceCache.class.getName();

    public SourceCache(int initialSize, int maxSize) {
        super(initialSize, maxSize);
    }

    public SourceCacheEntry getEntry(String key) {
        return (SourceCacheEntry)this.get(key);
    }

    public void addEntry(SourceCacheEntry entry) {
        this.put(entry.sourceKey, entry);
    }

    public static synchronized SourceCache getInstance(ServletContext servletContext) {
        SourceCache sourceCache = (SourceCache)servletContext.getAttribute(ATTRNAME);
        if (sourceCache == null) {
            Configurator config = ServiceFactory.getConfigurator();
            CacheConfiguration cacheConfig = config.getServerConfiguration().getCacheConfiguration();
            int maxSize = cacheConfig.getJspSourceCacheSize();
            sourceCache = new SourceCache(maxSize / 4, maxSize);
            servletContext.setAttribute(ATTRNAME, (Object)sourceCache);
        }
        return sourceCache;
    }

    public static String sourceToKey(String sourceCode) {
        try {
            return SourceCache.md5Algorithm(sourceCode);
        }
        catch (UnsupportedEncodingException uee) {
            return SourceCache.hashCodeAlgorithm(sourceCode);
        }
        catch (NoSuchAlgorithmException nsae) {
            return SourceCache.hashCodeAlgorithm(sourceCode);
        }
    }

    private static String md5Algorithm(String sourceCode) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest ctx = MessageDigest.getInstance("MD5");
        byte[] ba = ctx.digest(sourceCode.getBytes("UTF-8"));
        Hex.Encoder encoder = new Hex.Encoder(ba.length * 2);
        encoder.encode(ba);
        String encoded = encoder.drain();
        return encoded;
    }

    private static String hashCodeAlgorithm(String sourceCode) {
        int i = sourceCode.hashCode();
        return String.valueOf(i < 0 ? ~i : i);
    }

    public static String uriToKey(String uri) {
        int i = uri.lastIndexOf(47);
        int j = uri.indexOf(46, i);
        return uri.substring(i + 1, j);
    }
}

