/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.SVGDecoratedShapeElementBridge;
import org.apache.batik.dom.svg.SVGPathContext;
import org.apache.batik.ext.awt.geom.PathLength;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.ShapeNode;
import org.apache.batik.parser.AWTPathProducer;
import org.apache.batik.parser.ParseException;
import org.apache.batik.parser.PathHandler;
import org.apache.batik.parser.PathParser;
import org.w3c.dom.Element;
import org.w3c.dom.events.MutationEvent;

public class SVGPathElementBridge
extends SVGDecoratedShapeElementBridge
implements SVGPathContext {
    protected static final Shape DEFAULT_SHAPE = new GeneralPath();
    Shape pathLengthShape = null;
    PathLength pathLength = null;

    public String getLocalName() {
        return "path";
    }

    public Bridge getInstance() {
        return new SVGPathElementBridge();
    }

    protected void buildShape(BridgeContext ctx, Element e, ShapeNode shapeNode) {
        String s = e.getAttributeNS(null, "d");
        if (s.length() != 0) {
            AWTPathProducer app = new AWTPathProducer();
            app.setWindingRule(CSSUtilities.convertFillRule(e));
            try {
                PathParser pathParser = new PathParser();
                pathParser.setPathHandler((PathHandler)app);
                pathParser.parse(s);
            }
            catch (ParseException ex) {
                BridgeException bex = new BridgeException(e, "attribute.malformed", new Object[]{"d"});
                bex.setGraphicsNode((GraphicsNode)shapeNode);
                throw bex;
            }
            finally {
                shapeNode.setShape(app.getShape());
            }
        }
    }

    public void handleDOMAttrModifiedEvent(MutationEvent evt) {
        String attrName = evt.getAttrName();
        if (attrName.equals("d")) {
            if (evt.getNewValue().length() == 0) {
                ((ShapeNode)this.node).setShape(DEFAULT_SHAPE);
            } else {
                this.buildShape(this.ctx, this.e, (ShapeNode)this.node);
            }
            this.handleGeometryChanged();
        } else {
            super.handleDOMAttrModifiedEvent(evt);
        }
    }

    protected void handleCSSPropertyChanged(int property) {
        switch (property) {
            case 17: {
                this.buildShape(this.ctx, this.e, (ShapeNode)this.node);
                this.handleGeometryChanged();
                break;
            }
            default: {
                super.handleCSSPropertyChanged(property);
            }
        }
    }

    PathLength getPathLengthObj() {
        Shape s = ((ShapeNode)this.node).getShape();
        if (this.pathLengthShape != s) {
            this.pathLength = new PathLength(s);
            this.pathLengthShape = s;
        }
        return this.pathLength;
    }

    public float getTotalLength() {
        PathLength pl = this.getPathLengthObj();
        return pl.lengthOfPath();
    }

    public Point2D getPointAtLength(float distance) {
        PathLength pl = this.getPathLengthObj();
        return pl.pointAtLength(distance);
    }
}

