/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.css;

import flash.css.FontFaceRule;
import flash.css.Logger;
import flash.css.Rule;
import flash.css.RuleList;
import flash.css.StyleDeclaration;
import flash.css.StyleRule;
import flash.css.StyleSheet;
import flash.fonts.FontManager;
import flash.util.Trace;
import flex2.compiler.CompilationUnit;
import flex2.compiler.ResourceContainer;
import flex2.compiler.Source;
import flex2.compiler.common.PathResolver;
import flex2.compiler.css.ConditionTypeNotSupported;
import flex2.compiler.css.Import;
import flex2.compiler.css.ParseError;
import flex2.compiler.css.SelectorTypeNotSupported;
import flex2.compiler.css.StyleDef;
import flex2.compiler.io.FileUtil;
import flex2.compiler.io.TextFile;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.mxml.Configuration;
import flex2.compiler.mxml.SourceCodeBuffer;
import flex2.compiler.mxml.gen.VelocityUtil;
import flex2.compiler.mxml.rep.AtEmbed;
import flex2.compiler.mxml.rep.MxmlDocument;
import flex2.compiler.swc.SwcFile;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.ThreadLocalToolkit;
import flex2.compiler.util.VelocityException;
import flex2.compiler.util.VelocityManager;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.batik.css.parser.AbstractSelector;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.w3c.css.sac.AttributeCondition;
import org.w3c.css.sac.Condition;
import org.w3c.css.sac.ConditionalSelector;
import org.w3c.css.sac.ElementSelector;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SelectorList;

public class StylesContainer {
    private static final String TEMPLATE_PATH = "flex2/compiler/css/";
    private static final String ATEMBEDS_KEY = "atEmbeds";
    private static final String FONTFACERULES_TEMPLATE = "flex2/compiler/css/FontFaceRules.vm";
    private static final String STYLEDEF_KEY = "styleDef";
    private static final String STYLEDEF_TEMPLATE = "flex2/compiler/css/StyleDef.vm";
    private static final String _FONTFACERULES = "_FontFaceRules";
    private MxmlDocument mxmlDocument;
    private Configuration configuration;
    private CompilationUnit compilationUnit;
    private Object perCompileData;
    private Map selectors = new HashMap();
    private Set localStyleTypeNames = new HashSet();
    private Map atEmbeds;
    private List fontFaceRules = new ArrayList();
    private List implicitIncludes = new ArrayList();
    static final /* synthetic */ boolean $assertionsDisabled;

    public StylesContainer(Configuration configuration, CompilationUnit compilationUnit, Object perCompileData) {
        this.configuration = configuration;
        this.compilationUnit = compilationUnit;
        this.perCompileData = perCompileData;
        this.atEmbeds = new HashMap();
        this.loadDefaultStyles();
    }

    public StylesContainer(CompilationUnit compilationUnit, Object perCompileData, Configuration configuration) {
        this.configuration = configuration;
        this.compilationUnit = compilationUnit;
        this.perCompileData = perCompileData;
        compilationUnit.setStylesContainer(this);
    }

    public void setMxmlDocument(MxmlDocument doc) {
        this.mxmlDocument = doc;
    }

    private boolean addAtEmbed(AtEmbed atEmbed) {
        if (this.mxmlDocument != null) {
            this.mxmlDocument.addAtEmbed(atEmbed);
        } else if (!this.atEmbeds.containsKey(atEmbed.getPropName())) {
            this.atEmbeds.put(atEmbed.getPropName(), atEmbed);
        }
        return true;
    }

    public void addFontFaceRule(FontFaceRule rule) {
        boolean italic;
        boolean bold;
        if (!$assertionsDisabled && rule == null) {
            throw new AssertionError();
        }
        String family = rule.getFamily();
        if (this.getFontFaceRule(family, bold = rule.isBold(), italic = rule.isItalic()) == null) {
            this.fontFaceRules.add(rule);
            String propName = "_embed__font_" + family + "_" + (bold ? "bold" : "medium") + "_" + (italic ? "italic" : "normal");
            Map embedParams = rule.getEmbedParams();
            StyleDeclaration styleDeclaration = rule.getStyle();
            String path = styleDeclaration.getPath();
            if (path.indexOf(92) > -1) {
                embedParams.put("_file", path.replace('\\', '/'));
                embedParams.put("_pathsep", "true");
            } else {
                embedParams.put("_file", path);
            }
            embedParams.put("_line", Integer.toString(styleDeclaration.getLineNumber()));
            AtEmbed atEmbed = AtEmbed.create(propName, rule.getStyle().getLineNumber(), embedParams, false);
            this.addAtEmbed(atEmbed);
        } else if (Trace.font) {
            Trace.trace((String)("Font face already existed for " + family + " bold? " + bold + " italic? " + italic));
        }
    }

    private void addStyleClassSelector(String name, Rule rule, int lineNumber) {
        StyleDef styleDef;
        if (this.selectors.containsKey(name)) {
            styleDef = (StyleDef)this.selectors.get(name);
        } else {
            styleDef = new StyleDef(name, false, this.mxmlDocument, this.compilationUnit.getSource(), lineNumber, this.perCompileData);
            this.selectors.put(name, styleDef);
        }
        styleDef.addRule(rule);
        if (this.mxmlDocument != null) {
            Iterator iterator = styleDef.getImports().iterator();
            while (iterator.hasNext()) {
                Import importObject = (Import)iterator.next();
                this.mxmlDocument.addImport(importObject.getValue(), importObject.getLineNumber());
            }
        }
    }

    private void addStyleTypeSelector(String name, Rule rule, boolean local, int lineNumber) {
        StyleDef styleDef;
        if (local) {
            this.localStyleTypeNames.add(name);
        }
        if (this.selectors.containsKey(name)) {
            styleDef = (StyleDef)this.selectors.get(name);
        } else {
            styleDef = new StyleDef(name, true, this.mxmlDocument, this.compilationUnit.getSource(), lineNumber, this.perCompileData);
            this.selectors.put(name, styleDef);
        }
        styleDef.addRule(rule);
        if (this.mxmlDocument != null) {
            Iterator iterator = styleDef.getImports().iterator();
            while (iterator.hasNext()) {
                Import importObject = (Import)iterator.next();
                this.mxmlDocument.addImport(importObject.getValue(), importObject.getLineNumber());
            }
        }
    }

    public void checkForUnusedTypeSelectors(Set defNames) {
        Iterator iterator = this.selectors.entrySet().iterator();
        HashSet<String> unqualifiedDefNames = new HashSet<String>();
        Iterator defNameIterator = defNames.iterator();
        while (defNameIterator.hasNext()) {
            String defName = (String)defNameIterator.next();
            unqualifiedDefNames.add(defName.replaceFirst(".*:", ""));
        }
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String styleName = (String)entry.getKey();
            StyleDef styleDef = (StyleDef)entry.getValue();
            String typeName = StyleDef.dehyphenize(styleName);
            if (!styleDef.isTypeSelector() || !this.localStyleTypeNames.contains(styleName) || unqualifiedDefNames.contains(typeName) || styleName.equals("global") || !this.configuration.showUnusedTypeSelectorWarnings()) continue;
            ThreadLocalToolkit.log(new UnusedTypeSelector(this.compilationUnit.getSource().getName(), styleDef.getLineNumber(), styleName));
        }
    }

    private Source createSource(String fileName, SourceCodeBuffer sourceCodeBuffer) {
        Source result = null;
        if (sourceCodeBuffer.getBuffer() != null) {
            String sourceCode = sourceCodeBuffer.toString();
            if (this.configuration.keepGeneratedActionScript()) {
                try {
                    FileUtil.writeFile(fileName, sourceCode);
                }
                catch (IOException e) {
                    ThreadLocalToolkit.log(new VelocityException.UnableToWriteGeneratedFile(fileName, e.getMessage()));
                }
            }
            TextFile genFile = new TextFile(sourceCode, fileName, null, "text/as", Long.MAX_VALUE);
            String shortName = fileName.substring(0, fileName.lastIndexOf(46));
            result = new Source((VirtualFile)genFile, "", shortName, null, false, false, false);
            result.setPathResolver(this.compilationUnit.getSource().getPathResolver());
            Iterator iterator = this.implicitIncludes.iterator();
            while (iterator.hasNext()) {
                VirtualFile virtualFile = (VirtualFile)iterator.next();
                result.addFileInclude(virtualFile);
            }
        }
        return result;
    }

    public void extractStyles(StyleSheet styleSheet, boolean local) throws Exception {
        RuleList sheetRules = styleSheet.getCssRules();
        if (sheetRules != null) {
            Iterator ruleIterator = sheetRules.iterator();
            while (ruleIterator.hasNext()) {
                Rule rule = (Rule)ruleIterator.next();
                if (rule instanceof StyleRule) {
                    SelectorList selectors = ((StyleRule)rule).getSelectorList();
                    int nSelectors = selectors.getLength();
                    for (int i = 0; i < nSelectors; ++i) {
                        Selector selector = selectors.item(i);
                        int lineNumber = rule.getStyle().getLineNumber();
                        if (selector instanceof AbstractSelector) {
                            lineNumber = ((AbstractSelector)selector).getLineNumber();
                        }
                        if (selector.getSelectorType() == 0) {
                            Condition condition = ((ConditionalSelector)selector).getCondition();
                            if (condition.getConditionType() == 9) {
                                String name = ((AttributeCondition)condition).getValue();
                                if (!$assertionsDisabled && name == null) {
                                    throw new AssertionError((Object)"parsed CSS class selector name is null");
                                }
                                this.addStyleClassSelector(name, rule, lineNumber);
                                continue;
                            }
                            ConditionTypeNotSupported conditionTypeNotSupported = new ConditionTypeNotSupported(this.compilationUnit.getSource().getName(), lineNumber, condition.toString());
                            ThreadLocalToolkit.log(conditionTypeNotSupported);
                            continue;
                        }
                        if (selector.getSelectorType() == 4) {
                            if (this.compilationUnit.isRoot()) {
                                String name = ((ElementSelector)selector).getLocalName();
                                if (name == null) continue;
                                this.addStyleTypeSelector(name, rule, local, lineNumber);
                                continue;
                            }
                            ComponentTypeSelectorsNotSupported componentTypeSelectorsNotSupported = new ComponentTypeSelectorsNotSupported(this.compilationUnit.getSource().getName(), lineNumber, selector.toString());
                            ThreadLocalToolkit.log(componentTypeSelectorsNotSupported);
                            continue;
                        }
                        SelectorTypeNotSupported selectorTypeNotSupported = new SelectorTypeNotSupported(this.compilationUnit.getSource().getName(), lineNumber, selector.toString());
                        ThreadLocalToolkit.log(selectorTypeNotSupported);
                    }
                    continue;
                }
                if (!(rule instanceof FontFaceRule)) continue;
                this.addFontFaceRule((FontFaceRule)rule);
            }
        }
    }

    private String generateFontFaceRuleSourceName() {
        String genDir = this.configuration.getGeneratedDirectory();
        String genFileName = genDir != null ? genDir + File.separatorChar + "_FontFaceRules.as" : "_FontFaceRules.as";
        return genFileName;
    }

    private Source generateFontFaceRules(ResourceContainer resources) {
        Template template;
        String genFileName = this.generateFontFaceRuleSourceName();
        Source styleSource = resources.findSource(genFileName);
        if (styleSource != null) {
            if (styleSource.getCompilationUnit() == null) {
                styleSource = null;
            } else {
                return styleSource;
            }
        }
        try {
            template = VelocityManager.getTemplate(FONTFACERULES_TEMPLATE);
        }
        catch (Exception exception) {
            ThreadLocalToolkit.log(new VelocityException.TemplateNotFound(FONTFACERULES_TEMPLATE));
            return null;
        }
        SourceCodeBuffer out = new SourceCodeBuffer();
        try {
            VelocityUtil util = new VelocityUtil(TEMPLATE_PATH, this.configuration.debug(), out, null);
            VelocityContext vc = VelocityManager.getCodeGenContext(util);
            vc.put(ATEMBEDS_KEY, (Object)this.atEmbeds);
            template.merge((Context)vc, (Writer)out);
        }
        catch (Exception e) {
            ThreadLocalToolkit.log(new VelocityException.GenerateException(this.compilationUnit.getSource().getRelativePath(), e.getLocalizedMessage()));
            return null;
        }
        return resources.addResource(this.createSource(genFileName, out));
    }

    private String generateStyleSourceName(StyleDef styleDef) {
        String genDir = this.configuration.getGeneratedDirectory();
        String genFileName = genDir != null ? genDir + File.separatorChar + "_" + styleDef.getName() + "Style.as" : "_" + styleDef.getName() + "Style.as";
        return genFileName;
    }

    private Source generateStyleSource(StyleDef styleDef, ResourceContainer resources) {
        Template template;
        String genFileName = this.generateStyleSourceName(styleDef);
        Source styleSource = resources.findSource(genFileName);
        if (styleSource != null) {
            if (styleSource.getCompilationUnit() == null) {
                styleSource = null;
            } else {
                return styleSource;
            }
        }
        try {
            template = VelocityManager.getTemplate(STYLEDEF_TEMPLATE);
        }
        catch (Exception exception) {
            ThreadLocalToolkit.log(new VelocityException.TemplateNotFound(STYLEDEF_TEMPLATE));
            return null;
        }
        SourceCodeBuffer out = new SourceCodeBuffer();
        try {
            VelocityUtil util = new VelocityUtil(TEMPLATE_PATH, this.configuration.debug(), out, null);
            VelocityContext vc = VelocityManager.getCodeGenContext(util);
            vc.put(STYLEDEF_KEY, (Object)styleDef);
            template.merge((Context)vc, (Writer)out);
        }
        catch (Exception e) {
            ThreadLocalToolkit.log(new VelocityException.GenerateException(this.compilationUnit.getSource().getRelativePath(), e.getLocalizedMessage()));
            return null;
        }
        return resources.addResource(this.createSource(genFileName, out));
    }

    public FontFaceRule getFontFaceRule(String family, boolean bold, boolean italic) {
        if (family != null && family.startsWith("\"") && (family = family.substring(1)).endsWith("\"")) {
            family = family.substring(0, family.length() - 1);
        }
        return FontFaceRule.getRule(this.fontFaceRules, family, bold, italic);
    }

    public List getFontFaceRules() {
        return this.fontFaceRules;
    }

    MxmlDocument getMxmlDocument() {
        return this.mxmlDocument;
    }

    public Iterator getStyleDefs() {
        return this.selectors.values().iterator();
    }

    public boolean hasFontFamily(String family) {
        if (family.startsWith("\"") && (family = family.substring(1)).endsWith("\"")) {
            family = family.substring(0, family.length() - 1);
        }
        return FontFaceRule.hasFamily(this.fontFaceRules, family);
    }

    private VirtualFile resolveDefaultsCssFile() {
        VirtualFile defaultsCSSFile = this.configuration.getDefaultsCssUrl();
        if (defaultsCSSFile == null) {
            PathResolver resolver = ThreadLocalToolkit.getPathResolver();
            String version = this.configuration.getCompatibilityVersionString();
            if (version != null) {
                defaultsCSSFile = resolver.resolve("defaults-" + version + ".css");
            }
            if (defaultsCSSFile == null) {
                defaultsCSSFile = resolver.resolve("defaults.css");
            }
        }
        return defaultsCSSFile;
    }

    private void loadDefaultStyles() {
        VirtualFile defaultsCSSFile = this.resolveDefaultsCssFile();
        Iterator it = this.configuration.getDefaultsCssFiles().iterator();
        while (it.hasNext()) {
            VirtualFile swcDefaultsCssFile = (VirtualFile)it.next();
            ThreadLocalToolkit.getPathResolver().addSinglePathResolver(0, swcDefaultsCssFile);
            this.processStyleSheet(swcDefaultsCssFile);
            ThreadLocalToolkit.getPathResolver().removeSinglePathResolver(swcDefaultsCssFile);
        }
        if (defaultsCSSFile != null) {
            if (!(defaultsCSSFile instanceof SwcFile)) {
                this.processStyleSheet(defaultsCSSFile);
            }
        } else {
            ThreadLocalToolkit.log(new DefaultCSSFileNotFound());
        }
        it = this.configuration.getThemeCssFiles().iterator();
        while (it.hasNext()) {
            VirtualFile themeCssFile = (VirtualFile)it.next();
            ThreadLocalToolkit.getPathResolver().addSinglePathResolver(0, themeCssFile);
            this.processStyleSheet(themeCssFile);
            ThreadLocalToolkit.getPathResolver().removeSinglePathResolver(themeCssFile);
        }
    }

    public List processDependencies(Set defNames, ResourceContainer resources) {
        ArrayList<Source> extraSources = new ArrayList<Source>();
        if (!this.fontFaceRules.isEmpty()) {
            this.compilationUnit.extraClasses.add(_FONTFACERULES);
            this.compilationUnit.mixins.add(_FONTFACERULES);
            extraSources.add(this.generateFontFaceRules(resources));
        }
        HashSet<String> unqualifiedDefNames = new HashSet<String>();
        Iterator defNameIterator = defNames.iterator();
        while (defNameIterator.hasNext()) {
            String defName = (String)defNameIterator.next();
            unqualifiedDefNames.add(defName.replaceFirst(".*:", ""));
        }
        Iterator iterator = this.selectors.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String styleName = (String)entry.getKey();
            StyleDef styleDef = (StyleDef)entry.getValue();
            String typeName = StyleDef.dehyphenize(styleName);
            if (styleDef.isTypeSelector() && !unqualifiedDefNames.contains(typeName) && !this.configuration.keepAllTypeSelectors() && !styleName.equals("global")) continue;
            String className = "_" + typeName + "Style";
            this.compilationUnit.extraClasses.add(className);
            this.compilationUnit.mixins.add(className);
            extraSources.add(this.generateStyleSource(styleDef, resources));
        }
        return extraSources;
    }

    private void processStyleSheet(VirtualFile cssFile) {
        this.implicitIncludes.add(cssFile);
        try {
            FontManager fontManager = this.configuration.getFontsConfiguration().getTopLevelManager();
            StyleSheet styleSheet = new StyleSheet();
            styleSheet.checkDeprecation(this.configuration.showDeprecationWarnings());
            styleSheet.parse(cssFile.getName(), cssFile.getInputStream(), (Logger)ThreadLocalToolkit.getLogger(), fontManager);
            this.extractStyles(styleSheet, false);
        }
        catch (Exception exception) {
            ParseError m = new ParseError(exception.getLocalizedMessage());
            m.setPath(cssFile.getName());
            ThreadLocalToolkit.log(m);
        }
    }

    static {
        $assertionsDisabled = !StylesContainer.class.desiredAssertionStatus();
    }

    public static class ComponentTypeSelectorsNotSupported
    extends CompilerMessage.CompilerWarning {
        public String selector;

        public ComponentTypeSelectorsNotSupported(String path, int line, String selector) {
            this.path = path;
            this.line = line;
            this.selector = selector;
        }
    }

    public static class UnusedTypeSelector
    extends CompilerMessage.CompilerWarning {
        public String styleName;

        public UnusedTypeSelector(String path, int line, String styleName) {
            this.path = path;
            this.line = line;
            this.styleName = styleName;
        }
    }

    public static class DefaultCSSFileNotFound
    extends CompilerMessage.CompilerWarning {
    }
}

