/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.calendar;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import java.util.StringTokenizer;
import org.jbpm.calendar.BusinessCalendar;
import org.jbpm.calendar.DayPart;

public class Day
implements Serializable {
    private static final long serialVersionUID = 1L;
    DayPart[] dayParts = null;
    BusinessCalendar businessCalendar = null;

    public static Day[] parseWeekDays(Properties calendarProperties, BusinessCalendar businessCalendar) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(calendarProperties.getProperty("hour.format"));
        Day[] weekDays = new Day[8];
        weekDays[2] = new Day(calendarProperties.getProperty("weekday.monday"), dateFormat, businessCalendar);
        weekDays[3] = new Day(calendarProperties.getProperty("weekday.tuesday"), dateFormat, businessCalendar);
        weekDays[4] = new Day(calendarProperties.getProperty("weekday.wednesday"), dateFormat, businessCalendar);
        weekDays[5] = new Day(calendarProperties.getProperty("weekday.thursday"), dateFormat, businessCalendar);
        weekDays[6] = new Day(calendarProperties.getProperty("weekday.friday"), dateFormat, businessCalendar);
        weekDays[7] = new Day(calendarProperties.getProperty("weekday.saturday"), dateFormat, businessCalendar);
        weekDays[1] = new Day(calendarProperties.getProperty("weekday.sunday"), dateFormat, businessCalendar);
        return weekDays;
    }

    public Day(String dayPartsText, DateFormat dateFormat, BusinessCalendar businessCalendar) {
        this.businessCalendar = businessCalendar;
        ArrayList<DayPart> dayPartsList = new ArrayList<DayPart>();
        StringTokenizer tokenizer = new StringTokenizer(dayPartsText, "&");
        while (tokenizer.hasMoreTokens()) {
            String dayPartText = tokenizer.nextToken().trim();
            dayPartsList.add(new DayPart(dayPartText, dateFormat, this, dayPartsList.size()));
        }
        this.dayParts = dayPartsList.toArray(new DayPart[dayPartsList.size()]);
    }

    public void findNextDayPartStart(int dayPartIndex, Date date, Object[] result) {
        if (dayPartIndex < this.dayParts.length) {
            if (this.dayParts[dayPartIndex].isStartAfter(date)) {
                result[0] = this.dayParts[dayPartIndex].getStartTime(date);
                result[1] = this.dayParts[dayPartIndex];
            } else {
                this.findNextDayPartStart(dayPartIndex + 1, date, result);
            }
        } else {
            date = this.businessCalendar.findStartOfNextDay(date);
            Day nextDay = this.businessCalendar.findDay(date);
            nextDay.findNextDayPartStart(0, date, result);
        }
    }
}

