/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.agl.converters;

import com.adobe.agl.common.ErrorCode;
import com.adobe.agl.converters.NativeConverter;
import com.adobe.agl.converters.UConverter;
import java.io.UnsupportedEncodingException;
import sun.io.CharToByteConverter;
import sun.io.ConversionBufferFullException;
import sun.io.MalformedInputException;
import sun.io.UnknownCharacterException;

public class CharToByteConverterICU
extends CharToByteConverter {
    private int[] data = new int[2];
    private final UConverter converterHandle;
    private final String encoding;
    private final int maxBytes;

    public CharToByteConverterICU(String enc) throws UnsupportedEncodingException {
        this.encoding = enc;
        this.data[0] = 0;
        this.data[1] = 0;
        UConverter[] converterHandleArr = new UConverter[1];
        if (!ErrorCode.LIBRARY_LOADED) {
            ErrorCode.LIBRARY_LOADED = true;
        }
        if (NativeConverter.openConverter(converterHandleArr, this.encoding) > 0) {
            throw new UnsupportedEncodingException();
        }
        this.converterHandle = converterHandleArr[0];
        this.maxBytes = NativeConverter.getMaxBytesPerChar(this.converterHandle);
    }

    private CharToByteConverterICU(UConverter conv, String enc) {
        this.converterHandle = conv;
        this.encoding = enc;
        this.maxBytes = NativeConverter.getMaxBytesPerChar(this.converterHandle);
    }

    public int convert(char[] input, int inOff, int inEnd, byte[] output, int outOff, int outEnd) throws ConversionBufferFullException, UnknownCharacterException, MalformedInputException, IllegalArgumentException {
        if (input == null || output == null) {
            throw new IllegalArgumentException();
        }
        this.data[0] = inOff;
        this.data[1] = outOff;
        int err = NativeConverter.convertCharToByte(this.converterHandle, input, inEnd, output, outEnd, this.data, false);
        this.charOff += this.data[0];
        this.byteOff += this.data[1];
        if (err == 15) {
            throw new ConversionBufferFullException();
        }
        if (err > 0) {
            throw new MalformedInputException();
        }
        if (this.data[0] != inEnd && !this.subMode) {
            throw new UnknownCharacterException();
        }
        return this.data[1];
    }

    public final int flush(byte[] output, int outStart, int outEnd) throws IllegalArgumentException, ConversionBufferFullException, MalformedInputException {
        if (output == null) {
            throw new IllegalArgumentException();
        }
        this.data[0] = 0;
        this.data[1] = outStart;
        int err = NativeConverter.flushCharToByte(this.converterHandle, output, outEnd, this.data);
        this.charOff = this.data[0];
        this.byteOff = this.data[1];
        if (err == 15) {
            throw new ConversionBufferFullException();
        }
        if (err == 11) {
            throw new MalformedInputException();
        }
        this.reset();
        return this.data[1];
    }

    public final String getCharacterEncoding() {
        return this.encoding;
    }

    public final void setSubstitutionBytes(byte[] c) throws IllegalArgumentException {
        if (c.length > this.getMaxBytesPerChar()) {
            throw new IllegalArgumentException();
        }
        if (NativeConverter.setSubstitutionBytes(this.converterHandle, c, c.length) > 0) {
            throw new IllegalArgumentException();
        }
    }

    public final void reset() {
        this.charOff = 0;
        this.byteOff = 0;
        NativeConverter.resetCharToByte(this.converterHandle);
    }

    public final int getMaxBytesPerChar() {
        return this.maxBytes;
    }

    public boolean canConvert(char c) {
        return this.canConvert((int)c);
    }

    public boolean canConvert(int codeUnit) {
        return NativeConverter.canEncode(this.converterHandle, codeUnit);
    }

    public final int getBadInputLength() {
        int[] length = new int[1];
        NativeConverter.countInvalidChars(this.converterHandle, length);
        return length[0];
    }

    public final void setSubstitutionMode(boolean doSub) {
        NativeConverter.setSubstitutionModeCharToByte(this.converterHandle, doSub);
        this.subMode = doSub;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            NativeConverter.closeConverter(this.converterHandle);
        }
        finally {
            super.finalize();
        }
    }

    public static final CharToByteConverter createConverter(String enc) throws UnsupportedEncodingException {
        return new CharToByteConverterICU(enc);
    }

    public Object clone() {
        CharToByteConverterICU result = null;
        UConverter[] handleArr = new UConverter[1];
        int ec = NativeConverter.safeClone(this.converterHandle, handleArr);
        if (ec > 0) {
            throw new RuntimeException("Cloning failed" + ErrorCode.getErrorName(ec));
        }
        result = new CharToByteConverterICU(handleArr[0], this.encoding);
        return result;
    }
}

