/*
 * Decompiled with CFR 0.152.
 */
package flex.webtier.server.j2ee;

import flash.localization.ILocalizer;
import flash.localization.LocalizationManager;
import flash.localization.ResourceBundleLocalizer;
import flash.localization.XLRLocalizer;
import flex.webtier.server.j2ee.BaseCompileFilter;
import flex.webtier.server.j2ee.BrowserCacheFilter;
import flex.webtier.server.j2ee.CompileAgentServlet;
import flex.webtier.server.j2ee.CompileFilter;
import flex.webtier.server.j2ee.IncrementalCompileFilter;
import flex.webtier.server.j2ee.MxmlContext;
import flex.webtier.server.j2ee.MxmlFilter;
import flex.webtier.server.j2ee.PathExistsFilter;
import flex.webtier.server.j2ee.PrecompileFilter;
import flex.webtier.server.j2ee.RecompileFilter;
import flex.webtier.server.j2ee.ServletPathResolver;
import flex.webtier.server.j2ee.SwfRenderFilter;
import flex.webtier.server.j2ee.SwfRequestHandler;
import flex.webtier.server.j2ee.URLDecoder;
import flex.webtier.services.ServiceFactory;
import flex.webtier.services.extensions.ExtensionManager;
import flex.webtier.util.PathResolver;
import flex.webtier.util.ServletUtils;
import flex.webtier.util.Trace;
import flex2.compiler.common.LocalFilePathResolver;
import flex2.compiler.common.SinglePathResolver;
import flex2.compiler.util.ThreadLocalToolkit;
import flex2.compiler.util.URLPathResolver;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SwfServlet
extends CompileAgentServlet {
    static final long serialVersionUID = -2187066346561637934L;
    private String asSwfExt;
    private String mxmlSwdExt;
    private String mxmlSwfExt;
    private String swdExt;
    private String swfExt;
    private String swcSwfExt;
    private String swcSwdExt;
    private MxmlFilter compileChain;
    private MxmlFilter precompileChain;
    private boolean logCompilerErrors;
    static final /* synthetic */ boolean $assertionsDisabled;

    public void init() throws ServletException {
        if (ServiceFactory.getConfigurator() == null || ServiceFactory.getExtensionManager() == null) {
            throw new ServletException("Invalid Configuration: see previous failures.");
        }
        this.initializeExtensions();
        this.compileChain = this.createCompileChain();
        this.precompileChain = this.createPrecompileChain();
        this.logCompilerErrors = ServiceFactory.getConfigurator().getServerConfiguration().getDebuggingConfiguration().logCompilerErrors();
    }

    private void initializeExtensions() {
        ExtensionManager extensionManager = ServiceFactory.getExtensionManager();
        this.asSwfExt = extensionManager.getAsSwfExt();
        this.mxmlSwdExt = extensionManager.getMxmlSwdExt();
        this.mxmlSwfExt = extensionManager.getMxmlSwfExt();
        this.swdExt = extensionManager.getSwdExt();
        this.swfExt = extensionManager.getSwfExt();
        this.swcSwdExt = extensionManager.getSwcSwdExt();
        this.swcSwfExt = extensionManager.getSwcSwfExt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        request.setCharacterEncoding("UTF-8");
        String url = request.getRequestURL().toString();
        url = URLDecoder.decode(url);
        PathResolver.setThreadLocalPathResolver(new flex.webtier.util.ServletPathResolver(this.getServletContext()));
        flex2.compiler.common.PathResolver resolver = new flex2.compiler.common.PathResolver();
        resolver.addSinglePathResolver((SinglePathResolver)new ServletPathResolver(this.getServletContext()));
        resolver.addSinglePathResolver((SinglePathResolver)LocalFilePathResolver.getSingleton());
        resolver.addSinglePathResolver((SinglePathResolver)URLPathResolver.getSingleton());
        ThreadLocalToolkit.setPathResolver((flex2.compiler.common.PathResolver)resolver);
        LocalizationManager localizationManager = new LocalizationManager();
        localizationManager.addLocalizer((ILocalizer)new XLRLocalizer());
        localizationManager.addLocalizer((ILocalizer)new ResourceBundleLocalizer());
        ThreadLocalToolkit.setLocalizationManager((LocalizationManager)localizationManager);
        try {
            if (this.isContypeRequest(request, url)) {
                this.handleRequestFromContype(response);
            } else if (this.isJspMxml(url)) {
                this.handleJspMxmlRequest(request, response);
            } else if (this.isMxmlSwfRequest(url) || this.isMxmlSwdRequest(url) || this.isAsSwfRequest(url)) {
                if (!$assertionsDisabled && url.indexOf(this.mxmlSwdExt) != -1) {
                    throw new AssertionError((Object)(this.swdExt + " requests should all be handled through the cache filter"));
                }
                this.handleMxmlRequest(request, response);
            } else if (this.isSwcRequest(url)) {
                this.handleSwcExtractRequest();
            } else if (this.isPrecompiledSwfRequest(url) || this.isPrecompiledSwdRequest(url)) {
                this.handlePrecompiledSwfRequest(request, response);
            }
        }
        finally {
            ServletUtils.clearThreadLocals();
        }
    }

    public static void sendNotAvailableResponse(HttpServletResponse response, String status, String message, Throwable t) throws IOException {
        response.sendError(481, status);
        ServiceFactory.getLogger().logError(message, t);
    }

    private void handleRequestFromContype(HttpServletResponse response) {
        response.setContentType("application/x-shockwave-flash");
    }

    private void handleSwcExtractRequest() {
    }

    private void handlePrecompiledSwfRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            MxmlContext context = new MxmlContext();
            context.setRequest(request);
            context.setResponse(response);
            context.setServletContext(this.getServletContext());
            this.setupMxmlContextKeys(this.getServletContext(), context, request);
            this.setupCompileEventLogger(context, request);
            this.precompileChain.invoke(context);
        }
        catch (FileNotFoundException fnfe) {
            response.sendError(404);
            if (this.logCompilerErrors) {
                ServiceFactory.getLogger().logError(fnfe.getMessage(), fnfe);
            }
        }
        catch (Throwable t) {
            if (Trace.error) {
                t.printStackTrace();
            }
            SwfServlet.sendNotAvailableResponse(response, "Unknown error", "Unknown error " + request.getServletPath() + ": " + t.getMessage(), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMxmlRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        MxmlContext context = new MxmlContext();
        context.setRequest(request);
        context.setResponse(response);
        context.setServletContext(this.getServletContext());
        context.setPageTitle(request.getServletPath());
        this.setupMxmlContextKeys(this.getServletContext(), context, request);
        this.setupSourceCodeLoader(context);
        try {
            ServiceFactory.setThreadLocalLicense((String)request.getAttribute("flexbuilder3"));
            if (!ServiceFactory.getLicenseService().isMxmlCompileEnabled()) {
                response.sendError(481, "The current license does not support this feature.");
                ServiceFactory.getLogger().logError("The current license does not support this feature. request=" + request.getServletPath());
                return;
            }
            this.setupCompileEventLogger(context, request);
            this.compileChain.invoke(context);
        }
        catch (FileNotFoundException fnfe) {
            response.sendError(404);
            if (this.logCompilerErrors) {
                ServiceFactory.getLogger().logError(fnfe.getMessage(), fnfe);
            }
        }
        catch (Throwable t) {
            if (Trace.error) {
                t.printStackTrace();
            }
            SwfServlet.sendNotAvailableResponse(response, "Unknown error", "Unknown error " + request.getServletPath() + ": " + t.getMessage(), t);
        }
        finally {
            ServiceFactory.setThreadLocalLicense(null);
        }
    }

    private void handleJspMxmlRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            Class<?> handlerClass = Class.forName("flex.webtier.server.j2ee.jsp.JspSwfRequestHandler");
            Constructor<?> constructor = handlerClass.getConstructor(new Class[0]);
            SwfRequestHandler rh = (SwfRequestHandler)constructor.newInstance(new Object[0]);
            rh.processRequest(request, response, this.getServletContext());
        }
        catch (Exception e) {
            SwfServlet.sendNotAvailableResponse(response, "JspSwflRequest Handler Unavailable", "JspSwfRequest Handler Unavailable", e);
        }
    }

    private MxmlFilter createCompileChain() {
        PathExistsFilter pathExistsFilter = new PathExistsFilter();
        RecompileFilter recompileFilter = new RecompileFilter();
        BrowserCacheFilter browserCacheFilter = new BrowserCacheFilter();
        BaseCompileFilter compileFilter = ServiceFactory.getConfigurator().getServerConfiguration().isIncrementalCompile() ? new IncrementalCompileFilter(this.swfExt) : new CompileFilter(this.swfExt);
        SwfRenderFilter swfRenderFilter = new SwfRenderFilter(this.swfExt, this.swdExt);
        pathExistsFilter.setNext(recompileFilter);
        recompileFilter.setNext(browserCacheFilter);
        browserCacheFilter.setNext(compileFilter);
        compileFilter.setNext(swfRenderFilter);
        return pathExistsFilter;
    }

    private MxmlFilter createPrecompileChain() {
        RecompileFilter recompileFilter = new RecompileFilter();
        BrowserCacheFilter browserCacheFilter = new BrowserCacheFilter();
        PrecompileFilter precompileFilter = new PrecompileFilter(this.swfExt);
        SwfRenderFilter swfRenderFilter = new SwfRenderFilter(this.swfExt, this.swdExt);
        recompileFilter.setNext(browserCacheFilter);
        browserCacheFilter.setNext(precompileFilter);
        precompileFilter.setNext(swfRenderFilter);
        return recompileFilter;
    }

    private boolean isContypeRequest(HttpServletRequest request, String path) {
        boolean isContype = false;
        if (path.endsWith(this.swfExt) && request.getHeader("User-Agent") != null && request.getHeader("User-Agent").equalsIgnoreCase("contype")) {
            isContype = true;
        }
        return isContype;
    }

    private boolean isJspMxml(String path) {
        String base;
        boolean isJspMxml = false;
        if (this.isMxmlSwfRequest(path) && (base = path.substring(path.lastIndexOf(47) + 1, path.indexOf(this.mxmlSwfExt))).length() == 32) {
            isJspMxml = true;
            for (int i = 0; i < 32 && isJspMxml; ++i) {
                if (Character.isDigit(base.charAt(i)) || base.charAt(i) == 'A' || base.charAt(i) == 'B' || base.charAt(i) == 'C' || base.charAt(i) == 'D' || base.charAt(i) == 'E' || base.charAt(i) == 'F') continue;
                isJspMxml = false;
            }
        }
        return isJspMxml;
    }

    private boolean isMxmlSwfRequest(String path) {
        boolean isMxmlSwf = false;
        if (path.endsWith(this.mxmlSwfExt)) {
            isMxmlSwf = true;
        }
        return isMxmlSwf;
    }

    private boolean isAsSwfRequest(String path) {
        boolean isAsSwf = false;
        if (path.endsWith(this.asSwfExt)) {
            isAsSwf = true;
        }
        return isAsSwf;
    }

    private boolean isMxmlSwdRequest(String path) {
        boolean isMxmlSwd = false;
        if (path.endsWith(this.mxmlSwdExt)) {
            isMxmlSwd = true;
        }
        return isMxmlSwd;
    }

    private boolean isSwcRequest(String path) {
        boolean isSwc = false;
        if (path.endsWith(this.swcSwfExt) || path.endsWith(this.swcSwdExt)) {
            isSwc = true;
        }
        return isSwc;
    }

    private boolean isPrecompiledSwfRequest(String path) {
        boolean isPrecompiledSwf = false;
        if (path.endsWith(this.swfExt) && !path.endsWith(this.mxmlSwfExt) && !path.endsWith(this.swcSwfExt)) {
            isPrecompiledSwf = true;
        }
        return isPrecompiledSwf;
    }

    private boolean isPrecompiledSwdRequest(String path) {
        boolean isPrecompiledSwd = false;
        if (path.endsWith(this.swdExt) && !path.endsWith(this.mxmlSwdExt) && !path.endsWith(this.swcSwdExt)) {
            isPrecompiledSwd = true;
        }
        return isPrecompiledSwd;
    }

    static {
        $assertionsDisabled = !SwfServlet.class.desiredAssertionStatus();
    }
}

