/*
 * Decompiled with CFR 0.152.
 */
package flex.webtier.server.j2ee;

import flex.webtier.server.j2ee.MxmlContext;
import flex.webtier.server.j2ee.MxmlFilter;
import flex.webtier.server.j2ee.PathValidator;
import flex.webtier.server.j2ee.PlatformFileUtils;
import flex.webtier.server.j2ee.SWFInfo;
import flex.webtier.server.j2ee.cache.CacheHelper;
import flex.webtier.server.j2ee.cache.CacheKeyUtils;
import flex.webtier.util.J2EEUtil;
import flex.webtier.util.Trace;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;

public class PrecompileFilter
extends MxmlFilter {
    private String swfExt;

    public PrecompileFilter(String swfExt) {
        this.swfExt = swfExt;
    }

    public void invoke(MxmlContext context) throws Throwable {
        String path = context.getRequest().getServletPath();
        path = path.replace('\\', '/');
        String fileName = J2EEUtil.getRealPath((String)(path = PlatformFileUtils.normalize(path)), (ServletContext)context.getServletContext());
        if (fileName != null) {
            PathValidator.checkFileExists(fileName, context.getRequest());
            byte[] swfBuffer = this.toSwf(fileName, context);
            if (swfBuffer.length > 0) {
                context.setSwfBuffer(swfBuffer);
            }
            if (this.next != null) {
                this.next.invoke(context);
            }
        } else {
            throw new FileNotFoundException("File not found: " + context.getRequest().getServletPath());
        }
    }

    private byte[] toSwf(String filename, MxmlContext context) throws Throwable {
        CacheHelper ch = CacheHelper.getInstance(context.getServletContext());
        String cacheKey = CacheKeyUtils.getUrlData((HttpServletRequest)context.getRequest()).cacheKey;
        ch.lockCache();
        try {
            SWFInfo swfInfo = ch.getFromCache(cacheKey);
            if (swfInfo != null) {
                if (Trace.cache) {
                    Trace.trace((String)("[cache] swfinfo in content cache up-to-date; cache key = " + cacheKey));
                }
            } else {
                if (Trace.cache) {
                    Trace.trace((String)("[cache] reload swf; cache key = " + cacheKey));
                }
                swfInfo = this.readSwfFromDisk(context);
                HashMap<String, Long> dependencies = new HashMap<String, Long>();
                dependencies.put(filename, new Long(swfInfo.getLastModified()));
                ch.addToCache(cacheKey, swfInfo, dependencies);
            }
            context.setLastModifiedTime(swfInfo.getLastModified());
            return swfInfo.getSwfBuffer();
        }
        catch (Throwable t) {
            ch.unlockCache(cacheKey);
            ch.removeFromCache(cacheKey);
            throw t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SWFInfo readSwfFromDisk(MxmlContext context) throws IOException {
        SWFInfo swfInfo = null;
        String path = context.getRequest().getServletPath();
        try {
            long lastModified;
            byte[] data;
            path = path.replace('\\', '/');
            path = PlatformFileUtils.normalize(path);
            String fileName = J2EEUtil.getRealPath((String)path, (ServletContext)context.getServletContext());
            File swfFile = null;
            if (fileName.endsWith(this.swfExt)) {
                swfFile = new File(fileName);
            }
            if (swfFile != null) {
                data = new byte[(int)swfFile.length()];
                DataInputStream in = new DataInputStream(new FileInputStream(swfFile));
                try {
                    in.readFully(data);
                }
                finally {
                    in.close();
                }
                lastModified = swfFile.lastModified();
                lastModified -= lastModified % 1000L;
            } else {
                throw new FileNotFoundException("Unable to find " + path);
            }
            swfInfo = new SWFInfo(fileName, context.getServletContext(), context.getRequest(), lastModified);
            swfInfo.setSwfBuffer(data);
        }
        catch (FileNotFoundException fnfe) {
            throw new FileNotFoundException("Unable to find " + path);
        }
        return swfInfo;
    }
}

