/*
 * Decompiled with CFR 0.152.
 */
package macromedia.asc.embedding;

import java.util.StringTokenizer;
import macromedia.asc.util.ByteList;

public class SwfMaker {
    public static final int stagShowFrame = 1;
    public static final int stagEnableDebugger2 = 64;
    public static final int stagDebugID = 63;
    public static final int stagFileAttributes = 69;
    public static final int stagDoABC = 72;
    public static final int stagSymbolClass = 76;
    public static final int swfFlagsUseNetwork = 1;
    public static final int swfFlagsSwfRelativeUrls = 2;
    public static final int swfFlagsNoCrossdomainCache = 4;
    public static final int swfFlagsAS3 = 8;
    public static final int swfFlagsHasMetadata = 16;
    public static final int kDefaultSwfFlags = 0;
    int bitPos;
    int bitBuf;
    ByteList buffer = new ByteList();
    int pos = 0;
    int tagCode = 0;
    int tagPos = 0;
    int tagLen = 0;
    boolean tagIsBig = false;

    private int CoreAbs(int n) {
        return n < 0 ? -n : n;
    }

    SwfMaker() {
    }

    void SetPos(int n) {
        this.pos = n;
    }

    void CheckSpace(int n) {
        this.buffer.resize(this.pos + n);
    }

    void PutData(byte[] byArray) {
        this.CheckSpace(byArray.length);
        for (int i = 0; i < byArray.length; ++i) {
            this.buffer.set(this.pos++, byArray[i]);
        }
    }

    void PutByte(byte by) {
        this.CheckSpace(1);
        this.buffer.set(this.pos++, by);
    }

    void PutString(String string) {
        this.PutData(string.getBytes());
        this.PutByte((byte)0);
    }

    void PutWord(int n) {
        this.CheckSpace(2);
        this.buffer.set(this.pos++, (byte)n);
        this.buffer.set(this.pos++, (byte)(n >> 8));
    }

    void PutDWord(int n) {
        this.CheckSpace(4);
        this.buffer.set(this.pos++, (byte)n);
        this.buffer.set(this.pos++, (byte)(n >> 8));
        this.buffer.set(this.pos++, (byte)(n >> 16));
        this.buffer.set(this.pos++, (byte)(n >> 24));
    }

    void StartTag(int n, boolean bl) {
        this.tagCode = n;
        this.tagPos = this.pos;
        this.tagIsBig = bl;
        this.PutWord(0);
        if (bl) {
            this.PutDWord(0);
        }
    }

    void FinishTag() {
        int n = this.pos;
        int n2 = this.pos - this.tagPos - (this.tagIsBig ? 6 : 2);
        this.pos = this.tagPos;
        if (this.tagIsBig) {
            this.PutWord((short)(this.tagCode << 6 | 0x3F));
            this.PutDWord(n2);
        } else {
            this.PutWord((short)(this.tagCode << 6 | n2));
        }
        this.pos = n;
        this.tagCode = 0;
    }

    int CountBits(int n) {
        int n2 = 0;
        while ((n & 0xFFFFFFF0) != 0) {
            n >>= 4;
            n2 += 4;
        }
        while (n != 0) {
            n >>= 1;
            ++n2;
        }
        return n2;
    }

    int CheckMag(int n, int n2) {
        if (n < 0) {
            n = -n;
        }
        return n > n2 ? n : n2;
    }

    void InitBits() {
        this.bitPos = 8;
        this.bitBuf = 0;
    }

    void FlushBits() {
        if (this.bitPos < 8) {
            this.PutByte((byte)this.bitBuf);
        }
    }

    void PutBits(int n, int n2) {
        if (n2 <= 0) {
            return;
        }
        while (true) {
            n &= -1 >> 32 - n2;
            int n3 = n2 - this.bitPos;
            if (n3 <= 0) {
                this.bitBuf |= n << -n3;
                this.bitPos -= n2;
                return;
            }
            this.bitBuf |= n >> n3;
            n2 -= this.bitPos;
            this.PutByte((byte)this.bitBuf);
            this.bitBuf = 0;
            this.bitPos = 8;
        }
    }

    void PutRect(SRECT sRECT) {
        this.InitBits();
        int n = this.CheckMag(sRECT.xmin, this.CheckMag(sRECT.xmax, this.CheckMag(sRECT.ymin, this.CoreAbs(sRECT.ymax))));
        int n2 = this.CountBits(n) + 1;
        if (n2 < 15) {
            n2 = 15;
        }
        this.PutBits(n2, 5);
        this.PutBits(sRECT.xmin, n2);
        this.PutBits(sRECT.xmax, n2);
        this.PutBits(sRECT.ymin, n2);
        this.PutBits(sRECT.ymax, n2);
        this.FlushBits();
    }

    public boolean EncodeABC(ByteList byteList, String string) {
        int n;
        int n2;
        String string2 = null;
        int n3 = 12;
        int n4 = 0;
        boolean bl = false;
        int n5 = string.indexOf(",-g");
        if (n5 > -1) {
            bl = true;
            string = string.substring(0, n5) + string.substring(n5 + 3);
        }
        if ((n5 = string.indexOf(",-usenetwork")) > -1) {
            n4 = 1;
            string = string.substring(0, n5) + string.substring(n5 + 12);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        switch (stringTokenizer.countTokens()) {
            case 2: {
                n2 = Integer.parseInt(stringTokenizer.nextToken());
                n = Integer.parseInt(stringTokenizer.nextToken());
                break;
            }
            case 3: {
                string2 = stringTokenizer.nextToken();
                n2 = Integer.parseInt(stringTokenizer.nextToken());
                n = Integer.parseInt(stringTokenizer.nextToken());
                break;
            }
            case 4: {
                string2 = stringTokenizer.nextToken();
                n2 = Integer.parseInt(stringTokenizer.nextToken());
                n = Integer.parseInt(stringTokenizer.nextToken());
                n3 = Integer.parseInt(stringTokenizer.nextToken());
                break;
            }
            default: {
                return false;
            }
        }
        this.PutByte((byte)70);
        this.PutByte((byte)87);
        this.PutByte((byte)83);
        this.PutByte((byte)9);
        this.PutDWord(0);
        SRECT sRECT = new SRECT(this);
        sRECT.xmin = 0;
        sRECT.ymin = 0;
        sRECT.xmax = n2 * 20;
        sRECT.ymax = n * 20;
        this.PutRect(sRECT);
        this.PutWord(n3 << 8);
        this.PutWord(1);
        this.StartTag(69, false);
        this.PutDWord(8 | n4);
        this.FinishTag();
        if (bl) {
            this.StartTag(64, false);
            this.PutWord(6517);
            this.PutString("");
            this.FinishTag();
            this.StartTag(63, false);
            this.PutData(new byte[]{-54, 73, -106, -57, 87, -114, 32, 2, -35, -110, -90, 63, 24, 120, -59, -68});
            this.FinishTag();
        }
        this.StartTag(72, true);
        this.PutData(byteList.toByteArray());
        this.FinishTag();
        if (string2 != null) {
            this.StartTag(76, false);
            this.PutWord(1);
            this.PutWord(0);
            this.PutString(string2);
            this.FinishTag();
        }
        this.StartTag(1, false);
        this.FinishTag();
        int n6 = this.pos;
        this.SetPos(4);
        this.PutDWord(n6);
        return true;
    }

    class SRECT {
        public int xmin;
        public int xmax;
        public int ymin;
        public int ymax;
        final /* synthetic */ SwfMaker this$0;

        /*
         * WARNING - void declaration
         */
        SRECT(SwfMaker swfMaker) {
            void arg0;
            this.this$0 = arg0;
        }
    }
}

