/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.batik.svggen.AbstractImageHandlerEncoder;
import org.apache.batik.svggen.SVGGraphics2DIOException;

public class ImageHandlerJPEGEncoder
extends AbstractImageHandlerEncoder {
    public ImageHandlerJPEGEncoder(String imageDir, String urlRoot) throws SVGGraphics2DIOException {
        super(imageDir, urlRoot);
    }

    public final String getSuffix() {
        return ".jpg";
    }

    public final String getPrefix() {
        return "jpegImage";
    }

    public void encodeImage(BufferedImage buf, File imageFile) throws SVGGraphics2DIOException {
        try {
            FileOutputStream os = new FileOutputStream(imageFile);
            JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)os);
            JPEGEncodeParam param = encoder.getDefaultJPEGEncodeParam(buf);
            param.setQuality(1.0f, false);
            encoder.encode(buf, param);
            os.flush();
            ((OutputStream)os).close();
        }
        catch (IOException e) {
            throw new SVGGraphics2DIOException("could not write image File " + imageFile.getName());
        }
    }

    public BufferedImage buildBufferedImage(Dimension size) {
        return new BufferedImage(size.width, size.height, 1);
    }
}

