/*
 * Decompiled with CFR 0.152.
 */
package flex.webtier.services.logging;

import flex.webtier.services.logging.LogEvent;
import flex.webtier.services.logging.LogEventHandler;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;

public class ThreadedLogEventHandler
extends LogEventHandler {
    protected Vector queue = new Vector();
    protected int queuePointer = 0;
    protected boolean flushing;
    protected Object lockObject = new Object();
    protected ArrayList handlers = new ArrayList();
    protected Timer timer = new Timer();

    public void addLogEventHandler(LogEventHandler handler) {
        this.handlers.add(handler);
    }

    public void init() {
        Iterator i = this.handlers.iterator();
        while (i.hasNext()) {
            LogEventHandler eh = (LogEventHandler)i.next();
            eh.init();
        }
    }

    public void start() {
        Iterator i = this.handlers.iterator();
        while (i.hasNext()) {
            LogEventHandler eh = (LogEventHandler)i.next();
            eh.start();
        }
    }

    public void stop() {
        Iterator i = this.handlers.iterator();
        while (i.hasNext()) {
            while (i.hasNext()) {
                LogEventHandler eh = (LogEventHandler)i.next();
                eh.stop();
            }
        }
        this.timer.cancel();
        this.flush();
        super.stop();
    }

    public void flush() {
        if (!this.queue.isEmpty()) {
            this.flushing = true;
            while (this.processNextInQueue()) {
            }
            this.flushing = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean logEvent(LogEvent event) {
        int size = 0;
        Object object = this.lockObject;
        synchronized (object) {
            this.queue.addElement(event);
            size = this.queue.size();
        }
        if (size == 1) {
            try {
                this.timer.schedule((TimerTask)new ProcessQueueTask(), 0L);
            }
            catch (Exception ex) {
                new ProcessQueueTask().run();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized boolean processNextInQueue() {
        boolean more = false;
        if (this.queuePointer < this.queue.size()) {
            Object eh;
            boolean b;
            more = true;
            LogEvent event = (LogEvent)this.queue.elementAt(this.queuePointer);
            this.queue.setElementAt(null, this.queuePointer++);
            Iterator i = this.handlers.iterator();
            while (i.hasNext() && (b = ((LogEventHandler)(eh = (LogEventHandler)i.next())).log(event))) {
            }
            eh = this.lockObject;
            synchronized (eh) {
                if (this.queuePointer >= this.queue.size()) {
                    this.queue.removeAllElements();
                    this.queuePointer = 0;
                    more = false;
                }
            }
            if (!more) {
                i = this.handlers.iterator();
                while (i.hasNext()) {
                    eh = (LogEventHandler)i.next();
                    ((LogEventHandler)eh).flush();
                }
            }
        }
        return more;
    }

    private class ProcessQueueTask
    extends TimerTask {
        private ProcessQueueTask() {
        }

        public void run() {
            if (!ThreadedLogEventHandler.this.flushing) {
                while (ThreadedLogEventHandler.this.processNextInQueue()) {
                }
            }
        }
    }
}

