/*
 * Decompiled with CFR 0.152.
 */
package flex.webtier.server.j2ee.cache;

import flex.webtier.server.j2ee.cache.InvalidResourceException;
import java.io.File;

public class Resource {
    protected String path;
    protected File file;
    private long lastModCheckTime;
    private long lastMod = 0L;

    public Resource(String path, File file) {
        this.path = path;
        this.file = file;
    }

    public String getName() {
        return this.path;
    }

    public long getLastModified() throws InvalidResourceException {
        if (this.file == null) {
            this.file = new File(this.path);
        }
        if (this.file != null && this.file.exists()) {
            long now = System.currentTimeMillis();
            if (now > this.lastModCheckTime + 1000L) {
                this.lastMod = this.file.lastModified();
                this.lastModCheckTime = now;
            }
            return this.lastMod;
        }
        throw new InvalidResourceException(this.path);
    }
}

