/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.FontByteArray;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;
import java.io.IOException;

public final class OTByteArray
extends FontByteArray {
    private OTByteArray(int n) {
        super(n);
    }

    OTByteArray(FontByteArray fontByteArray) throws IOException, InvalidFontException, UnsupportedFontException {
        super(fontByteArray, false);
    }

    private OTByteArray(OTByteArray oTByteArray) {
        super(oTByteArray, true);
    }

    public static final OTByteArrayBuilder getOTByteArrayBuilderInstance() {
        return new OTByteArrayBuilder();
    }

    static final OTByteArrayBuilder getOTByteArrayBuilderInstance(int n) {
        return new OTByteArrayBuilder(n);
    }

    static final OTByteArrayBuilder getOTByteArrayBuilderInstance(OTByteArray oTByteArray) {
        return new OTByteArrayBuilder(oTByteArray);
    }

    public final int getuint8(int n) throws InvalidFontException {
        return this.getRawByte(n) & 0xFF;
    }

    protected final int getint8(int n) throws InvalidFontException {
        return this.getSignedRawByte(n);
    }

    protected final int getuint16(int n) throws InvalidFontException {
        return this.getuint8(n) << 8 | this.getuint8(n + 1);
    }

    public final int getint16(int n) throws InvalidFontException {
        return this.getint8(n) << 8 | this.getuint8(n + 1);
    }

    protected final int getint32(int n) throws InvalidFontException {
        return this.getint8(n) << 24 | this.getuint8(n + 1) << 16 | this.getuint8(n + 2) << 8 | this.getuint8(n + 3);
    }

    protected final long getuint32(int n) throws InvalidFontException {
        return (long)this.getuint8(n) << 24 | (long)(this.getuint8(n + 1) << 16) | (long)(this.getuint8(n + 2) << 8) | (long)this.getuint8(n + 3);
    }

    protected final int getuint32asint(int n, String string) throws UnsupportedFontException, InvalidFontException {
        if (this.getuint8(n) > 127) {
            throw new UnsupportedFontException(string);
        }
        return (int)this.getuint32(n);
    }

    protected final int[] getFixed(int n) throws InvalidFontException {
        int[] nArray = new int[]{this.getuint16(n), this.getuint16(n + 2)};
        return nArray;
    }

    protected final long getLONGDATETIME(int n) throws InvalidFontException {
        return this.getuint32(n) << 32 | this.getuint32(n);
    }

    protected final int getOffset(int n, int n2) throws InvalidFontException {
        int n3 = this.getuint16(n + n2);
        if (n3 != 0) {
            return n + n3;
        }
        return 0;
    }

    protected long checksum() throws InvalidFontException {
        return this.checksum(0, this.getSize(), 0L);
    }

    protected long checksum(int n, int n2, long l) throws InvalidFontException {
        while (n < n2) {
            int n3 = this.getuint8(n++);
            int n4 = 0;
            if (n < n2) {
                n4 = this.getuint8(n++);
            }
            int n5 = 0;
            if (n < n2) {
                n5 = this.getuint8(n++);
            }
            int n6 = 0;
            if (n < n2) {
                n6 = this.getuint8(n++);
            }
            int n7 = n3 << 24 | n4 << 16 | n5 << 8 | n6;
            l = l + (long)n7 & 0xFFFFFFFFL;
        }
        return l;
    }

    public boolean equals(Object object) {
        if (!(object instanceof OTByteArray)) {
            return false;
        }
        return super.equals(object);
    }

    static final class OTByteArrayBuilder
    extends FontByteArray.FontByteArrayBuilder {
        protected OTByteArrayBuilder() {
            super(new OTByteArray(1024));
        }

        protected OTByteArrayBuilder(int n) {
            super(new OTByteArray(n));
        }

        protected OTByteArrayBuilder(OTByteArray oTByteArray) {
            super(new OTByteArray(oTByteArray));
        }

        final void setuint8(int n, int n2) {
            this.setRawByte(n, n2 & 0xFF);
        }

        final void setuint16(int n, int n2) {
            this.setRawByte(n, n2 >> 8 & 0xFF);
            this.setRawByte(++n, n2 & 0xFF);
        }

        final void setint16(int n, int n2) {
            this.setuint16(n, n2);
        }

        final void setuint32(int n, int n2) {
            this.setRawByte(n, n2 >> 24 & 0xFF);
            this.setRawByte(++n, n2 >> 16 & 0xFF);
            this.setRawByte(++n, n2 >> 8 & 0xFF);
            this.setRawByte(++n, n2 & 0xFF);
        }

        final void setFixed(int n, int n2, int n3) throws InvalidFontException {
            this.setuint16(n, n2);
            this.setuint16(n + 2, n3);
        }

        final long checksum(int n, int n2, long l) throws InvalidFontException {
            return ((OTByteArray)this.byteArray).checksum();
        }

        OTByteArray toOTByteArray() {
            OTByteArray oTByteArray = (OTByteArray)this.byteArray;
            this.byteArray = null;
            return oTByteArray;
        }
    }
}

