/* Copyright 2008 we-lab-doc! (http://www.we-lab-doc.com/)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import com.we_lab_doc.spacecard.service.PMTSerialManager
import com.we_lab_doc.spacecard.model.*
import com.we_lab_doc.spacecard.utils.*
import com.we_lab_doc.spacecard.bean.annotation.SpaceCardCustomBean

/**
 * @author Shigeru GOUGI
 * @since 0.1
 *        <p/>
 *        Created: February 24, 2008
 */
@SpaceCardCustomBean
final class DefaultPMTSerialManager implements PMTSerialManager {
	boolean initialize() {
		def serials = PMTSerial.list()
		if(serials.size() == 0) {
			PMTSerial.withTransaction{ tx ->
				def model = new PMTSerial(nextValue:0)
				if(!ModelUtils.saveWithRollback(model,tx))
					return false
			}
		}
		return true
	}
	synchronized long generateSerial() {
		def serials = PMTSerial.list()
		assert serials.size() == 1
		def curSerial = serials[0]
		curSerial.lock()
		curSerial.nextValue += 1
		return curSerial.nextValue
	}
}