/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.job.executor;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmConfiguration;
import org.jbpm.job.executor.JobExecutorThread;
import org.jbpm.job.executor.LockMonitorThread;

public class JobExecutor
implements Serializable {
    private static final long serialVersionUID = 1L;
    JbpmConfiguration jbpmConfiguration;
    String name;
    int nbrOfThreads;
    int idleInterval;
    int maxIdleInterval;
    int historyMaxSize;
    int maxLockTime;
    int lockMonitorInterval;
    int lockBufferTime;
    Map threads = new HashMap();
    LockMonitorThread lockMonitorThread;
    Map monitoredJobIds = Collections.synchronizedMap(new HashMap());
    boolean isStarted = false;
    private static Log log = LogFactory.getLog((Class)JobExecutor.class);

    public synchronized void start() {
        if (!this.isStarted) {
            log.debug((Object)("starting thread group '" + this.name + "'..."));
            for (int i = 0; i < this.nbrOfThreads; ++i) {
                this.startThread();
            }
            this.isStarted = true;
        } else {
            log.debug((Object)("ignoring start: thread group '" + this.name + "' is already started'"));
        }
        this.lockMonitorThread = new LockMonitorThread(this.jbpmConfiguration, this.lockMonitorInterval, this.maxLockTime, this.lockBufferTime);
    }

    public synchronized List stop() {
        ArrayList<Thread> stoppedThreads = new ArrayList<Thread>(this.threads.size());
        if (this.isStarted) {
            log.debug((Object)("stopping thread group '" + this.name + "'..."));
            for (int i = 0; i < this.nbrOfThreads; ++i) {
                stoppedThreads.add(this.stopThread());
            }
            this.isStarted = false;
        } else {
            log.debug((Object)("ignoring stop: thread group '" + this.name + "' not started"));
        }
        return stoppedThreads;
    }

    public void stopAndJoin() throws InterruptedException {
        Iterator iter = this.stop().iterator();
        while (iter.hasNext()) {
            Thread thread = (Thread)iter.next();
            thread.join();
        }
    }

    protected synchronized void startThread() {
        String threadName = this.getNextThreadName();
        JobExecutorThread thread = new JobExecutorThread(threadName, this, this.jbpmConfiguration, this.idleInterval, this.maxIdleInterval, this.maxLockTime, this.historyMaxSize);
        this.threads.put(threadName, thread);
        log.debug((Object)("starting new job executor thread '" + threadName + "'"));
        thread.start();
    }

    protected String getNextThreadName() {
        return this.getThreadName(this.threads.size() + 1);
    }

    protected String getLastThreadName() {
        return this.getThreadName(this.threads.size());
    }

    private String getThreadName(int index) {
        return this.name + ":" + this.getHostName() + ":" + index;
    }

    private String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception e) {
            return "unknown";
        }
    }

    protected synchronized Thread stopThread() {
        String threadName = this.getLastThreadName();
        JobExecutorThread thread = (JobExecutorThread)this.threads.remove(threadName);
        log.debug((Object)("removing job executor thread '" + threadName + "'"));
        thread.setActive(false);
        thread.interrupt();
        return thread;
    }

    public Set getMonitoredJobIds() {
        return new HashSet(this.monitoredJobIds.values());
    }

    public void addMonitoredJobId(String threadName, long jobId) {
        this.monitoredJobIds.put(threadName, new Long(jobId));
    }

    public void removeMonitoredJobId(String threadName) {
        this.monitoredJobIds.remove(threadName);
    }

    public int getHistoryMaxSize() {
        return this.historyMaxSize;
    }

    public int getIdleInterval() {
        return this.idleInterval;
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    public JbpmConfiguration getJbpmConfiguration() {
        return this.jbpmConfiguration;
    }

    public int getMaxIdleInterval() {
        return this.maxIdleInterval;
    }

    public String getName() {
        return this.name;
    }

    public int getSize() {
        return this.nbrOfThreads;
    }

    public Map getThreads() {
        return this.threads;
    }

    public int getMaxLockTime() {
        return this.maxLockTime;
    }

    public int getLockBufferTime() {
        return this.lockBufferTime;
    }

    public int getLockMonitorInterval() {
        return this.lockMonitorInterval;
    }

    public int getNbrOfThreads() {
        return this.nbrOfThreads;
    }
}

