/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.type1;

import com.adobe.fontengine.font.FontInputStream;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.postscript.Token;
import com.adobe.fontengine.font.postscript.TokenType;
import com.adobe.fontengine.font.postscript.Tokenizer;
import com.adobe.fontengine.font.type1.MetricFile;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Comparator;

final class AFM
extends MetricFile {
    private String fontName;
    private static final byte[] kFontName = new byte[]{70, 111, 110, 116, 78, 97, 109, 101};
    private static final byte[][] kOptionalTokens = new byte[][]{{83, 116, 97, 114, 116, 75, 101, 114, 110, 80, 97, 105, 114, 115}, {83, 116, 97, 114, 116, 75, 101, 114, 110, 80, 97, 105, 114, 115, 48}};
    private static final byte[][] kKernPairStart = new byte[][]{{75, 80}, {75, 80, 88}};
    private final KernPair[] kernPairs;
    private static final Comparator kpComp = new Comparator(){

        public int compare(Object object, Object object2) {
            KernPair kernPair = (KernPair)object;
            KernPair kernPair2 = (KernPair)object2;
            int n = kernPair.leftGName.compareTo(kernPair2.leftGName);
            if (n < 0) {
                return -1;
            }
            if (n > 0) {
                return 1;
            }
            n = kernPair.rightGName.compareTo(kernPair2.rightGName);
            if (n < 0) {
                return -1;
            }
            if (n > 0) {
                return 1;
            }
            return 0;
        }
    };

    public double getKernValue(String string, String string2) {
        KernPair kernPair = new KernPair(string, string2, 0.0);
        int n = Arrays.binarySearch(this.kernPairs, kernPair, kpComp);
        if (n >= 0) {
            return this.kernPairs[n].kernAmount;
        }
        return 0.0;
    }

    public String getFamilyName() {
        return null;
    }

    public String getFontName() {
        return this.fontName;
    }

    public int getWeight() {
        return 0;
    }

    private AFM(String string, KernPair[] kernPairArray, URL uRL) throws IOException, InvalidFontException {
        super(uRL);
        this.fontName = string;
        Arrays.sort(kernPairArray, kpComp);
        this.kernPairs = kernPairArray;
    }

    static KernPair[] parseKernPairs(Tokenizer tokenizer, int n) throws IOException, InvalidFontException {
        KernPair[] kernPairArray = new KernPair[n];
        for (int i = 0; i < n; ++i) {
            double d;
            byte[] byArray = tokenizer.findOptionalTokensAtStartOfLine(kKernPairStart);
            if (byArray == null) {
                return new KernPair[0];
            }
            Token token = tokenizer.getNextPSToken();
            if (token.tokenType != TokenType.kOPERATOR) {
                return new KernPair[0];
            }
            String string = token.stringTokenToString(0, token.tokenLength);
            token = tokenizer.getNextPSToken();
            if (token.tokenType != TokenType.kOPERATOR) {
                return new KernPair[0];
            }
            String string2 = token.stringTokenToString(0, token.tokenLength);
            token = tokenizer.getNextPSToken();
            if (token.tokenType == TokenType.kINTEGER) {
                d = token.convertInteger(0);
            } else if (token.tokenType == TokenType.kREAL) {
                d = Double.parseDouble(new String(token.buff, 0, token.tokenLength));
            } else {
                return new KernPair[0];
            }
            kernPairArray[i] = new KernPair(string, string2, d);
        }
        return kernPairArray;
    }

    static MetricFile createAFM(FontInputStream fontInputStream, URL uRL) throws IOException, InvalidFontException {
        KernPair[] kernPairArray = null;
        Tokenizer tokenizer = new Tokenizer(fontInputStream);
        tokenizer.findToken(kFontName);
        Token token = tokenizer.getNextPSToken();
        char[] cArray = new char[token.tokenLength];
        for (int i = 0; i < token.tokenLength; ++i) {
            cArray[i] = (char)token.buff[i];
        }
        String string = new String(cArray);
        byte[] byArray = tokenizer.findOptionalTokensAtStartOfLine(kOptionalTokens);
        if (byArray != null) {
            int n;
            token = tokenizer.getNextPSToken();
            if (token.tokenType == TokenType.kINTEGER && (n = token.convertInteger(0)) > 0) {
                kernPairArray = AFM.parseKernPairs(tokenizer, n);
            }
        }
        if (kernPairArray == null) {
            kernPairArray = new KernPair[]{};
        }
        return new AFM(string, kernPairArray, uRL);
    }

    private static class KernPair {
        final String leftGName;
        final String rightGName;
        final double kernAmount;

        KernPair(String string, String string2, double d) {
            this.leftGName = string;
            this.rightGName = string2;
            this.kernAmount = d;
        }
    }
}

