/*
 * Decompiled with CFR 0.152.
 */
package macromedia.abc;

import macromedia.abc.ByteArrayPool;
import macromedia.abc.BytecodeBuffer;
import macromedia.abc.ConstantPool;
import macromedia.abc.MultiNamePool;
import macromedia.abc.NSPool;
import macromedia.abc.NSSPool;

final class IndexHistory {
    public int total;
    public int duplicate;
    public int totalBytes;
    public int duplicateBytes;
    private ConstantPool[] pools;
    private int[] poolSizes;
    private int[] map;
    private ByteArrayPool intP;
    private ByteArrayPool uintP;
    private ByteArrayPool doubleP;
    private ByteArrayPool stringP;
    private ByteArrayPool nsP;
    private ByteArrayPool nssP;
    private ByteArrayPool mnP;
    private BytecodeBuffer in4;
    private BytecodeBuffer in5;
    private BytecodeBuffer in6;
    private boolean disableDebuggingInfo = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    IndexHistory(ConstantPool[] constantPoolArray) {
        this.pools = constantPoolArray;
        this.poolSizes = new int[constantPoolArray.length];
        int n = 0;
        int n2 = 0;
        int n3 = constantPoolArray.length;
        for (int i = 0; i < n3; ++i) {
            this.poolSizes[i] = i == 0 ? 0 : n;
            n += constantPoolArray[i].size();
            n2 += constantPoolArray[i].mnEnd - constantPoolArray[i].strEnd;
        }
        this.map = new int[n];
        this.in4 = new BytecodeBuffer(n2);
        this.in5 = new BytecodeBuffer(n2);
        this.in6 = new BytecodeBuffer(n2);
        this.intP = new ByteArrayPool();
        this.uintP = new ByteArrayPool();
        this.doubleP = new ByteArrayPool();
        this.stringP = new ByteArrayPool();
        this.nsP = new NSPool();
        this.nssP = new NSSPool();
        this.mnP = new MultiNamePool();
        this.total = 0;
        this.duplicate = 0;
        this.totalBytes = 0;
        this.duplicateBytes = 0;
    }

    void disableDebugging() {
        this.disableDebuggingInfo = true;
    }

    public int getIndex(int n, int n2, int n3) {
        if (n3 == 0) {
            return 0;
        }
        int n4 = this.calculateIndex(n, n2, n3);
        if (this.map[n4] == 0) {
            this.decodeOnDemand(n, n2, n3, n4);
        }
        return this.map[n4];
    }

    public void writeTo(BytecodeBuffer bytecodeBuffer) {
        this.intP.writeTo(bytecodeBuffer);
        this.uintP.writeTo(bytecodeBuffer);
        this.doubleP.writeTo(bytecodeBuffer);
        this.stringP.writeTo(bytecodeBuffer);
        this.nsP.writeTo(bytecodeBuffer);
        this.nssP.writeTo(bytecodeBuffer);
        this.mnP.writeTo(bytecodeBuffer);
    }

    private final int calculateIndex(int n, int n2, int n3) {
        int n4 = this.poolSizes[n];
        if (n2 > 0) {
            n4 += this.pools[n].intpositions.length == 0 ? 0 : this.pools[n].intpositions.length - 1;
        }
        if (n2 > 1) {
            n4 += this.pools[n].uintpositions.length == 0 ? 0 : this.pools[n].uintpositions.length - 1;
        }
        if (n2 > 2) {
            n4 += this.pools[n].doublepositions.length == 0 ? 0 : this.pools[n].doublepositions.length - 1;
        }
        if (n2 > 3) {
            n4 += this.pools[n].strpositions.length == 0 ? 0 : this.pools[n].strpositions.length - 1;
        }
        if (n2 > 4) {
            n4 += this.pools[n].nspositions.length == 0 ? 0 : this.pools[n].nspositions.length - 1;
        }
        if (n2 > 5) {
            n4 += this.pools[n].nsspositions.length == 0 ? 0 : this.pools[n].nsspositions.length - 1;
        }
        if (n2 > 6) {
            n4 += this.pools[n].mnpositions.length == 0 ? 0 : this.pools[n].mnpositions.length - 1;
        }
        return n4 += n3 - 1;
    }

    private final void decodeOnDemand(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        ConstantPool constantPool = this.pools[n];
        ByteArrayPool byteArrayPool = null;
        BytecodeBuffer bytecodeBuffer = null;
        int[] nArray = null;
        int n7 = 0;
        int n8 = 0;
        if (n2 == 0) {
            nArray = constantPool.intpositions;
            n7 = nArray.length;
            n8 = constantPool.intEnd;
            byteArrayPool = this.intP;
            bytecodeBuffer = constantPool.in;
        } else if (n2 == 1) {
            nArray = constantPool.uintpositions;
            n7 = nArray.length;
            n8 = constantPool.uintEnd;
            byteArrayPool = this.uintP;
            bytecodeBuffer = constantPool.in;
        } else if (n2 == 2) {
            nArray = constantPool.doublepositions;
            n7 = nArray.length;
            n8 = constantPool.doubleEnd;
            byteArrayPool = this.doubleP;
            bytecodeBuffer = constantPool.in;
        } else if (n2 == 3) {
            nArray = constantPool.strpositions;
            n7 = nArray.length;
            n8 = constantPool.strEnd;
            byteArrayPool = this.stringP;
            bytecodeBuffer = constantPool.in;
        } else if (n2 == 4) {
            nArray = constantPool.nspositions;
            n7 = nArray.length;
            n8 = constantPool.nsEnd;
            byteArrayPool = this.nsP;
            bytecodeBuffer = constantPool.in;
        } else if (n2 == 5) {
            nArray = constantPool.nsspositions;
            n7 = nArray.length;
            n8 = constantPool.nssEnd;
            byteArrayPool = this.nssP;
            bytecodeBuffer = constantPool.in;
        } else if (n2 == 6) {
            nArray = constantPool.mnpositions;
            n7 = nArray.length;
            n8 = constantPool.mnEnd;
            byteArrayPool = this.mnP;
            bytecodeBuffer = constantPool.in;
        }
        int n9 = nArray[n3];
        int n10 = n6 = n3 != n7 - 1 ? nArray[n3 + 1] : n8;
        if (n2 == 4) {
            n5 = nArray[n3];
            int n11 = bytecodeBuffer.pos();
            bytecodeBuffer.seek(n5);
            n9 = this.in4.size();
            int n12 = bytecodeBuffer.readU8();
            this.in4.writeU8(n12);
            switch (n12) {
                case 5: {
                    if (this.disableDebuggingInfo) {
                        this.in4.writeU32(0L);
                        break;
                    }
                }
                case 8: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: {
                    int n13 = bytecodeBuffer.readU32();
                    int n14 = this.getIndex(n, 3, n13);
                    this.in4.writeU32(n14);
                    break;
                }
                default: {
                    if ($assertionsDisabled) break;
                    throw new Error();
                }
            }
            bytecodeBuffer.seek(n11);
            n6 = this.in4.size();
            bytecodeBuffer = this.in4;
        } else if (n2 == 5) {
            n5 = nArray[n3];
            int n15 = bytecodeBuffer.pos();
            bytecodeBuffer.seek(n5);
            n9 = this.in5.size();
            int n16 = bytecodeBuffer.readU32();
            this.in5.writeU32(n16);
            for (int i = 0; i < n16; ++i) {
                int n17 = bytecodeBuffer.readU32();
                int n18 = this.getIndex(n, 4, n17);
                this.in5.writeU32(n18);
            }
            bytecodeBuffer.seek(n15);
            n6 = this.in5.size();
            bytecodeBuffer = this.in5;
        } else if (n2 == 6) {
            n5 = nArray[n3];
            int n19 = bytecodeBuffer.pos();
            bytecodeBuffer.seek(n5);
            n9 = this.in6.size();
            int n20 = bytecodeBuffer.readU8();
            this.in6.writeU8(n20);
            switch (n20) {
                case 7: 
                case 13: {
                    int n21 = bytecodeBuffer.readU32();
                    int n22 = this.getIndex(n, 4, n21);
                    this.in6.writeU32(n22);
                    int n23 = bytecodeBuffer.readU32();
                    int n24 = this.getIndex(n, 3, n23);
                    this.in6.writeU32(n24);
                    break;
                }
                case 9: 
                case 14: {
                    int n25 = bytecodeBuffer.readU32();
                    int n26 = this.getIndex(n, 3, n25);
                    this.in6.writeU32(n26);
                    int n27 = bytecodeBuffer.readU32();
                    int n28 = this.getIndex(n, 5, n27);
                    this.in6.writeU32(n28);
                    break;
                }
                case 15: 
                case 16: {
                    int n29 = bytecodeBuffer.readU32();
                    int n30 = this.getIndex(n, 3, n29);
                    this.in6.writeU32(n30);
                    break;
                }
                case 17: 
                case 18: {
                    break;
                }
                case 27: 
                case 28: {
                    int n31 = bytecodeBuffer.readU32();
                    int n32 = this.getIndex(n, 5, n31);
                    this.in6.writeU32(n32);
                    break;
                }
                default: {
                    if ($assertionsDisabled) break;
                    throw new Error();
                }
            }
            bytecodeBuffer.seek(n19);
            n6 = this.in6.size();
            bytecodeBuffer = this.in6;
        }
        n5 = byteArrayPool.contains(bytecodeBuffer, n9, n6);
        if (n5 == -1) {
            n5 = byteArrayPool.store(bytecodeBuffer, n9, n6);
        } else {
            ++this.duplicate;
            this.duplicateBytes += n6 - n9;
        }
        ++this.total;
        this.totalBytes += n6 - n9;
        if (n3 != 0) {
            this.map[n4] = n5;
        }
    }

    static {
        $assertionsDisabled = true;
    }
}

