/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.directive;

import java.io.IOException;
import java.io.Writer;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.directive.InputBase;
import org.apache.velocity.runtime.parser.node.Node;
import org.apache.velocity.runtime.resource.ContentResource;

public class Include
extends InputBase {
    private String outputMsgStart = "";
    private String outputMsgEnd = "";

    public String getName() {
        return "include";
    }

    public int getType() {
        return 2;
    }

    public void init(RuntimeServices rs, InternalContextAdapter context, Node node) throws Exception {
        super.init(rs, context, node);
        this.outputMsgStart = this.rsvc.getString("directive.include.output.errormsg.start");
        this.outputMsgStart = this.outputMsgStart + " ";
        this.outputMsgEnd = this.rsvc.getString("directive.include.output.errormsg.end");
        this.outputMsgEnd = " " + this.outputMsgEnd;
    }

    public boolean render(InternalContextAdapter context, Writer writer, Node node) throws IOException, MethodInvocationException, ResourceNotFoundException {
        int argCount = node.jjtGetNumChildren();
        for (int i = 0; i < argCount; ++i) {
            Node n = node.jjtGetChild(i);
            if (n.getType() == 6 || n.getType() == 14) {
                if (this.renderOutput(n, context, writer)) continue;
                this.outputErrorToStream(writer, "error with arg " + i + " please see log.");
                continue;
            }
            this.rsvc.error("#include() error : invalid argument type : " + n.toString());
            this.outputErrorToStream(writer, "error with arg " + i + " please see log.");
        }
        return true;
    }

    private boolean renderOutput(Node node, InternalContextAdapter context, Writer writer) throws IOException, MethodInvocationException, ResourceNotFoundException {
        String arg = "";
        if (node == null) {
            this.rsvc.error("#include() error :  null argument");
            return false;
        }
        Object value = node.value(context);
        if (value == null) {
            this.rsvc.error("#include() error :  null argument");
            return false;
        }
        arg = value.toString();
        ContentResource resource = null;
        try {
            resource = this.rsvc.getContent(arg, this.getInputEncoding(context));
        }
        catch (ResourceNotFoundException rnfe) {
            this.rsvc.error("#include(): cannot find resource '" + arg + "', called from template " + context.getCurrentTemplateName() + " at (" + this.getLine() + ", " + this.getColumn() + ")");
            throw rnfe;
        }
        catch (Exception e) {
            this.rsvc.error("#include(): arg = '" + arg + "', called from template " + context.getCurrentTemplateName() + " at (" + this.getLine() + ", " + this.getColumn() + ") : " + e);
        }
        if (resource == null) {
            return false;
        }
        writer.write((String)resource.getData());
        return true;
    }

    private void outputErrorToStream(Writer writer, String msg) throws IOException {
        if (this.outputMsgStart != null && this.outputMsgEnd != null) {
            writer.write(this.outputMsgStart);
            writer.write(msg);
            writer.write(this.outputMsgEnd);
        }
    }
}

