/*
 * Decompiled with CFR 0.152.
 */
package flex.webtier.server.j2ee.filemanager;

import flash.util.StringUtils;
import flex.webtier.compiler.ConfigConstants;
import flex.webtier.server.j2ee.DetectionSettingsFactory;
import flex.webtier.server.j2ee.HistorySettingsFactory;
import flex.webtier.server.j2ee.filemanager.FileManager;
import flex.webtier.server.j2ee.filemanager.InternalFile;
import flex.webtier.server.j2ee.html.DetectionSettings;
import flex.webtier.server.j2ee.html.HistorySettings;
import flex.webtier.services.ServiceFactory;
import flex.webtier.services.config.FlashPlayerConfiguration;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class HistoryFileManager
extends FileManager
implements ConfigConstants {
    public static String HISTORY_URI = "{context.root}/flex-internal";
    public static String HISTORY_ACTION_SWF = "history_swf";
    public static String HISTORY_ACTION_JS = "history_js";
    public static String HISTORY_ACTION_HTML = "history_html";
    public static String HISTORY_ACTION_HTML_SECURE = "history_html_secure";
    private static HistoryFileManager hm;
    public HistorySettings historySettings;
    private ByteArrayOutputStream historyJavascript = this.getFile("history/history.js");

    public static HistoryFileManager getInstance() throws IOException {
        if (hm == null) {
            hm = new HistoryFileManager();
        }
        return hm;
    }

    protected HistoryFileManager() throws IOException {
    }

    void init(Map internalFiles) throws IOException {
        internalFiles.put(HISTORY_ACTION_SWF, new InternalFile(System.currentTimeMillis(), this.getFile("history/history.swf")));
        internalFiles.put(HISTORY_ACTION_JS, new InternalFile(System.currentTimeMillis(), this.historyJavascript));
    }

    void initializeDynamicFiles(HttpServletRequest request, Map internalFiles) {
        this.historySettings = HistorySettingsFactory.getInstance(request.getContextPath());
        internalFiles.put(HISTORY_ACTION_HTML, new InternalFile(System.currentTimeMillis(), this.getHistoryHtml(request, false)));
        internalFiles.put(HISTORY_ACTION_HTML_SECURE, new InternalFile(System.currentTimeMillis(), this.getHistoryHtml(request, true)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteArrayOutputStream getHistoryHtml(HttpServletRequest request, boolean secure) {
        String contextPath = request.getContextPath();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintWriter writer = new PrintWriter(out);
        try {
            String pluginDownloadURL = null;
            String activexDownloadURL = null;
            FlashPlayerConfiguration config = ServiceFactory.getConfigurator().getServerConfiguration().getFlashPlayerConfiguration();
            pluginDownloadURL = secure && config.getPluginDownloadHttpsUrl() != null ? config.getPluginDownloadHttpsUrl() : config.getPluginDownloadUrl();
            activexDownloadURL = secure && config.getActivexDownloadHttpsUrl() != null ? config.getActivexDownloadHttpsUrl() : config.getActivexDownloadUrl();
            pluginDownloadURL = StringUtils.substitute((String)pluginDownloadURL, (String)"{context.root}", (String)contextPath);
            activexDownloadURL = StringUtils.substitute((String)activexDownloadURL, (String)"{context.root}", (String)contextPath);
            DetectionSettings detectionSettings = DetectionSettingsFactory.getInstance(contextPath);
            if (detectionSettings.enabled()) {
                this.getHistoryHtmlWithDetection(writer, detectionSettings, pluginDownloadURL, activexDownloadURL);
            } else {
                this.getHistoryHtmlWithoutDetection(writer, pluginDownloadURL, activexDownloadURL);
            }
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (out != null) {
                out.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (writer != null) {
                writer.close();
            }
        }
        catch (Exception e) {}
        return out;
    }

    private void getHistoryHtmlWithDetection(PrintWriter writer, DetectionSettings detectionSettings, String pluginDownloadURL, String activexDownloadURL) {
        writer.println("<html>");
        writer.println("<head>");
        writer.println("<script type='text/javascript' language='JavaScript1.2' charset='utf-8'>");
        writer.println("var v = new top.Vars(top.getSearch(window));");
        writer.println("var fv = v.toString('$_');");
        writer.println("</script>");
        writer.println("<script language='javascript' charset='utf-8' src='" + detectionSettings.getTagsJavascript() + "'></script>");
        writer.println("<script language='javascript' type='text/javascript'>");
        writer.println("<!--");
        writer.println("// -----------------------------------------------------------------------------");
        writer.println("// Globals");
        writer.println("// Major version of Flash required");
        writer.println("var requiredMajorVersion = " + detectionSettings.getMajorVersion() + ";");
        writer.println("// Minor version of Flash required");
        writer.println("var requiredMinorVersion = " + detectionSettings.getMinorVersion() + ";");
        writer.println("// Minor version of Flash require");
        writer.println("var requiredRevision = " + detectionSettings.getVersionRevision() + ";");
        writer.println("// -----------------------------------------------------------------------------");
        writer.println("// -->");
        writer.println("</script>");
        writer.println("</head>");
        writer.println("<script language='JavaScript' type='text/javascript'>");
        writer.println("<!--");
        writer.println("// Version check based upon the values entered above in \"Globals\"");
        writer.println("var hasRequestedVersion = DetectFlashVer(requiredMajorVersion, requiredMinorVersion, requiredRevision);");
        writer.println("");
        writer.println("// Check to see if the version meets the requirements for playback");
        writer.println("if (hasRequestedVersion) {  // if we've detected an acceptable version");
        writer.println("// if we've detected an acceptable version");
        writer.println("// embed the Flash Content SWF when all tests are passed");
        writer.println("document.writeln('<object id=\"utility\" name=\"" + this.historySettings.getSwfUri() + "\" classid=\"clsid:D27CDB6E-AE6D-11cf-96B8-444553540000\" codebase=\"" + activexDownloadURL + "#version=7,0,14,0\" width=\"100\" height=\"50\">');");
        writer.println("document.writeln('<param name=\"movie\" value=\"" + this.historySettings.getSwfUri() + "\" />');");
        writer.println("document.writeln('<param name=\"FlashVars\" value=\"'+fv+'&$_lconid='+top.lc_id+'\"/>');");
        writer.println("document.writeln('<param name=\"quality\" value=\"high\" />');");
        writer.println("document.writeln('<param name=\"bgcolor\" value=\"#FFFFFF\" />');");
        writer.println("document.writeln('<param name=\"profile\" value=\"false\" />');");
        writer.println("document.writeln('<embed id=\"utilityEmbed\" name=\"history.swf\" src=\"" + this.historySettings.getSwfUri() + "\" type=\"application/x-shockwave-flash\" flashvars=\"'+fv+'&$_lconid='+top.lc_id+'\" profile=\"false\" quality=\"high\" bgcolor=\"#FFFFFF\" width=\"100\" height=\"50\" align=\"\" pluginspage=\"" + pluginDownloadURL + "\"></embed>');");
        writer.println("document.writeln('</object>');");
        writer.println("} else {  // flash is too old or we can't detect the plugin");
        writer.println("");
        writer.println("}");
        writer.println("// -->");
        writer.println("</script>");
        writer.println("</body>");
        writer.println("</html>");
        writer.flush();
    }

    private void getHistoryHtmlWithoutDetection(PrintWriter writer, String pluginDownloadURL, String activexDownloadURL) {
        writer.println("<html>");
        writer.println("<head>");
        writer.println("<script type='text/javascript' language='JavaScript1.2' charset='utf-8'>");
        writer.println("var v = new top.Vars(top.getSearch(window));");
        writer.println("var fv = v.toString('$_');");
        writer.println("</script>");
        writer.println("</head>");
        writer.println("<body >");
        writer.println("<script type='text/javascript' language='JavaScript1.2' charset='utf-8'>");
        writer.println("document.writeln('<object id=\"utility\" name=\"" + this.historySettings.getSwfUri() + "\" classid=\"clsid:D27CDB6E-AE6D-11cf-96B8-444553540000\" codebase=\"" + activexDownloadURL + "#version=7,0,14,0\" width=\"100\" height=\"50\">');");
        writer.println("document.writeln('<param name=\"movie\" value=\"" + this.historySettings.getSwfUri() + "\" />');");
        writer.println("document.writeln('<param name=\"FlashVars\" value=\"'+fv+'&$_lconid='+top.lc_id+'\"/>');");
        writer.println("document.writeln('<param name=\"quality\" value=\"high\" />');");
        writer.println("document.writeln('<param name=\"bgcolor\" value=\"#FFFFFF\" />');");
        writer.println("document.writeln('<param name=\"profile\" value=\"false\" />');");
        writer.println("document.writeln('<embed id=\"utilityEmbed\" name=\"history.swf\" src=\"" + this.historySettings.getSwfUri() + "\" type=\"application/x-shockwave-flash\" flashvars=\"'+fv+'&$_lconid='+top.lc_id+'\" profile=\"false\" quality=\"high\" bgcolor=\"#FFFFFF\" width=\"100\" height=\"50\" align=\"\" pluginspage=\"" + pluginDownloadURL + "\"></embed>');");
        writer.println("document.writeln('</object>');");
        writer.println("</script>");
        writer.println("</body>");
        writer.println("</html>");
        writer.flush();
    }

    public ByteArrayOutputStream getHistoryJavascript() {
        return this.historyJavascript;
    }
}

