/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.services.messaging;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import flex.management.ManageableComponent;
import flex.messaging.FlexContext;
import flex.messaging.MessageClient;
import flex.messaging.MessageDestination;
import flex.messaging.MessageException;
import flex.messaging.client.FlexClient;
import flex.messaging.log.Log;
import flex.messaging.messages.AsyncMessage;
import flex.messaging.messages.Message;
import flex.messaging.security.MessagingSecurity;
import flex.messaging.services.MessageService;
import flex.messaging.services.ServiceAdapter;
import flex.messaging.services.ServiceException;
import flex.messaging.services.messaging.Subtopic;
import flex.messaging.services.messaging.selector.JMSSelector;
import flex.messaging.services.messaging.selector.JMSSelectorException;
import flex.messaging.util.StringUtils;
import flex.messaging.util.TimeoutManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SubscriptionManager
extends ManageableComponent {
    public static final String TYPE = "SubscriptionManager";
    private static final Object classMutex = new Object();
    private static int instanceCount = 0;
    protected final MessageDestination destination;
    private long subscriptionTimeoutMillis;
    protected final Map allSubscriptions = new ConcurrentHashMap();
    private final TopicSubscription globalSubscribers = new TopicSubscription();
    private final Map subscribersPerSubtopic = new ConcurrentHashMap();
    private final Map subscribersPerSubtopicWildcard = new ConcurrentHashMap();
    private static final int SUBTOPICS_NOT_SUPPORTED = 10553;
    private TimeoutManager subscriberSessionManager;

    public SubscriptionManager(MessageDestination destination) {
        this(destination, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SubscriptionManager(MessageDestination destination, boolean enableManagement) {
        super(enableManagement);
        Object object = classMutex;
        synchronized (object) {
            super.setId(TYPE + ++instanceCount);
        }
        this.destination = destination;
        this.subscriptionTimeoutMillis = 0L;
    }

    public void setId(String id) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        SubscriptionManager subscriptionManager = this;
        synchronized (subscriptionManager) {
            if (!this.allSubscriptions.isEmpty()) {
                Iterator iter = this.allSubscriptions.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry subscription = iter.next();
                    this.removeSubscriber((MessageClient)subscription.getValue());
                }
            }
        }
    }

    public void setSubscriptionTimeoutMillis(long value) {
        this.subscriptionTimeoutMillis = value;
        if (this.subscriptionTimeoutMillis > 0L) {
            this.subscriberSessionManager = new TimeoutManager();
        }
    }

    public long getSubscriptionTimeoutMillis() {
        return this.subscriptionTimeoutMillis;
    }

    public Object getSubscriptionState() {
        ArrayList subState = new ArrayList();
        if (this.globalSubscribers.defaultSubscriptions != null && !this.globalSubscribers.defaultSubscriptions.isEmpty()) {
            subState.add(null);
            subState.add(null);
        }
        if (this.globalSubscribers.selectorSubscriptions != null) {
            Iterator it = this.globalSubscribers.selectorSubscriptions.keySet().iterator();
            while (it.hasNext()) {
                subState.add(it.next());
                subState.add(null);
            }
        }
        this.addSubscriptionState(subState, this.subscribersPerSubtopic);
        this.addSubscriptionState(subState, this.subscribersPerSubtopicWildcard);
        if (Log.isDebug()) {
            Log.getLogger((String)"Service.Message").debug("Retrieved subscription state to send to new cluster member for destination: " + this.destination.getId() + ": " + StringUtils.NEWLINE + subState);
        }
        return subState;
    }

    private void addSubscriptionState(List subState, Map subsPerSubtopic) {
        Iterator it = subsPerSubtopic.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Subtopic subtopic = (Subtopic)entry.getKey();
            TopicSubscription tc = (TopicSubscription)entry.getValue();
            if (tc.defaultSubscriptions != null && !tc.defaultSubscriptions.isEmpty()) {
                subState.add(null);
                subState.add(subtopic.toString());
            }
            if (tc.selectorSubscriptions == null) continue;
            Iterator sit = tc.selectorSubscriptions.keySet().iterator();
            while (sit.hasNext()) {
                subState.add(sit.next());
                subState.add(subtopic.toString());
            }
        }
    }

    protected String getDebugSubscriptionState() {
        StringBuffer sb = new StringBuffer();
        sb.append(" global subscriptions: " + this.globalSubscribers + StringUtils.NEWLINE);
        sb.append(" regular subtopic subscriptions: " + this.subscribersPerSubtopic + StringUtils.NEWLINE);
        sb.append(" wildcard subtopic subscriptions: " + this.subscribersPerSubtopicWildcard + StringUtils.NEWLINE);
        return sb.toString();
    }

    public Set getSubscriberIds() {
        return this.allSubscriptions.keySet();
    }

    public Set getSubscriberIds(Message message, boolean evalSelector) {
        LinkedHashSet ids = new LinkedHashSet();
        List<Object> subtopicObj = message.getHeader("DSSubtopic");
        if (subtopicObj instanceof Object[]) {
            subtopicObj = Arrays.asList((Object[])subtopicObj);
        }
        if (subtopicObj instanceof String) {
            String subtopicString = (String)((Object)subtopicObj);
            if (subtopicString.length() > 0) {
                this.addSubtopicSubscribers(subtopicString, message, ids, evalSelector);
            } else {
                this.addTopicSubscribers(this.globalSubscribers, message, ids, evalSelector);
            }
        } else if (subtopicObj instanceof List) {
            List<Object> subtopicList = subtopicObj;
            for (int i = 0; i < subtopicList.size(); ++i) {
                this.addSubtopicSubscribers((String)subtopicList.get(i), message, ids, evalSelector);
            }
        } else {
            this.addTopicSubscribers(this.globalSubscribers, message, ids, evalSelector);
        }
        return ids;
    }

    public Set getSubscriberIds(String subtopicPattern, Map messageHeaders) {
        AsyncMessage msg = new AsyncMessage();
        msg.setHeader("DSSubtopic", subtopicPattern);
        if (messageHeaders != null) {
            msg.setHeaders(messageHeaders);
        }
        return this.getSubscriberIds(msg, true);
    }

    void addSubtopicSubscribers(String subtopicString, Message message, Set ids, boolean evalSelector) {
        if (!this.destination.getServerSettings().getAllowSubtopics()) {
            ServiceException se = new ServiceException();
            se.setMessage(10553, new Object[]{subtopicString, this.destination.getId()});
            throw se;
        }
        Subtopic subtopic = this.getSubtopic(subtopicString);
        ServiceAdapter adapter = this.destination.getAdapter();
        if (adapter instanceof MessagingSecurity && !((MessagingSecurity)((Object)adapter)).allowSend(subtopic)) {
            ServiceException se = new ServiceException();
            se.setMessage(10558, new Object[]{subtopicString});
            throw se;
        }
        TopicSubscription ts = (TopicSubscription)this.subscribersPerSubtopic.get(subtopic);
        this.addTopicSubscribers(ts, message, ids, evalSelector);
        Set subtopics = this.subscribersPerSubtopicWildcard.keySet();
        Iterator iter = subtopics.iterator();
        while (iter.hasNext()) {
            Subtopic st = (Subtopic)iter.next();
            if (!st.matches(subtopic)) continue;
            ts = (TopicSubscription)this.subscribersPerSubtopicWildcard.get(st);
            this.addTopicSubscribers(ts, message, ids, evalSelector);
        }
    }

    void addTopicSubscribers(TopicSubscription ts, Message message, Set ids, boolean evalSelector) {
        if (ts == null) {
            return;
        }
        Map subs = ts.defaultSubscriptions;
        if (subs != null) {
            ids.addAll(subs.keySet());
        }
        if (ts.selectorSubscriptions != null) {
            Iterator sit = ts.selectorSubscriptions.entrySet().iterator();
            while (sit.hasNext()) {
                Map.Entry entry = sit.next();
                String selector = (String)entry.getKey();
                subs = (Map)entry.getValue();
                if (!evalSelector) {
                    ids.addAll(subs.keySet());
                    continue;
                }
                JMSSelector jmsSel = new JMSSelector(selector);
                try {
                    if (!jmsSel.match(message)) continue;
                    ids.addAll(subs.keySet());
                }
                catch (JMSSelectorException jmse) {
                    if (!Log.isWarn()) continue;
                    Log.getLogger((String)"Message.Selector").warn("Error processing message selector: " + jmsSel + StringUtils.NEWLINE + "  incomingMessage: " + message + StringUtils.NEWLINE + "  selector: " + selector);
                }
            }
        }
    }

    public MessageClient getSubscriber(Object clientId) {
        MessageClient client = (MessageClient)this.allSubscriptions.get(clientId);
        if (client != null && !client.isTimingOut()) {
            this.monitorTimeout(client);
        }
        return client;
    }

    public void removeSubscriber(MessageClient client) {
        client.invalidate();
        if (this.getSubscriber(client.getClientId()) != null) {
            Log.getLogger((String)"Service.Message").error("Failed to remove client: " + client.getClientId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSubscriber(Object clientId, String selector, String subtopicString, String endpointId) {
        Subtopic subtopic = this.getSubtopic(subtopicString);
        MessageClient client = null;
        try {
            Map subs;
            SubscriptionManager subscriptionManager;
            TopicSubscription topicSub;
            boolean subscriptionAlreadyExists = this.getSubscriber(clientId) != null;
            client = this.getMessageClient(clientId, endpointId);
            FlexClient flexClient = FlexContext.getFlexClient();
            if (subscriptionAlreadyExists) {
                if (flexClient != null && !flexClient.getId().equals(client.getFlexClient().getId())) {
                    ServiceException se = new ServiceException();
                    se.setMessage(10559, new Object[]{clientId});
                    throw se;
                }
                client.resetEndpoint(endpointId);
            }
            ServiceAdapter adapter = this.destination.getAdapter();
            client.updateLastUse();
            if (subtopic == null) {
                topicSub = this.globalSubscribers;
            } else {
                if (!this.destination.getServerSettings().getAllowSubtopics()) {
                    ServiceException se = new ServiceException();
                    se.setMessage(10553, new Object[]{subtopicString, this.destination.getId()});
                    throw se;
                }
                if (adapter instanceof MessagingSecurity && subtopic != null && !((MessagingSecurity)((Object)adapter)).allowSubscribe(subtopic)) {
                    ServiceException se = new ServiceException();
                    se.setMessage(10557, new Object[]{subtopicString});
                    throw se;
                }
                Map map = subtopic.containsSubtopicWildcard() ? this.subscribersPerSubtopicWildcard : this.subscribersPerSubtopic;
                topicSub = (TopicSubscription)map.get(subtopic);
                if (topicSub == null) {
                    subscriptionManager = this;
                    synchronized (subscriptionManager) {
                        topicSub = (TopicSubscription)map.get(subtopic);
                        if (topicSub == null) {
                            topicSub = new TopicSubscription();
                            map.put(subtopic, topicSub);
                        }
                    }
                }
            }
            if (selector == null) {
                subs = topicSub.defaultSubscriptions;
                if (subs == null) {
                    subscriptionManager = this;
                    synchronized (subscriptionManager) {
                        subs = topicSub.defaultSubscriptions;
                        if (subs == null) {
                            topicSub.defaultSubscriptions = subs = new ConcurrentHashMap();
                        }
                    }
                }
            } else {
                if (topicSub.selectorSubscriptions == null) {
                    subscriptionManager = this;
                    synchronized (subscriptionManager) {
                        if (topicSub.selectorSubscriptions == null) {
                            topicSub.selectorSubscriptions = new ConcurrentHashMap();
                        }
                    }
                }
                if ((subs = (Map)topicSub.selectorSubscriptions.get(selector)) == null) {
                    subscriptionManager = this;
                    synchronized (subscriptionManager) {
                        subs = (Map)topicSub.selectorSubscriptions.get(selector);
                        if (subs == null) {
                            subs = new ConcurrentHashMap();
                            topicSub.selectorSubscriptions.put(selector, subs);
                        }
                    }
                }
            }
            if (subs.containsKey(clientId)) {
                if (Log.isWarn()) {
                    Log.getLogger((String)"Message.Selector").warn("Client: " + clientId + " already subscribed to: " + this.destination.getId() + " selector: " + selector + " subtopic: " + subtopicString);
                }
            } else {
                client.addSubscription(selector, subtopicString);
                subscriptionManager = this;
                synchronized (subscriptionManager) {
                    if (subs.isEmpty() && this.destination.isClustered() && !this.destination.getServerSettings().isBroadcastRoutingMode()) {
                        this.sendSubscriptionToPeer(true, selector, subtopicString);
                    }
                    subs.put(clientId, client);
                }
                this.monitorTimeout(client);
            }
            this.releaseMessageClient(client);
        }
        catch (Throwable throwable) {
            this.releaseMessageClient(client);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSubscriber(Object clientId, String selector, String subtopicString, String endpointId) {
        MessageClient client = (MessageClient)this.allSubscriptions.get(clientId);
        if (client == null) {
            return;
        }
        Subtopic subtopic = this.getSubtopic(subtopicString);
        Map map = null;
        try {
            TopicSubscription topicSub;
            client = this.getMessageClient(clientId, endpointId);
            if (subtopic == null) {
                topicSub = this.globalSubscribers;
            } else {
                map = subtopic.containsSubtopicWildcard() ? this.subscribersPerSubtopicWildcard : this.subscribersPerSubtopic;
                topicSub = (TopicSubscription)map.get(subtopic);
                if (topicSub == null) {
                    throw new MessageException("Client: " + clientId + " not subscribed to subtopic: " + subtopic);
                }
            }
            Map subs = selector == null ? topicSub.defaultSubscriptions : (Map)topicSub.selectorSubscriptions.get(selector);
            if (subs == null || subs.get(clientId) == null) {
                throw new MessageException("Client: " + clientId + " not subscribed to destination with selector: " + selector);
            }
            SubscriptionManager subscriptionManager = this;
            synchronized (subscriptionManager) {
                subs.remove(clientId);
                if (subs.isEmpty() && this.destination.isClustered() && !this.destination.getServerSettings().isBroadcastRoutingMode()) {
                    this.sendSubscriptionToPeer(false, selector, subtopicString);
                }
                if (subs.isEmpty()) {
                    if (selector != null && topicSub.selectorSubscriptions != null && topicSub.selectorSubscriptions.isEmpty()) {
                        topicSub.selectorSubscriptions.remove(selector);
                    }
                    if (!(subtopic == null || topicSub.selectorSubscriptions != null && !topicSub.selectorSubscriptions.isEmpty() || topicSub.defaultSubscriptions != null && !topicSub.defaultSubscriptions.isEmpty() || topicSub.selectorSubscriptions != null && !topicSub.selectorSubscriptions.isEmpty() || topicSub.defaultSubscriptions != null && !topicSub.defaultSubscriptions.isEmpty())) {
                        map.remove(subtopic);
                    }
                }
            }
            if (client.removeSubscription(selector, subtopicString)) {
                this.allSubscriptions.remove(clientId);
                client.invalidate();
            }
        }
        finally {
            this.releaseMessageClient(client);
        }
    }

    protected MessageClient newMessageClient(Object clientId, String endpointId) {
        return new MessageClient(clientId, this.destination, endpointId);
    }

    public MessageClient registerMessageClient(Object clientId, String endpointId) {
        MessageClient client = this.getMessageClient(clientId, endpointId);
        this.monitorTimeout(client);
        if (client.isRegistered()) {
            this.releaseMessageClient(client);
        } else {
            client.setRegistered(true);
        }
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageClient getMessageClient(Object clientId, String endpointId) {
        Map map = this.allSubscriptions;
        synchronized (map) {
            MessageClient client = (MessageClient)this.allSubscriptions.get(clientId);
            if (client == null) {
                client = this.newMessageClient(clientId, endpointId);
                this.allSubscriptions.put(clientId, client);
            }
            client.incrementReferences();
            return client;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseMessageClient(MessageClient client) {
        if (client == null) {
            return;
        }
        Map map = this.allSubscriptions;
        synchronized (map) {
            if (client.decrementReferences()) {
                this.allSubscriptions.remove(client.getClientId());
                client.invalidate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void monitorTimeout(MessageClient client) {
        if (this.subscriberSessionManager != null) {
            MessageClient messageClient = client;
            synchronized (messageClient) {
                if (!client.isTimingOut()) {
                    this.subscriberSessionManager.scheduleTimeout(client);
                    client.setTimingOut(true);
                }
            }
        }
    }

    private Subtopic getSubtopic(String subtopic) {
        if (subtopic == null) {
            return null;
        }
        return new Subtopic(subtopic, this.destination.getServerSettings().getSubtopicSeparator());
    }

    protected void sendSubscriptionToPeer(boolean subscribe, String selector, String subtopic) {
        if (Log.isDebug()) {
            Log.getLogger((String)"Service.Message").debug("Sending subscription to peers for subscribe? " + subscribe + " selector: " + selector + " subtopic: " + subtopic);
        }
        ((MessageService)this.destination.getService()).sendSubscribeFromPeer(this.destination.getId(), subscribe ? Boolean.TRUE : Boolean.FALSE, selector, subtopic);
    }

    protected String getLogCategory() {
        return "Service.Message";
    }

    static class TopicSubscription {
        Map defaultSubscriptions;
        Map selectorSubscriptions;

        TopicSubscription() {
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("default subscriptions: " + this.defaultSubscriptions + StringUtils.NEWLINE);
            sb.append("selector subscriptions: " + this.selectorSubscriptions + StringUtils.NEWLINE);
            return sb.toString();
        }
    }
}

