/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging;

import edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArrayList;
import flex.messaging.FlexContext;
import flex.messaging.FlexSession;
import flex.messaging.MessageClientListener;
import flex.messaging.MessageDestination;
import flex.messaging.MessageException;
import flex.messaging.client.FlexClient;
import flex.messaging.log.Log;
import flex.messaging.messages.CommandMessage;
import flex.messaging.messages.Message;
import flex.messaging.services.MessageService;
import flex.messaging.services.messaging.selector.JMSSelector;
import flex.messaging.services.messaging.selector.JMSSelectorException;
import flex.messaging.util.StringUtils;
import flex.messaging.util.TimeoutAbstractObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

public class MessageClient
extends TimeoutAbstractObject
implements Serializable {
    public static final String MESSAGE_CLIENT_LOG_CATEGORY = "Client.MessageClient";
    static final long serialVersionUID = 3730240451524954453L;
    private static final CopyOnWriteArrayList createdListeners = new CopyOnWriteArrayList();
    private volatile boolean clientChannelDisconnected;
    protected final Object clientId;
    protected final MessageDestination destination;
    protected final String destinationId;
    private volatile transient CopyOnWriteArrayList destroyedListeners;
    private String endpointId;
    private final transient FlexClient flexClient;
    private transient FlexSession flexSession;
    private boolean invalidating;
    protected Object lock = new Object();
    private volatile boolean attemptingInvalidationClientNotification;
    private transient int numReferences;
    protected final Set subscriptions = new TreeSet();
    protected boolean valid = true;
    private volatile boolean willTimeout;
    private volatile boolean registered = false;

    public static void addMessageClientCreatedListener(MessageClientListener listener) {
        if (listener != null) {
            createdListeners.addIfAbsent((Object)listener);
        }
    }

    public static void removeMessageClientCreatedListener(MessageClientListener listener) {
        if (listener != null) {
            createdListeners.remove((Object)listener);
        }
    }

    private static boolean equalStrings(String a, String b) {
        return a == b || a != null && a.equals(b);
    }

    private static int compareStrings(String a, String b) {
        if (a == b) {
            return 0;
        }
        if (a != null && b != null) {
            return a.compareTo(b);
        }
        if (a == null) {
            return -1;
        }
        return 1;
    }

    public MessageClient(Object clientId, MessageDestination destination, String endpointId) {
        this(clientId, destination, endpointId, true);
    }

    public MessageClient(Object clientId, MessageDestination destination, String endpointId, boolean useSession) {
        this.clientId = clientId;
        this.destination = destination;
        this.endpointId = endpointId;
        this.destinationId = destination.getId();
        this.updateLastUse();
        if (useSession) {
            this.flexSession = FlexContext.getFlexSession();
            this.flexSession.registerMessageClient(this);
            this.flexClient = FlexContext.getFlexClient();
            this.flexClient.registerMessageClient(this);
            if (!createdListeners.isEmpty()) {
                Iterator iter = createdListeners.iterator();
                while (iter.hasNext()) {
                    ((MessageClientListener)iter.next()).messageClientCreated(this);
                }
            }
        } else {
            this.flexClient = null;
            this.flexSession = null;
            this.lock = new Object();
        }
        if (Log.isDebug()) {
            Log.getLogger((String)MESSAGE_CLIENT_LOG_CATEGORY).debug("MessageClient created with clientId '" + this.clientId + "' for destination '" + this.destinationId + "'.");
        }
    }

    public Object getClientId() {
        return this.clientId;
    }

    public String getDestinationId() {
        return this.destinationId;
    }

    public String getEndpointId() {
        return this.endpointId;
    }

    public FlexClient getFlexClient() {
        return this.flexClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlexSession getFlexSession() {
        Object object = this.lock;
        synchronized (object) {
            return this.flexSession;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSubscriptionCount() {
        int count;
        Object object = this.lock;
        synchronized (object) {
            count = this.subscriptions != null ? this.subscriptions.size() : 0;
        }
        return count;
    }

    public boolean isAttemptingInvalidationClientNotification() {
        return this.attemptingInvalidationClientNotification;
    }

    public void setClientChannelDisconnected(boolean value) {
        this.clientChannelDisconnected = value;
    }

    public boolean isClientChannelDisconnected() {
        return this.clientChannelDisconnected;
    }

    public void setRegistered(boolean reg) {
        this.registered = reg;
    }

    public boolean isRegistered() {
        return this.registered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessageClientDestroyedListener(MessageClientListener listener) {
        if (listener != null) {
            this.checkValid();
            if (this.destroyedListeners == null) {
                Object object = this.lock;
                synchronized (object) {
                    if (this.destroyedListeners == null) {
                        this.destroyedListeners = new CopyOnWriteArrayList();
                    }
                }
            }
            this.destroyedListeners.addIfAbsent((Object)listener);
        }
    }

    public void removeMessageClientDestroyedListener(MessageClientListener listener) {
        if (listener != null && this.destroyedListeners != null) {
            this.destroyedListeners.remove((Object)listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSubscription(String selector, String subtopic) {
        Object object = this.lock;
        synchronized (object) {
            this.checkValid();
            this.incrementReferences();
            this.subscriptions.add(new SubscriptionInfo(selector, subtopic));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeSubscription(String selector, String subtopic) {
        Object object = this.lock;
        synchronized (object) {
            if (this.subscriptions.remove(new SubscriptionInfo(selector, subtopic))) {
                return this.decrementReferences();
            }
            if (Log.isError()) {
                Log.getLogger((String)"Service.Message").error("Error - unable to find subscription to remove for MessageClient: " + this.clientId + " selector: " + selector + " subtopic: " + subtopic);
            }
            return this.numReferences == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementReferences() {
        Object object = this.lock;
        synchronized (object) {
            ++this.numReferences;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean decrementReferences() {
        Object object = this.lock;
        synchronized (object) {
            if (--this.numReferences == 0) {
                this.cancelTimeout();
                if (this.destination.getThrottleManager() != null) {
                    this.destination.getThrottleManager().removeClientThrottleMark(this.clientId);
                }
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetEndpoint(String newEndpointId) {
        if (this.flexClient != null) {
            this.flexClient.unregisterMessageClient(this);
        }
        Object object = this.lock;
        synchronized (object) {
            this.endpointId = newEndpointId;
            this.flexSession = FlexContext.getFlexSession();
        }
        if (this.flexClient != null) {
            this.flexClient.registerMessageClient(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean testMessage(Message message) {
        String subtopic = (String)message.getHeader("DSSubtopic");
        Object object = this.lock;
        synchronized (object) {
            Iterator it = this.subscriptions.iterator();
            while (it.hasNext()) {
                SubscriptionInfo si = (SubscriptionInfo)it.next();
                String csel = si.selector;
                String csub = si.subtopic;
                if (!MessageClient.equalStrings(csub, subtopic)) continue;
                if (csel == null) {
                    return true;
                }
                JMSSelector selector = new JMSSelector(csel);
                try {
                    if (!selector.match(message)) continue;
                    return true;
                }
                catch (JMSSelectorException jmse) {
                    if (Log.isWarn()) {
                        Log.getLogger((String)"Message.Selector").warn("Error processing message selector: " + jmse.toString() + StringUtils.NEWLINE + "  incomingMessage: " + message + StringUtils.NEWLINE + "  selector: " + csel + StringUtils.NEWLINE);
                    }
                    return false;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValid() {
        Object object = this.lock;
        synchronized (object) {
            return this.valid;
        }
    }

    public void invalidate() {
        this.invalidate(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate(boolean notifyClient) {
        TreeSet<Object> subscriberIds;
        Object object = this.lock;
        synchronized (object) {
            if (!this.valid || this.invalidating) {
                return;
            }
            this.invalidating = true;
            this.cancelTimeout();
        }
        this.attemptingInvalidationClientNotification = notifyClient;
        if (notifyClient && this.flexClient != null && this.flexClient.isValid()) {
            CommandMessage msg = new CommandMessage();
            msg.setDestination(this.destination.getId());
            msg.setClientId(this.clientId);
            msg.setOperation(10);
            subscriberIds = new TreeSet<Object>();
            subscriberIds.add(this.clientId);
            try {
                ((MessageService)this.destination.getService()).pushMessageToClients(this.destination, subscriberIds, msg, false);
            }
            catch (MessageException ignore) {
                // empty catch block
            }
        }
        if (this.destroyedListeners != null && !this.destroyedListeners.isEmpty()) {
            Iterator iter = this.destroyedListeners.iterator();
            while (iter.hasNext()) {
                ((MessageClientListener)iter.next()).messageClientDestroyed(this);
            }
            this.destroyedListeners.clear();
        }
        ArrayList<CommandMessage> unsubMessages = new ArrayList<CommandMessage>();
        subscriberIds = this.lock;
        synchronized (subscriberIds) {
            Iterator iter = this.subscriptions.iterator();
            while (iter.hasNext()) {
                SubscriptionInfo subInfo = (SubscriptionInfo)iter.next();
                CommandMessage unsubMessage = new CommandMessage();
                unsubMessage.setDestination(this.destination.getId());
                unsubMessage.setClientId(this.clientId);
                unsubMessage.setOperation(1);
                unsubMessage.setHeader("DSSubscriptionInvalidated", Boolean.TRUE);
                unsubMessage.setHeader("DSSelector", subInfo.selector);
                unsubMessage.setHeader("DSSubtopic", subInfo.subtopic);
                unsubMessages.add(unsubMessage);
            }
        }
        Iterator iter = unsubMessages.iterator();
        while (iter.hasNext()) {
            this.destination.getService().serviceCommand((CommandMessage)iter.next());
        }
        Object object2 = this.lock;
        synchronized (object2) {
            int remainingSubscriptionCount = this.subscriptions.size();
            if (remainingSubscriptionCount > 0 && Log.isError()) {
                Log.getLogger((String)MESSAGE_CLIENT_LOG_CATEGORY).error("MessageClient: " + this.getClientId() + " failed to remove " + remainingSubscriptionCount + " subscription(s) during invalidation");
            }
        }
        if (this.registered) {
            this.destination.getSubscriptionManager().releaseMessageClient(this);
        }
        object2 = this.lock;
        synchronized (object2) {
            this.valid = false;
            this.invalidating = false;
        }
        if (Log.isDebug()) {
            Log.getLogger((String)MESSAGE_CLIENT_LOG_CATEGORY).debug("MessageClient with clientId '" + this.clientId + "' for destination '" + this.destinationId + "' has been invalidated.");
        }
    }

    public void invalidate(Message message) {
        if (message != null) {
            message.setDestination(this.destination.getId());
            message.setClientId(this.clientId);
            TreeSet<Object> subscriberIds = new TreeSet<Object>();
            subscriberIds.add(this.clientId);
            try {
                ((MessageService)this.destination.getService()).pushMessageToClients(this.destination, subscriberIds, message, false);
            }
            catch (MessageException messageException) {
                // empty catch block
            }
            this.invalidate(true);
        } else {
            this.invalidate();
        }
    }

    public boolean equals(Object o) {
        MessageClient c;
        return o instanceof MessageClient && (c = (MessageClient)o) != null && c.getClientId().equals(this.clientId);
    }

    public int hashCode() {
        return this.getClientId().hashCode();
    }

    public String toString() {
        return String.valueOf(this.clientId);
    }

    public long getTimeoutPeriod() {
        return this.destination.getSubscriptionManager().getSubscriptionTimeoutMillis();
    }

    public void timeout() {
        this.invalidate(true);
    }

    public boolean isTimingOut() {
        return this.willTimeout;
    }

    public void setTimingOut(boolean value) {
        this.willTimeout = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkValid() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.valid) {
                throw new RuntimeException("MessageClient has been invalidated.");
            }
        }
    }

    protected static class SubscriptionInfo
    implements Comparable {
        public String selector;
        public String subtopic;

        SubscriptionInfo(String sel, String sub) {
            this.selector = sel;
            this.subtopic = sub;
        }

        public boolean equals(Object o) {
            if (o instanceof SubscriptionInfo) {
                SubscriptionInfo other = (SubscriptionInfo)o;
                return MessageClient.equalStrings(other.selector, this.selector) && MessageClient.equalStrings(other.subtopic, this.subtopic);
            }
            return false;
        }

        public int hashCode() {
            return (this.selector == null ? 0 : this.selector.hashCode()) + (this.subtopic == null ? 1 : this.subtopic.hashCode());
        }

        public int compareTo(Object o) {
            SubscriptionInfo other = (SubscriptionInfo)o;
            int result = MessageClient.compareStrings(other.selector, this.selector);
            if (result != 0) {
                return result;
            }
            result = MessageClient.compareStrings(other.subtopic, this.subtopic);
            if (result != 0) {
                return result;
            }
            return 0;
        }
    }
}

