/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging;

import edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArrayList;
import flex.messaging.FlexContext;
import flex.messaging.FlexRemoteCredentials;
import flex.messaging.FlexSessionAttributeListener;
import flex.messaging.FlexSessionBindingEvent;
import flex.messaging.FlexSessionBindingListener;
import flex.messaging.FlexSessionListener;
import flex.messaging.LocalizedException;
import flex.messaging.MessageClient;
import flex.messaging.MessageClientListener;
import flex.messaging.client.FlexClient;
import flex.messaging.client.FlexClientListener;
import flex.messaging.messages.Message;
import flex.messaging.util.TimeoutAbstractObject;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class FlexSession
extends TimeoutAbstractObject
implements FlexClientListener,
MessageClientListener {
    public static final String FLEX_SESSION_LOG_CATEGORY = "Endpoint.FlexSession";
    private static final CopyOnWriteArrayList createdListeners = new CopyOnWriteArrayList();
    private static final int FLEX_SESSION_INVALIDATED = 10019;
    protected final Object lock = new Object();
    private HashMap attributes;
    private volatile CopyOnWriteArrayList attributeListeners;
    private boolean creationNotified;
    private volatile CopyOnWriteArrayList destroyedListeners;
    private final CopyOnWriteArrayList flexClients = new CopyOnWriteArrayList();
    private boolean invalidating;
    private volatile CopyOnWriteArrayList messageClients;
    private volatile Map remoteCredentials;
    protected boolean valid = true;
    public volatile Object asyncPoll;
    private Principal userPrincipal;
    public volatile boolean canStream = true;
    public int maxConnectionsPerSession = 1;
    public int streamingConnectionsCount;
    private boolean useSmallMessages;
    public volatile Object waitMonitor;

    public static void addSessionCreatedListener(FlexSessionListener listener) {
        if (listener != null) {
            createdListeners.addIfAbsent((Object)listener);
        }
    }

    public static void removeSessionCreatedListener(FlexSessionListener listener) {
        if (listener != null) {
            createdListeners.remove((Object)listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Principal getUserPrincipal() {
        Object object = this.lock;
        synchronized (object) {
            this.checkValid();
            return this.userPrincipal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUserPrincipal(Principal userPrincipal) {
        Object object = this.lock;
        synchronized (object) {
            this.checkValid();
            this.userPrincipal = userPrincipal;
        }
    }

    public boolean useSmallMessages() {
        return this.useSmallMessages;
    }

    public void setUseSmallMessages(boolean value) {
        this.useSmallMessages = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSessionAttributeListener(FlexSessionAttributeListener listener) {
        if (listener != null) {
            this.checkValid();
            if (this.attributeListeners == null) {
                Object object = this.lock;
                synchronized (object) {
                    if (this.attributeListeners == null) {
                        this.attributeListeners = new CopyOnWriteArrayList();
                    }
                }
            }
            this.attributeListeners.addIfAbsent((Object)listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSessionDestroyedListener(FlexSessionListener listener) {
        if (listener != null) {
            this.checkValid();
            if (this.destroyedListeners == null) {
                Object object = this.lock;
                synchronized (object) {
                    if (this.destroyedListeners == null) {
                        this.destroyedListeners = new CopyOnWriteArrayList();
                    }
                }
            }
            this.destroyedListeners.addIfAbsent((Object)listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttribute(String name) {
        Object object = this.lock;
        synchronized (object) {
            this.checkValid();
            return this.attributes == null ? null : this.attributes.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getAttributeNames() {
        Object object = this.lock;
        synchronized (object) {
            this.checkValid();
            if (this.attributes == null) {
                return Collections.enumeration(Collections.EMPTY_LIST);
            }
            return Collections.enumeration(new ArrayList(this.attributes.keySet()));
        }
    }

    public void messageClientCreated(MessageClient messageClient) {
    }

    public void messageClientDestroyed(MessageClient messageClient) {
        this.unregisterMessageClient(messageClient);
    }

    public abstract boolean isPushSupported();

    public void push(Message message) {
        throw new UnsupportedOperationException("Push not supported.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAttribute(String name) {
        Object value;
        Object object = this.lock;
        synchronized (object) {
            this.checkValid();
            value = this.attributes != null ? this.attributes.remove(name) : null;
        }
        if (value == null) {
            return;
        }
        this.notifyAttributeUnbound(name, value);
        this.notifyAttributeRemoved(name, value);
    }

    public void removeSessionAttributeListener(FlexSessionAttributeListener listener) {
        if (listener != null && this.attributeListeners != null) {
            this.attributeListeners.remove((Object)listener);
        }
    }

    public void removeSessionDestroyedListener(FlexSessionListener listener) {
        if (listener != null && this.destroyedListeners != null) {
            this.destroyedListeners.remove((Object)listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String name, Object value) {
        Object oldValue;
        if (value == null) {
            this.removeAttribute(name);
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            this.checkValid();
            if (this.attributes == null) {
                this.attributes = new HashMap();
            }
            oldValue = this.attributes.put(name, value);
        }
        if (oldValue == null) {
            this.notifyAttributeBound(name, value);
            this.notifyAttributeAdded(name, value);
        } else {
            this.notifyAttributeUnbound(name, oldValue);
            this.notifyAttributeReplaced(name, oldValue);
            this.notifyAttributeBound(name, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putRemoteCredentials(FlexRemoteCredentials credentials) {
        if (credentials != null) {
            Object object;
            if (this.remoteCredentials == null) {
                object = this.lock;
                synchronized (object) {
                    if (this.remoteCredentials == null) {
                        this.remoteCredentials = new HashMap(4);
                    }
                }
            }
            object = this.remoteCredentials;
            synchronized (object) {
                HashMap<String, FlexRemoteCredentials> serviceMap = (HashMap<String, FlexRemoteCredentials>)this.remoteCredentials.get(credentials.getService());
                if (serviceMap == null) {
                    serviceMap = new HashMap<String, FlexRemoteCredentials>(7);
                    this.remoteCredentials.put(credentials.getService(), serviceMap);
                }
                serviceMap.put(credentials.getDestination(), credentials);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlexRemoteCredentials getRemoteCredentials(String serviceId, String destinationId) {
        if (serviceId != null && destinationId != null) {
            if (this.remoteCredentials == null) {
                return null;
            }
            Map map = this.remoteCredentials;
            synchronized (map) {
                Map serviceMap = (Map)this.remoteCredentials.get(serviceId);
                return serviceMap != null ? (FlexRemoteCredentials)serviceMap.get(destinationId) : null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearRemoteCredentials(String serviceId, String destinationId) {
        if (serviceId != null && destinationId != null) {
            if (this.remoteCredentials == null) {
                return;
            }
            Map map = this.remoteCredentials;
            synchronized (map) {
                Map serviceMap = (Map)this.remoteCredentials.get(serviceId);
                if (serviceMap != null) {
                    serviceMap.put(destinationId, null);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate() {
        Iterator iter;
        Object object = this.lock;
        synchronized (object) {
            if (!this.valid || this.invalidating) {
                return;
            }
            this.invalidating = true;
            this.cancelTimeout();
        }
        if (!this.flexClients.isEmpty()) {
            iter = this.flexClients.iterator();
            while (iter.hasNext()) {
                this.unregisterFlexClient((FlexClient)iter.next());
            }
        }
        if (this.messageClients != null && !this.messageClients.isEmpty()) {
            iter = this.messageClients.iterator();
            while (iter.hasNext()) {
                MessageClient messageClient = (MessageClient)iter.next();
                messageClient.removeMessageClientDestroyedListener(this);
                messageClient.invalidate();
            }
            this.messageClients.clear();
        }
        if (this.destroyedListeners != null && !this.destroyedListeners.isEmpty()) {
            iter = this.destroyedListeners.iterator();
            while (iter.hasNext()) {
                ((FlexSessionListener)iter.next()).sessionDestroyed(this);
            }
            this.destroyedListeners.clear();
        }
        if (this.attributes != null && !this.attributes.isEmpty()) {
            Object[] keys = this.attributes.keySet().toArray();
            for (int i = 0; i < keys.length; ++i) {
                this.removeAttribute((String)keys[i]);
            }
            this.attributes = null;
        }
        this.internalInvalidate();
        object = this.lock;
        synchronized (object) {
            this.valid = false;
            this.invalidating = false;
        }
    }

    protected void internalInvalidate() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getFlexClients() {
        ArrayList currentFlexClients = null;
        Object object = this.lock;
        synchronized (object) {
            this.checkValid();
            currentFlexClients = new ArrayList(this.flexClients);
        }
        return currentFlexClients;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getMessageClients() {
        ArrayList currentMessageClients = null;
        Object object = this.lock;
        synchronized (object) {
            this.checkValid();
            currentMessageClients = this.messageClients != null ? new ArrayList(this.messageClients) : new ArrayList();
        }
        return currentMessageClients;
    }

    public abstract String getId();

    public boolean isUserInRole(String role) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(role);
        return FlexContext.getMessageBroker().getLoginManager().checkRoles(this.userPrincipal, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValid() {
        Object object = this.lock;
        synchronized (object) {
            return this.valid;
        }
    }

    public void clientCreated(FlexClient flexClient) {
    }

    public void clientDestroyed(FlexClient flexClient) {
        this.unregisterFlexClient(flexClient);
    }

    public void registerFlexClient(FlexClient flexClient) {
        if (this.flexClients.addIfAbsent((Object)flexClient)) {
            flexClient.addClientDestroyedListener(this);
            flexClient.registerFlexSession(this);
        }
    }

    public void unregisterFlexClient(FlexClient flexClient) {
        if (this.flexClients.remove((Object)flexClient)) {
            flexClient.removeClientDestroyedListener(this);
            flexClient.unregisterFlexSession(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerMessageClient(MessageClient messageClient) {
        if (this.messageClients == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.messageClients == null) {
                    this.messageClients = new CopyOnWriteArrayList();
                }
            }
        }
        if (this.messageClients.addIfAbsent((Object)messageClient)) {
            messageClient.addMessageClientDestroyedListener(this);
        }
    }

    public void unregisterMessageClient(MessageClient messageClient) {
        if (this.messageClients != null && this.messageClients.remove((Object)messageClient)) {
            messageClient.removeMessageClientDestroyedListener(this);
        }
    }

    public void timeout() {
        this.invalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkValid() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.valid) {
                LocalizedException e = new LocalizedException();
                e.setMessage(10019);
                throw e;
            }
        }
    }

    protected void notifyAttributeAdded(String name, Object value) {
        if (this.attributeListeners != null && !this.attributeListeners.isEmpty()) {
            FlexSessionBindingEvent event = new FlexSessionBindingEvent(this, name, value);
            Iterator iter = this.attributeListeners.iterator();
            while (iter.hasNext()) {
                ((FlexSessionAttributeListener)iter.next()).attributeAdded(event);
            }
        }
    }

    protected void notifyAttributeBound(String name, Object value) {
        if (value != null && value instanceof FlexSessionBindingListener) {
            FlexSessionBindingEvent bindingEvent = new FlexSessionBindingEvent(this, name);
            ((FlexSessionBindingListener)value).valueBound(bindingEvent);
        }
    }

    protected void notifyAttributeRemoved(String name, Object value) {
        if (this.attributeListeners != null && !this.attributeListeners.isEmpty()) {
            FlexSessionBindingEvent event = new FlexSessionBindingEvent(this, name, value);
            Iterator iter = this.attributeListeners.iterator();
            while (iter.hasNext()) {
                ((FlexSessionAttributeListener)iter.next()).attributeRemoved(event);
            }
        }
    }

    protected void notifyAttributeReplaced(String name, Object value) {
        if (this.attributeListeners != null && !this.attributeListeners.isEmpty()) {
            FlexSessionBindingEvent event = new FlexSessionBindingEvent(this, name, value);
            Iterator iter = this.attributeListeners.iterator();
            while (iter.hasNext()) {
                ((FlexSessionAttributeListener)iter.next()).attributeReplaced(event);
            }
        }
    }

    protected void notifyAttributeUnbound(String name, Object value) {
        if (value != null && value instanceof FlexSessionBindingListener) {
            FlexSessionBindingEvent bindingEvent = new FlexSessionBindingEvent(this, name);
            ((FlexSessionBindingListener)value).valueUnbound(bindingEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyCreated() {
        Object object = this.lock;
        synchronized (object) {
            if (this.creationNotified) {
                return;
            }
            this.creationNotified = true;
        }
        if (!createdListeners.isEmpty()) {
            Iterator iter = createdListeners.iterator();
            while (iter.hasNext()) {
                ((FlexSessionListener)iter.next()).sessionCreated(this);
            }
        }
    }
}

