/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.Dimension;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.SVGGElementBridge;
import org.apache.batik.bridge.SVGTextElementBridge;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.bridge.UnitProcessor;
import org.apache.batik.bridge.ViewBox;
import org.apache.batik.bridge.Viewport;
import org.apache.batik.dom.svg.SVGContext;
import org.apache.batik.dom.svg.SVGOMElement;
import org.apache.batik.dom.svg.SVGSVGContext;
import org.apache.batik.ext.awt.image.renderable.ClipRable;
import org.apache.batik.ext.awt.image.renderable.ClipRable8Bit;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.gvt.CanvasGraphicsNode;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.ShapeNode;
import org.apache.batik.gvt.TextNode;
import org.apache.batik.gvt.text.GVTAttributedCharacterIterator;
import org.apache.batik.parser.UnitProcessor;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.MutationEvent;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGRect;

public class SVGSVGElementBridge
extends SVGGElementBridge
implements SVGSVGContext {
    public static final AttributedCharacterIterator.Attribute TEXT_COMPOUND_DELIMITER = GVTAttributedCharacterIterator.TextAttribute.TEXT_COMPOUND_DELIMITER;

    public String getLocalName() {
        return "svg";
    }

    public Bridge getInstance() {
        return new SVGSVGElementBridge();
    }

    protected GraphicsNode instantiateGraphicsNode() {
        return new CanvasGraphicsNode();
    }

    public GraphicsNode createGraphicsNode(BridgeContext ctx, Element e) {
        Rectangle2D r;
        String s;
        if (!SVGUtilities.matchUserAgent(e, ctx.getUserAgent())) {
            return null;
        }
        CanvasGraphicsNode cgn = (CanvasGraphicsNode)this.instantiateGraphicsNode();
        UnitProcessor.Context uctx = UnitProcessor.createContext(ctx, e);
        SVGDocument doc = (SVGDocument)e.getOwnerDocument();
        boolean isOutermost = doc.getRootElement() == e;
        float x = 0.0f;
        float y = 0.0f;
        if (!isOutermost) {
            s = e.getAttributeNS(null, "x");
            if (s.length() != 0) {
                x = UnitProcessor.svgHorizontalCoordinateToUserSpace(s, "x", uctx);
            }
            if ((s = e.getAttributeNS(null, "y")).length() != 0) {
                y = UnitProcessor.svgVerticalCoordinateToUserSpace(s, "y", uctx);
            }
        }
        if ((s = e.getAttributeNS(null, "width")).length() == 0) {
            s = "100%";
        }
        float w = UnitProcessor.svgHorizontalLengthToUserSpace(s, "width", uctx);
        s = e.getAttributeNS(null, "height");
        if (s.length() == 0) {
            s = "100%";
        }
        float h = UnitProcessor.svgVerticalLengthToUserSpace(s, "height", uctx);
        cgn.setVisible(CSSUtilities.convertVisibility(e));
        AffineTransform viewingTransform = ViewBox.getPreserveAspectRatioTransform(e, w, h);
        float actualWidth = w;
        float actualHeight = h;
        try {
            AffineTransform vtInv = viewingTransform.createInverse();
            actualWidth = (float)((double)w * vtInv.getScaleX());
            actualHeight = (float)((double)h * vtInv.getScaleY());
        }
        catch (NoninvertibleTransformException ex) {
            // empty catch block
        }
        AffineTransform positionTransform = AffineTransform.getTranslateInstance(x, y);
        if (!isOutermost) {
            cgn.setPositionTransform(positionTransform);
        } else if (doc == ctx.getDocument()) {
            ctx.setDocumentSize(new Dimension((int)(w + 0.5f), (int)(h + 0.5f)));
        }
        cgn.setViewingTransform(viewingTransform);
        Shape clip = null;
        if (CSSUtilities.convertOverflow(e)) {
            float[] offsets = CSSUtilities.convertClip(e);
            clip = offsets == null ? new Rectangle2D.Float(x, y, w, h) : new Rectangle2D.Float(x + offsets[3], y + offsets[0], w - offsets[1] - offsets[3], h - offsets[2] - offsets[0]);
        }
        if (clip != null) {
            try {
                AffineTransform at = new AffineTransform(positionTransform);
                at.concatenate(viewingTransform);
                at = at.createInverse();
                clip = at.createTransformedShape(clip);
                Filter filter = cgn.getGraphicsNodeRable(true);
                cgn.setClip((ClipRable)new ClipRable8Bit(filter, clip));
            }
            catch (NoninvertibleTransformException ex) {
                // empty catch block
            }
        }
        RenderingHints hints = null;
        if ((hints = CSSUtilities.convertColorRendering(e, hints)) != null) {
            cgn.setRenderingHints(hints);
        }
        if ((r = CSSUtilities.convertEnableBackground(e)) != null) {
            cgn.setBackgroundEnable(r);
        }
        ctx.openViewport(e, new SVGSVGElementViewport(actualWidth, actualHeight));
        return cgn;
    }

    public void buildGraphicsNode(BridgeContext ctx, Element e, GraphicsNode node) {
        node.setComposite(CSSUtilities.convertOpacity(e));
        node.setFilter(CSSUtilities.convertFilter(e, node, ctx));
        node.setMask(CSSUtilities.convertMask(e, node, ctx));
        node.setPointerEventType(CSSUtilities.convertPointerEvents(e));
        this.initializeDynamicSupport(ctx, e, node);
        ctx.closeViewport(e);
    }

    public void dispose() {
        this.ctx.removeViewport(this.e);
        super.dispose();
    }

    public void handleDOMAttrModifiedEvent(MutationEvent evt) {
        SVGDocument doc;
        String attrName = evt.getAttrName();
        boolean rebuild = false;
        if (attrName.equals("width") || attrName.equals("height")) {
            rebuild = true;
        } else if (attrName.equals("x") || attrName.equals("y")) {
            boolean isOutermost;
            doc = (SVGDocument)this.e.getOwnerDocument();
            boolean bl = isOutermost = doc.getRootElement() == this.e;
            if (!isOutermost) {
                float x = 0.0f;
                float y = 0.0f;
                UnitProcessor.Context uctx = UnitProcessor.createContext(this.ctx, this.e);
                String s = this.e.getAttributeNS(null, "x");
                if (s.length() != 0) {
                    x = UnitProcessor.svgHorizontalCoordinateToUserSpace(s, "x", uctx);
                }
                if ((s = this.e.getAttributeNS(null, "y")).length() != 0) {
                    y = UnitProcessor.svgVerticalCoordinateToUserSpace(s, "y", uctx);
                }
                AffineTransform positionTransform = AffineTransform.getTranslateInstance(x, y);
                CanvasGraphicsNode cgn = (CanvasGraphicsNode)this.node;
                cgn.setPositionTransform(positionTransform);
            }
        } else if (attrName.equals("viewBox") || attrName.equals("preserveAspectRatio")) {
            String s;
            doc = (SVGDocument)this.e.getOwnerDocument();
            boolean isOutermost = doc.getRootElement() == this.e;
            UnitProcessor.Context uctx = UnitProcessor.createContext(this.ctx, this.e);
            float x = 0.0f;
            float y = 0.0f;
            if (!isOutermost) {
                s = this.e.getAttributeNS(null, "x");
                if (s.length() != 0) {
                    x = UnitProcessor.svgHorizontalCoordinateToUserSpace(s, "x", uctx);
                }
                if ((s = this.e.getAttributeNS(null, "y")).length() != 0) {
                    y = UnitProcessor.svgVerticalCoordinateToUserSpace(s, "y", uctx);
                }
            }
            if ((s = this.e.getAttributeNS(null, "width")).length() == 0) {
                s = "100%";
            }
            float w = UnitProcessor.svgHorizontalLengthToUserSpace(s, "width", uctx);
            s = this.e.getAttributeNS(null, "height");
            if (s.length() == 0) {
                s = "100%";
            }
            float h = UnitProcessor.svgVerticalLengthToUserSpace(s, "height", uctx);
            CanvasGraphicsNode cgn = (CanvasGraphicsNode)this.node;
            AffineTransform newVT = ViewBox.getPreserveAspectRatioTransform(this.e, w, h);
            AffineTransform oldVT = cgn.getViewingTransform();
            if (newVT.getScaleX() != oldVT.getScaleX() || newVT.getScaleY() != oldVT.getScaleY() || newVT.getShearX() != oldVT.getShearX() || newVT.getShearY() != oldVT.getShearY()) {
                rebuild = true;
            } else {
                cgn.setViewingTransform(newVT);
                Shape clip = null;
                if (CSSUtilities.convertOverflow(this.e)) {
                    float[] offsets = CSSUtilities.convertClip(this.e);
                    clip = offsets == null ? new Rectangle2D.Float(x, y, w, h) : new Rectangle2D.Float(x + offsets[3], y + offsets[0], w - offsets[1] - offsets[3], h - offsets[2] - offsets[0]);
                }
                if (clip != null) {
                    try {
                        AffineTransform at = cgn.getPositionTransform();
                        at = new AffineTransform(at);
                        at.concatenate(newVT);
                        at = at.createInverse();
                        clip = at.createTransformedShape(clip);
                        Filter filter = cgn.getGraphicsNodeRable(true);
                        cgn.setClip((ClipRable)new ClipRable8Bit(filter, clip));
                    }
                    catch (NoninvertibleTransformException ex) {
                        // empty catch block
                    }
                }
            }
        }
        if (rebuild) {
            CompositeGraphicsNode gn = this.node.getParent();
            gn.remove((Object)this.node);
            SVGSVGElementBridge.disposeTree(this.e);
            this.handleElementAdded(gn, this.e.getParentNode(), this.e);
        }
    }

    public List getIntersectionList(SVGRect svgRect, Element end) {
        Node next;
        ArrayList<Element> ret = new ArrayList<Element>();
        Rectangle2D.Float rect = new Rectangle2D.Float(svgRect.getX(), svgRect.getY(), svgRect.getWidth(), svgRect.getHeight());
        GraphicsNode svgGN = this.ctx.getGraphicsNode(this.e);
        if (svgGN == null) {
            return ret;
        }
        Rectangle2D svgBounds = svgGN.getSensitiveBounds();
        if (svgBounds == null) {
            return ret;
        }
        if (!rect.intersects(svgBounds)) {
            return ret;
        }
        Element base = this.e;
        AffineTransform ati = svgGN.getGlobalTransform();
        try {
            ati = ati.createInverse();
        }
        catch (NoninvertibleTransformException e) {
            // empty catch block
        }
        for (next = base.getFirstChild(); next != null && !(next instanceof Element); next = next.getNextSibling()) {
        }
        if (next == null) {
            return ret;
        }
        Element curr = (Element)next;
        Set ancestors = null;
        if (end != null && (ancestors = this.getAncestors(end, base)) == null) {
            end = null;
        }
        while (curr != null) {
            String nsURI = curr.getNamespaceURI();
            String tag = curr.getLocalName();
            boolean isGroup = "http://www.w3.org/2000/svg".equals(nsURI) && ("g".equals(tag) || "svg".equals(tag) || "a".equals(tag));
            GraphicsNode gn = this.ctx.getGraphicsNode(curr);
            if (gn == null) {
                if (ancestors != null && ancestors.contains(curr)) break;
                curr = this.getNext(curr, base, end);
                continue;
            }
            AffineTransform at = gn.getGlobalTransform();
            Rectangle2D gnBounds = gn.getSensitiveBounds();
            at.preConcatenate(ati);
            if (gnBounds != null) {
                gnBounds = at.createTransformedShape(gnBounds).getBounds2D();
            }
            if (gnBounds == null || !rect.intersects(gnBounds)) {
                if (ancestors != null && ancestors.contains(curr)) break;
                curr = this.getNext(curr, base, end);
                continue;
            }
            if (isGroup) {
                for (next = curr.getFirstChild(); next != null && !(next instanceof Element); next = next.getNextSibling()) {
                }
                if (next != null) {
                    curr = (Element)next;
                    continue;
                }
            } else {
                if (curr == end) break;
                if ("http://www.w3.org/2000/svg".equals(nsURI) && "use".equals(tag) && rect.contains(gnBounds)) {
                    ret.add(curr);
                }
                if (gn instanceof ShapeNode) {
                    ShapeNode sn = (ShapeNode)gn;
                    Shape sensitive = sn.getSensitiveArea();
                    if (sensitive != null && (sensitive = at.createTransformedShape(sensitive)).intersects(rect)) {
                        ret.add(curr);
                    }
                } else if (gn instanceof TextNode) {
                    SVGOMElement svgElem = (SVGOMElement)curr;
                    SVGTextElementBridge txtBridge = (SVGTextElementBridge)svgElem.getSVGContext();
                    Set elems = txtBridge.getTextIntersectionSet(at, rect);
                    if (ancestors != null && ancestors.contains(curr)) {
                        this.filterChildren(curr, end, elems, ret);
                    } else {
                        ret.addAll(elems);
                    }
                } else {
                    ret.add(curr);
                }
            }
            curr = this.getNext(curr, base, end);
        }
        return ret;
    }

    public List getEnclosureList(SVGRect svgRect, Element end) {
        Node next;
        ArrayList<Element> ret = new ArrayList<Element>();
        Rectangle2D.Float rect = new Rectangle2D.Float(svgRect.getX(), svgRect.getY(), svgRect.getWidth(), svgRect.getHeight());
        GraphicsNode svgGN = this.ctx.getGraphicsNode(this.e);
        if (svgGN == null) {
            return ret;
        }
        Rectangle2D svgBounds = svgGN.getSensitiveBounds();
        if (svgBounds == null) {
            return ret;
        }
        if (!rect.intersects(svgBounds)) {
            return ret;
        }
        Element base = this.e;
        AffineTransform ati = svgGN.getGlobalTransform();
        try {
            ati = ati.createInverse();
        }
        catch (NoninvertibleTransformException e) {
            // empty catch block
        }
        for (next = base.getFirstChild(); next != null && !(next instanceof Element); next = next.getNextSibling()) {
        }
        if (next == null) {
            return ret;
        }
        Element curr = (Element)next;
        Set ancestors = null;
        if (end != null && (ancestors = this.getAncestors(end, base)) == null) {
            end = null;
        }
        while (curr != null) {
            String nsURI = curr.getNamespaceURI();
            String tag = curr.getLocalName();
            boolean isGroup = "http://www.w3.org/2000/svg".equals(nsURI) && ("g".equals(tag) || "svg".equals(tag) || "a".equals(tag));
            GraphicsNode gn = this.ctx.getGraphicsNode(curr);
            if (gn == null) {
                if (ancestors != null && ancestors.contains(curr)) break;
                curr = this.getNext(curr, base, end);
                continue;
            }
            AffineTransform at = gn.getGlobalTransform();
            Rectangle2D gnBounds = gn.getSensitiveBounds();
            at.preConcatenate(ati);
            if (gnBounds != null) {
                gnBounds = at.createTransformedShape(gnBounds).getBounds2D();
            }
            if (gnBounds == null || !rect.intersects(gnBounds)) {
                if (ancestors != null && ancestors.contains(curr)) break;
                curr = this.getNext(curr, base, end);
                continue;
            }
            if (isGroup) {
                for (next = curr.getFirstChild(); next != null && !(next instanceof Element); next = next.getNextSibling()) {
                }
                if (next != null) {
                    curr = (Element)next;
                    continue;
                }
            } else {
                if (curr == end) break;
                if ("http://www.w3.org/2000/svg".equals(nsURI) && "use".equals(tag)) {
                    if (rect.contains(gnBounds)) {
                        ret.add(curr);
                    }
                } else if (gn instanceof TextNode) {
                    SVGOMElement svgElem = (SVGOMElement)curr;
                    SVGTextElementBridge txtBridge = (SVGTextElementBridge)svgElem.getSVGContext();
                    Set elems = txtBridge.getTextEnclosureSet(at, rect);
                    if (ancestors != null && ancestors.contains(curr)) {
                        this.filterChildren(curr, end, elems, ret);
                    } else {
                        ret.addAll(elems);
                    }
                } else if (rect.contains(gnBounds)) {
                    ret.add(curr);
                }
            }
            curr = this.getNext(curr, base, end);
        }
        return ret;
    }

    public boolean checkIntersection(Element element, SVGRect svgRect) {
        GraphicsNode svgGN = this.ctx.getGraphicsNode(this.e);
        if (svgGN == null) {
            return false;
        }
        Rectangle2D.Float rect = new Rectangle2D.Float(svgRect.getX(), svgRect.getY(), svgRect.getWidth(), svgRect.getHeight());
        AffineTransform ati = svgGN.getGlobalTransform();
        try {
            ati = ati.createInverse();
        }
        catch (NoninvertibleTransformException e) {
            // empty catch block
        }
        SVGContext svgctx = null;
        if (element instanceof SVGOMElement && ((svgctx = ((SVGOMElement)element).getSVGContext()) instanceof SVGTextElementBridge || svgctx instanceof SVGTextElementBridge.AbstractTextChildSVGContext)) {
            return SVGTextElementBridge.getTextIntersection(this.ctx, element, ati, rect, true);
        }
        Rectangle2D gnBounds = null;
        GraphicsNode gn = this.ctx.getGraphicsNode(element);
        if (gn != null) {
            gnBounds = gn.getSensitiveBounds();
        }
        if (gnBounds == null) {
            return false;
        }
        AffineTransform at = gn.getGlobalTransform();
        at.preConcatenate(ati);
        gnBounds = at.createTransformedShape(gnBounds).getBounds2D();
        if (!rect.intersects(gnBounds)) {
            return false;
        }
        if (!(gn instanceof ShapeNode)) {
            return true;
        }
        ShapeNode sn = (ShapeNode)gn;
        Shape sensitive = sn.getSensitiveArea();
        if (sensitive == null) {
            return false;
        }
        return (sensitive = at.createTransformedShape(sensitive)).intersects(rect);
    }

    public boolean checkEnclosure(Element element, SVGRect svgRect) {
        GraphicsNode gn = this.ctx.getGraphicsNode(element);
        Rectangle2D gnBounds = null;
        SVGContext svgctx = null;
        if (element instanceof SVGOMElement) {
            svgctx = ((SVGOMElement)element).getSVGContext();
            if (svgctx instanceof SVGTextElementBridge || svgctx instanceof SVGTextElementBridge.AbstractTextChildSVGContext) {
                gnBounds = SVGTextElementBridge.getTextBounds(this.ctx, element, true);
                for (Element p = (Element)element.getParentNode(); p != null && gn == null; p = (Element)p.getParentNode()) {
                    gn = this.ctx.getGraphicsNode(p);
                }
            } else if (gn != null) {
                gnBounds = gn.getSensitiveBounds();
            }
        } else if (gn != null) {
            gnBounds = gn.getSensitiveBounds();
        }
        if (gnBounds == null) {
            return false;
        }
        GraphicsNode svgGN = this.ctx.getGraphicsNode(this.e);
        if (svgGN == null) {
            return false;
        }
        Rectangle2D.Float rect = new Rectangle2D.Float(svgRect.getX(), svgRect.getY(), svgRect.getWidth(), svgRect.getHeight());
        AffineTransform ati = svgGN.getGlobalTransform();
        try {
            ati = ati.createInverse();
        }
        catch (NoninvertibleTransformException e) {
            // empty catch block
        }
        AffineTransform at = gn.getGlobalTransform();
        at.preConcatenate(ati);
        gnBounds = at.createTransformedShape(gnBounds).getBounds2D();
        return rect.contains(gnBounds);
    }

    public boolean filterChildren(Element curr, Element end, Set elems, List ret) {
        for (Node child = curr.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof Element) || !this.filterChildren((Element)child, end, elems, ret)) continue;
            return true;
        }
        if (curr == end) {
            return true;
        }
        if (elems.contains(curr)) {
            ret.add(curr);
        }
        return false;
    }

    protected Set getAncestors(Element end, Element base) {
        HashSet<Element> ret = new HashSet<Element>();
        Element p = end;
        do {
            ret.add(p);
        } while ((p = (Element)p.getParentNode()) != null && p != base);
        if (p == null) {
            return null;
        }
        return ret;
    }

    protected Element getNext(Element curr, Element base, Element end) {
        Node next;
        for (next = curr.getNextSibling(); next != null && !(next instanceof Element); next = next.getNextSibling()) {
        }
        while (next == null) {
            if ((curr = (Element)curr.getParentNode()) == end || curr == base) {
                next = null;
                break;
            }
            for (next = curr.getNextSibling(); next != null && !(next instanceof Element); next = next.getNextSibling()) {
            }
        }
        return (Element)next;
    }

    public void deselectAll() {
        this.ctx.getUserAgent().deselectAll();
    }

    public static class SVGSVGElementViewport
    implements Viewport {
        private float width;
        private float height;

        public SVGSVGElementViewport(float w, float h) {
            this.width = w;
            this.height = h;
        }

        public float getWidth() {
            return this.width;
        }

        public float getHeight() {
            return this.height;
        }
    }
}

