/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.swc;

import flex2.compiler.swc.SwcDependencySet;
import flex2.compiler.swc.SwcScript;
import flex2.tools.oem.Script;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.TreeSet;

class ScriptImpl
implements Script {
    private String location;
    private long lastModified;
    private String[] definitions;
    private String[] prerequisites;
    private String[] signatures;
    private String[] namespaces;
    private String[] expressions;
    private byte[] bytecodes;

    ScriptImpl(SwcScript swcScript, boolean includeBytecodes) {
        this.location = swcScript.getSwcLocation();
        this.lastModified = swcScript.getLastModified();
        AbstractSet names = new LinkedHashSet();
        Iterator i = swcScript.getDefinitionIterator();
        while (i.hasNext()) {
            names.add(i.next());
        }
        this.definitions = new String[names.size()];
        names.toArray(this.definitions);
        SwcDependencySet set = swcScript.getDependencySet();
        names = new TreeSet();
        Iterator i2 = set.getDependencyIterator("i");
        while (i2 != null && i2.hasNext()) {
            names.add((String)i2.next());
        }
        this.prerequisites = new String[names.size()];
        names.toArray(this.prerequisites);
        names.clear();
        i2 = set.getDependencyIterator("s");
        while (i2 != null && i2.hasNext()) {
            names.add((String)i2.next());
        }
        this.signatures = new String[names.size()];
        names.toArray(this.signatures);
        names.clear();
        i2 = set.getDependencyIterator("n");
        while (i2 != null && i2.hasNext()) {
            names.add((String)i2.next());
        }
        this.namespaces = new String[names.size()];
        names.toArray(this.namespaces);
        names.clear();
        i2 = set.getDependencyIterator("e");
        while (i2 != null && i2.hasNext()) {
            names.add((String)i2.next());
        }
        i2 = swcScript.getSymbolClasses().iterator();
        while (i2.hasNext()) {
            names.add((String)i2.next());
        }
        this.expressions = new String[names.size()];
        names.toArray(this.expressions);
        if (includeBytecodes) {
            this.bytecodes = swcScript.getDoABC().abc;
        }
    }

    public String[] getDefinitionNames() {
        return this.definitions;
    }

    public String[] getDependencies(Object type) {
        if (type == INHERITANCE) {
            return this.prerequisites;
        }
        if (type == SIGNATURE) {
            return this.signatures;
        }
        if (type == NAMESPACE) {
            return this.namespaces;
        }
        if (type == EXPRESSION) {
            return this.expressions;
        }
        return null;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public String getLocation() {
        return this.location;
    }

    public String[] getPrerequisites() {
        return this.prerequisites;
    }

    public byte[] getBytecodes() {
        return this.bytecodes;
    }
}

