/*
 * Programming Language SOOPY
 *   (Simple Object Oriented Programming sYstem)
 *
 * Copyright (C) 2002 SUZUKI Jun
 *
 * URL: http://sourceforge.jp/projects/soopy/
 * License: GPL(GNU General Public License)
 *
 *
 * $Id: Panel.mm,v 1.8 2004/05/10 12:52:12 randy Exp $
 */

#include "soopyg.h"

/*
 * class SpNSPanel
 */
@implementation SpNSPanel

-(id)contentView
{
  return self;
}

-(void)drawRect:(NSRect)rect
{
  [[NSColor blackColor] set];
  [NSBezierPath strokeRect: rect];
}

-(id)initWithNameSpace:(SpNameSpace*)assoc parent:(NSObject*)parent comp:(SpComponent*)spc
{
    ns = assoc;
    spcomp = spc;
    // set window origin & size
    SpValue vtop = assoc->lookup(SymTop);
    SpValue vleft = assoc->lookup(SymLeft);
    SpValue vwidth = assoc->lookup(SymWidth);
    SpValue vheight = assoc->lookup(SymHeight);

    NSRect rect = [(NSView*)[parent contentView] frame];
    float left = (float)vleft.getInt();
    float width = (float)vwidth.getInt();
    float height = (float)vheight.getInt();
    float top = rect.size.height - (float)vtop.getInt() - height;
    [self initWithFrame: NSMakeRect(left, top, width, height)];

    return self;
}

-(SpNameSpace*)getNameSpace
{
  return ns;
}

-(SpComponent*)getSpComponent
{
  return spcomp;
}

-(void)mouseUp:(NSEvent*)event
{
    if([event clickCount] == 1){
      SpValue onClick  = ns->lookup(SymOnClick);
      if(onClick.isFunc()){
        SpFunc* f = onClick.asFunc();
        (*f)(NilObject);
      }
    }else if([event clickCount] == 2){ // Double click
      SpValue onDblClick  = ns->lookup(SymOnDblClick);
      if(onDblClick.isFunc()){
        SpFunc* f = onDblClick.asFunc();
        (*f)(NilObject);
      }
    }
}

@end

/*
 * class SpPanel
 */

SpValue& SpPanel::make()
{
    SpPanel* panel = new SpPanel(getCurrentNS());
//    static SpValue result;
//    result.setNewObject(panel);
//    return result;
    return SpObjectResult(panel);
}

void SpPanel::resetAlign(NSRect& parent_rect)
{
  SpComponent::resetAlign(parent_rect);
  SpContainer::resetAlignAllComponents();
}

// Caption
SpValue& SpPanel::getCaption(NSObject* w)
{
//    static SpValue result;
//    result.setNewObject(new SpString([[w title] cString]));
//    return result;
    return SpObjectResult(new SpString([[w title] cString]));
}

void SpPanel::setCaption(NSObject* w, const char* str)
{
    [w setTitle: [NSString stringWithCString: str]];
}

void SpPanel::creation(SpValue& parentNS, NSObject* p)
{
    parentNameSpace = parentNS;
    parent = p;
    SpNameSpace* assoc = ns.asNameSpace();
    SpNSPanel* panel = [[SpNSPanel alloc] initWithNameSpace:assoc parent:parent comp:this];
    widget = (NSObject*)panel;
    [[parent contentView] addSubview: (NSView*)panel];
    [panel setAutoresizesSubviews:YES];
    [panel setAutoresizingMask: NSViewMinYMargin];

    // set self
    SpValue self(this);
    assoc->internConst(SymSelf, self);

    // set align
    SpValue valign  = assoc->lookup(SymAlign);
    setAlign(valign.asInt());

    initProperties(assoc); // SpComponent::initProperties

    // create components
    SpValue vcomps = assoc->lookup(SymComponents);
    create_components(widget, ns, vcomps);
}

void SpPanel::init()
{
    // set namespace to symbol 'std_panel'.
    PPanelNameSpace = new SpNameSpace(PComponentNameSpace->getMap());
    PanelNS.setNewObject(PPanelNameSpace);
    SpValue SymStdPanel(new SpSymbol("std_panel"));
    PMainNameSpace->internConst(SymStdPanel, PanelNS);

    // set default top, left, width, height
    DefaultTop.setInt(0);
    PPanelNameSpace->internConst(SymTop, DefaultTop);
    DefaultLeft.setInt(0);
    PPanelNameSpace->internConst(SymLeft, DefaultLeft);
    DefaultWidth.setInt(200);
    PPanelNameSpace->internConst(SymWidth, DefaultWidth);
    DefaultHeight.setInt(80);
    PPanelNameSpace->internConst(SymHeight, DefaultHeight);

    SpValue PrimMake(new SpPrim0(make));
    PPanelNameSpace->internFunc(SymMake, PrimMake);
}

