/*
 * Programming Language SOOPY
 *   (Simple Object Oriented Programming sYstem)
 *
 * Copyright (C) 2002 SUZUKI Jun
 *
 * URL: http://sourceforge.jp/projects/soopy/
 * License: GPL(GNU General Public License)
 *
 *
 * $Id: Check.mm,v 1.3 2004/05/10 12:52:12 randy Exp $
 */

#include "soopyg.h"

/*
 * class SpCheckBox
 */

SpValue& SpCheckBox::primGetCheck()
{
    SpValue n = getCurrentNS();
    SpNameSpace* ns = n.asNameSpace();
    SpValue self = ns->lookup(SymSelf);
    SpComponent* comp = self.asComponent();
//    static SpValue result;
    SpValue result;
    bool p = false;
    if([(NSButton*)comp->widget state] == NSOnState){
      p = true;
    }
    result.setBool(p);
//    return result;
    return SpValueResult(result);
}

SpValue& SpCheckBox::primSetCheck(SpValue& v)
{
    if(v.isBool()){
        SpValue n = getCurrentNS();
        SpNameSpace* ns = n.asNameSpace();
        SpValue self = ns->lookup(SymSelf);
        SpComponent* comp = self.asComponent();
	if(v.getBool()){
            [(NSButton*)comp->widget setState:NSOnState];
	}else{
            [(NSButton*)comp->widget setState:NSOffState];
	}
    }
    return TrueObject;
}

SpValue& SpCheckBox::make()
{
    SpCheckBox* checkbox = new SpCheckBox(getCurrentNS());
//    static SpValue result;
//    result.setNewObject(checkbox);
//    return result;
    return SpObjectResult(checkbox);
}

void SpCheckBox::creation(SpValue& parentNS, NSObject* p)
{
    SpButton::creation(parentNS, p);
    [(NSButton*)widget setButtonType:NSSwitchButton];
    // set checked
    SpNameSpace* assoc = ns.asNameSpace();
    SpValue vchecked  = assoc->lookup(SymCheckedP);
    if(vchecked.isTrue()){
	[(NSButton*)widget setState:NSOnState];
    }
    [(NSButton*)widget setState:NSOffState];
}

// init
static SpValue GetCheck;
static SpValue SetCheck;

void SpCheckBox::initProperties(SpNameSpace* pNS)
{
    SpComponent::initProperties(pNS);

    // Checked
    pNS->internPrimProperty(SymCheckedP, NilObject, GetCheck, SetCheck);
}

void SpCheckBox::init()
{
    // set namespace to symbol 'std_checkbox'.
    PCheckBoxNameSpace = new SpNameSpace(PComponentNameSpace->getMap());
    CheckBoxNS.setNewObject(PCheckBoxNameSpace);
    SpValue SymStdCheckBox(new SpSymbol("std_checkbox"));
    PMainNameSpace->internConst(SymStdCheckBox, CheckBoxNS);

    GetCheck.setNewObject(new SpPrim0(primGetCheck));
    SetCheck.setNewObject(new SpPrim1(primSetCheck));

    SpValue PrimMake(new SpPrim0(make));
    PCheckBoxNameSpace->internFunc(SymMake, PrimMake);
}

