/*
 * Programming Language SOOPY
 *   (Simple Object Oriented Programming sYstem)
 *
 * Copyright (C) 2002 SUZUKI Jun
 *
 * URL: http://sourceforge.jp/projects/soopy/
 * License: GPL(GNU General Public License)
 *
 *
 * $Id: Button.mm,v 1.9 2004/05/10 12:52:12 randy Exp $
 */

#include "soopyg.h"

/*
 * class SpNSButton
 */
@implementation SpNSButton

//-(id)initWithNameSpace:(SpNameSpace*)assoc parent: parent
-(id)initWithNameSpace:(SpNameSpace*)assoc parent:(NSObject*)parent comp:(SpComponent*)spc
{
    ns = assoc;
    spcomp = spc;
    // set window origin & size
    SpValue vtop = assoc->lookup(SymTop);
    SpValue vleft = assoc->lookup(SymLeft);
    SpValue vwidth = assoc->lookup(SymWidth);
    SpValue vheight = assoc->lookup(SymHeight);

    NSRect rect = [(NSView*)[parent contentView] frame];
    float left = (float)vleft.getInt();
    float width = (float)vwidth.getInt();
    float height = (float)vheight.getInt();
    float top = rect.size.height - (float)vtop.getInt() - height;
    [self initWithFrame: NSMakeRect(left, top, width, height)];

    return self;
}

-(void)click:(NSObject*)sender
{
  //    [(objc_super*)super click:sender];
    SpValue onClick  = ns->lookup(SymOnClick);
    if(onClick.isFunc()){
        SpFunc* f = onClick.asFunc();
        (*f)(NilObject);
    }
}

-(SpNameSpace*)getNameSpace
{
  return ns;
}

-(SpComponent*)getSpComponent
{
  return spcomp;
}

@end

/*
 * class SpButton
 */

SpValue& SpButton::make()
{
    SpButton* button = new SpButton(getCurrentNS());
//    static SpValue result;
//    result.setNewObject(button);
//    return result;
    return SpObjectResult(button);
}

// Caption
SpValue& SpButton::getCaption(NSObject* w)
{
//    static SpValue result;
//    result.setNewObject(new SpString([[w title] cString]));
//    return result;
    return SpObjectResult(new SpString([[w title] cString]));
}

void SpButton::setCaption(NSObject* w, const char* str)
{
    [w setTitle: [NSString stringWithCString: str]];
}

void SpButton::creation(SpValue& parentNS, NSObject* p)
{
    parentNameSpace = parentNS;
    parent = p;
    SpNameSpace* assoc = ns.asNameSpace();
    SpNSButton* button = [[SpNSButton alloc] initWithNameSpace:assoc parent:parent comp:this];
    widget = (NSObject*)button;
    [[parent contentView] addSubview: (NSView*)button];
    [button setAutoresizesSubviews:NO];
    [button setAutoresizingMask: NSViewMinYMargin];
    [button setTarget: (id)button];
    [button setAction:@selector(click:)];

    // set title
    SpValue vcaption = assoc->lookup(SymCaption);
    if(vcaption.isString()){
      [widget setTitle: [NSString stringWithCString: vcaption.toCString()]];
    }else{
      [widget setTitle: [NSString stringWithCString: typeString()]];
    }

    // set self
    SpValue self(this);
    assoc->internConst(SymSelf, self);

    // set align
    SpValue valign  = assoc->lookup(SymAlign);
    setAlign(valign.asInt());

    initProperties(assoc); // SpComponent::initProperties
}

void SpButton::init()
{
    // set namespace to symbol 'std_button'.
    PButtonNameSpace = new SpNameSpace(PComponentNameSpace->getMap());
    ButtonNS.setNewObject(PButtonNameSpace);
    SpValue SymStdButton(new SpSymbol("std_button"));
    PMainNameSpace->internConst(SymStdButton, ButtonNS);

    SpValue PrimMake(new SpPrim0(make));
    PButtonNameSpace->internFunc(SymMake, PrimMake);
}

