CC=g++
#CC=bc++
DEBUG=
DEBUG= -g
#COPT= $(DEBUG) -c -DUSE_BISON -DNO_FINALLY
COPT=  -ftemplate-depth-50 $(DEBUG) -c -DEUC_JP -DLINUX -DUSE_SOCKET -DNO_READSOME -DUSE_PTHREAD
LINKOPT= $(DEBUG) -lpthread
YTAB_C=ytab.cpp
YTAB_OBJ=ytab.o
#YACC=bison -o $(YTAB_C)
YACC=kmyacc
INSTALL_DIR=/usr/local/bin

OBJ= Object.o Char.o String.o Tuple.o List.o \
     NameSpace.o Symbol.o SjisRW.o Assign.o SendMsg.o \
     Nil.o Bool.o Int.o Real.o Handler.o Prim.o Closure.o \
     Expr.o Func.o Load.o $(YTAB_OBJ) Lexer.o \
     If.o Loop.o Array.o Datatype.o Except.o RW.o \
     EucJPRW.o Dir.o Byte.o Word.o RAW.o CR_LF.o Socket.o \
     Base64.o File.o URLEncode.o ISO2022JP.o Japanese.o \
     Date.o Time.o DateTime.o Thread.o Mutex.o


SUFFIXES= .cpp .o

.cpp.o:
	$(CC) $(COPT) $<

all: fib

install: all
	cp -f soopy $(INSTALL_DIR)

clean:
	rm -f *.o $(YTAB_C) ytab.h

Object.o: Object.cpp soopy.h
Char.o: Char.cpp soopy.h
String.o: String.cpp soopy.h
Tuple.o: Tuple.cpp soopy.h
List.o: List.cpp soopy.h
NameSpace.o: NameSpace.cpp soopy.h
Symbol.o: Symbol.cpp soopy.h
SjisRW.o: SjisRW.cpp soopy.h
Lexer.o: Lexer.cpp soopy.h $(YTAB_OBJ)
	$(CC) $(COPT) Lexer.cpp
$(YTAB_C): parser.y soopy.h
	$(YACC) -d parser.y
	-mv y.tab.h ytab.h
	-mv y.tab.c ytab.cpp

#	$(YACC) -o$(YTAB_C) -d p.y
#	mv ytab.c ytab.cpp
$(YTAB_OBJ): $(YTAB_C)
Assign.o: Assign.cpp soopy.h
SendMsg.o: SendMsg.cpp soopy.h
Nil.o: Nil.cpp soopy.h
Bool.o: Bool.cpp soopy.h
Int.o: Int.cpp soopy.h
Real.o: Real.cpp soopy.h
Handler.o: Handler.cpp soopy.h
Prim.o: Prim.cpp soopy.h
Closure.o: Closure.cpp soopy.h
Expr.o: Expr.cpp soopy.h
Func.o: Func.cpp soopy.h
soopy.o: soopy.cpp soopy.h
If.o: If.cpp soopy.h
Loop.o: Loop.cpp soopy.h
Load.o: Load.cpp soopy.h
Array.o: Array.cpp soopy.h
Datatype.o: Datatype.cpp soopy.h
Except.o: Except.cpp soopy.h
#File.o: File.cpp soopy.h
RW.o: RW.cpp soopy.h
EucJPRW.o: EucJPRW.cpp soopy.h
Dir.o: Dir.cpp soopy.h
Byte.o: Byte.cpp soopy.h
Word.o: Word.cpp soopy.h
RAW.o: RAW.cpp soopy.h
CR_LF.o: CR_LF.cpp soopy.h
Socket.o: Socket.cpp soopy.h
Base64.o: Base64.cpp soopy.h
File.o: File.cpp soopy.h
URLEncode.o: URLEncode.cpp soopy.h
ISO2022JP.o: ISO2022JP.cpp soopy.h
Japanese.o: Japanese.cpp soopy.h
Date.o: Date.cpp soopy.h
Time.o: Time.cpp soopy.h
DateTime.o: DateTime.cpp soopy.h
Thread.o: Thread.cpp soopy.h
Mutex.o: Mutex.cpp soopy.h

fib.o: fib.cpp soopy.h

fib: fib.o $(OBJ)
	$(CC) $(LINKOPT) -o fib fib.o $(OBJ)

