/*
 * fib.cpp
 *
 */

#include <iostream>
#include "soopy.h"

using namespace std;

template<int n>
  struct spint_ {
    static const SpInt value = n;

    static bool match(SpValue& v){
      if(v.isInt()){
        return value == v.getInt();
      }
      return false;
    }

    static SpValue& apply(SpValue&){
      return SpIntResult(value);
    }
  };

template<bool p>
  struct spbool_ {
    static const SpBool value = p;

    static bool match(SpValue& v){
      if(v.isBool()){
        return value == v.getBool();
      }
      return false;
    }

    static SpValue& apply(SpValue&){
      return SpBoolResult(value);
    }
  };

template<bool p>
  struct always {
    static const SpBool value = p;
    static bool match(SpValue&){
      return value;
    }
  };

struct spbase_ {
  virtual bool match(SpValue& v) = 0;
  virtual SpValue& apply(SpValue& v) = 0;
};

template<typename T1, typename T2>
  struct pattern : public spbase_ {
    typedef T1 cond;
    typedef T2 body;

    bool match(SpValue& v){
      return cond::match(v);
    }

    SpValue& apply(SpValue& v){
      return body::apply(v);
    }
  };

//#define any_pattern(var, body) (new pattern< spbool_<true> >(body))
#define any_pattern(body) (new pattern< always<true> , body>)

SpValue& match(SpValue& v){ return NilObject; }

SpValue& match(SpValue& v, spbase_* b1, spbase_* b2, spbase_* b3)
{
  if(b1->match(v)){
    return SpValueResult(b1->apply(v));
  }else if(b2->match(v)){
    return SpValueResult(b2->apply(v));
  }else if(b3->match(v)){
    return SpValueResult(b3->apply(v));
  }
  return NilObject;
}

SpValue& _fib(SpValue& v)
{
  return match(v,
    new pattern< spint_<0> , spint_<0> >,
    new pattern< spint_<1> , spint_<1> >,
    any_pattern( spint_<8> )
    /*
    any_pattern( bind( &SpValue::plus, 
                       bind(&_fib, bind(&SpValue::minus, _1, ObjectTwo)),
                       bind(&_fib, bind(&SpValue::minus, _1, ObjectOne))))
    */
  );
}

int main(int argc, char* argv[], char* env[])
{
  SpInit(argc-2, argv+2, env);

  SpValue n;
  n.setInt(15);
  SpValue result = _fib(n);
  std::cout << result.getInt() << std::endl;

  SpFinalize();
  return 0;
}
