/*
 * Programming Language SOOPY
 *   (Simple Object Oriented Programming sYstem)
 *
 * Copyright (C) 2002 SUZUKI Jun
 *
 * URL: http://sourceforge.jp/projects/soopy/
 * License: GPL(GNU General Public License)
 *
 *
 * $Id: SaveDlg.cpp,v 1.3 2004/05/10 09:58:17 randy Exp $
 */

#include <clx.h>
#pragma hdrstop

#include "soopyg.h"

/*
 * class SpSaveDialog
 */

// Caption
SpValue& SpSaveDialog::getCaption(TWidgetControl* w)
{
//    static SpValue result;
//    result.setNewObject(new SpString(AnsiString(((TSaveDialog*)w)->Title).c_str()));
//    return result;
    return SpObjectResult(new SpString(AnsiString(((TSaveDialog*)w)->Title).c_str()));
}

void SpSaveDialog::setCaption(TWidgetControl* w, const char* str)
{
    ((TSaveDialog*)w)->Title = str;
}

SpValue& SpSaveDialog::primGetFilename()
{
    SpValue n = getCurrentNS();
    SpNameSpace* ns = n.asNameSpace();
    SpValue self = ns->lookup(SymSelf);
    SpComponent* comp = self.asComponent();
//    static SpValue result;
//    result.setNewObject(new SpString(AnsiString(((TSaveDialog*)comp->widget)->FileName).c_str()));
//    return result;
  return SpObjectResult(new SpString(AnsiString(((TSaveDialog*)comp->widget)->FileName).c_str()));
}

/*
SpValue& SpSaveDialog::primGetFilenames()
{
}
*/

// creation
void SpSaveDialog::creation(SpValue& parentNS, TWidgetControl* parent)
{
    SpNameSpace* assoc = ns.asNameSpace();
    widget = new TSaveDialog(parent);

//    SpComponent::after_creation(assoc, parentNS, parent, widget);

    // set self
    SpValue self(this);
    assoc->internConst(SymSelf, self);

    initProperties(assoc);
}

SpValue& SpSaveDialog::make()
{
    SpSaveDialog* win = new SpSaveDialog(getCurrentNS());
    SpValue taker(win);
    win->creation(getCurrentNS(), Application->MainForm);
    //win->creation(getCurrentNS(), NULL);

    // execute dialog
    TSaveDialog* dlg = (TSaveDialog*)win->widget;
    if(dlg->Execute()){
        SpNameSpace* assoc = win->ns.asNameSpace();
        assoc->internVar(SymCanceledP, FalseObject);
    }

    return win->ns;
}

// init
static SpValue GetFilename;
static SpValue GetFilenames;

void SpSaveDialog::initProperties(SpNameSpace* pNS)
{
//    SpComponent::initProperties(pNS);

    // filename, filenames
    pNS->internPrimProperty(SymFilename, NilObject, GetFilename, NilObject);
//    pNS->internPrimProperty(SymFilenames, NilObject, GetFilenames, NilObject);
    //
    pNS->internVar(SymCanceledP, TrueObject);
}

void SpSaveDialog::init()
{
    // set namespace to symbol 'std_savedialog'.
    PSaveDialogNameSpace = new SpNameSpace(PComponentNameSpace->getMap());
    SaveDialogNS.setNewObject(PSaveDialogNameSpace);
    SpValue SymStdSaveDialog(new SpSymbol("std_savedialog"));
    PMainNameSpace->internConst(SymStdSaveDialog, SaveDialogNS);

    GetFilename.setNewObject(new SpPrim0(primGetFilename));
//    GetFilenames.setNewObject(new SpPrim0(primGetFilenames));

    SpValue PrimMake(new SpPrim0(make));
    PSaveDialogNameSpace->internFunc(SymMake, PrimMake);
}

