/*
 * Programming Language SOOPY
 *   (Simple Object Oriented Programming sYstem)
 *
 * Copyright (C) 2002 SUZUKI Jun
 *
 * URL: http://sourceforge.jp/projects/soopy/
 * License: GPL(GNU General Public License)
 *
 *
 * $Id: OpenDlg.cpp,v 1.3 2004/05/10 09:58:17 randy Exp $
 */

#include <clx.h>
#pragma hdrstop

#include "soopyg.h"

/*
 * class SpOpenDialog
 */

// Caption
SpValue& SpOpenDialog::getCaption(TWidgetControl* w)
{
//    static SpValue result;
//    result.setNewObject(new SpString(AnsiString(((TOpenDialog*)w)->Title).c_str()));
//    return result;
  return SpObjectResult(new SpString(AnsiString(((TOpenDialog*)w)->Title).c_str()));
}

void SpOpenDialog::setCaption(TWidgetControl* w, const char* str)
{
    ((TOpenDialog*)w)->Title = str;
}

SpValue& SpOpenDialog::primGetFilename()
{
    SpValue n = getCurrentNS();
    SpNameSpace* ns = n.asNameSpace();
    SpValue self = ns->lookup(SymSelf);
    SpComponent* comp = self.asComponent();
//    static SpValue result;
//    result.setNewObject(new SpString(AnsiString(((TOpenDialog*)comp->widget)->FileName).c_str()));
//    return result;
  return SpObjectResult(new SpString(AnsiString(((TOpenDialog*)comp->widget)->FileName).c_str()));
}

/*
SpValue& SpOpenDialog::primGetFilenames()
{
}
*/


// creation
void SpOpenDialog::creation(SpValue& parentNS, TWidgetControl* parent)
{
    SpNameSpace* assoc = ns.asNameSpace();
    widget = new TOpenDialog(parent);

//    SpComponent::after_creation(assoc, parentNS, parent, widget);

    // set self
    SpValue self(this);
    assoc->internConst(SymSelf, self);

    initProperties(assoc);
}

SpValue& SpOpenDialog::make()
{
    SpOpenDialog* win = new SpOpenDialog(getCurrentNS());
    SpValue taker(win);
    win->creation(getCurrentNS(), Application->MainForm);
    //win->creation(getCurrentNS(), NULL);

    // execute dialog
    TOpenDialog* dlg = (TOpenDialog*)win->widget;
    if(dlg->Execute()){
        SpNameSpace* assoc = win->ns.asNameSpace();
        assoc->internVar(SymCanceledP, FalseObject);
    }

    return win->ns;
}

// init
static SpValue GetFilename;
static SpValue GetFilenames;

void SpOpenDialog::initProperties(SpNameSpace* pNS)
{
//    SpComponent::initProperties(pNS);

    // filename, filenames
    pNS->internPrimProperty(SymFilename, NilObject, GetFilename, NilObject);
//    pNS->internPrimProperty(SymFilenames, NilObject, GetFilenames, NilObject);
    //
    pNS->internVar(SymCanceledP, TrueObject);
}

void SpOpenDialog::init()
{
    // set namespace to symbol 'std_opendialog'.
    POpenDialogNameSpace = new SpNameSpace(PComponentNameSpace->getMap());
    OpenDialogNS.setNewObject(POpenDialogNameSpace);
    SpValue SymStdOpenDialog(new SpSymbol("std_opendialog"));
    PMainNameSpace->internConst(SymStdOpenDialog, OpenDialogNS);

    GetFilename.setNewObject(new SpPrim0(primGetFilename));
//    GetFilenames.setNewObject(new SpPrim0(primGetFilenames));

    SpValue PrimMake(new SpPrim0(make));
    POpenDialogNameSpace->internFunc(SymMake, PrimMake);
}

