/*
 * Programming Language SOOPY
 *   (Simple Object Oriented Programming sYstem)
 *
 * Copyright (C) 2002 SUZUKI Jun
 *
 * URL: http://sourceforge.jp/projects/soopy/
 * License: GPL(GNU General Public License)
 *
 *
 * $Id: Edit.cpp,v 1.5 2004/05/10 09:58:17 randy Exp $
 */

#include <clx.h>
#pragma hdrstop

#include "soopyg.h"

/*
 * class TSpEdit
 */

void __fastcall TSpEdit::Click(void)
{
    TWinControl::Click();        // nȟĂяoȂǕWIȏs
    SpValue onClick  = ns->lookup(SymOnClick);
    if(onClick.isFunc()){
        SpFunc* f = onClick.asFunc();
        (*f)(NilObject);
    }
}

void __fastcall TSpEdit::DblClick(void)
{
    TWinControl::DblClick();        // nȟĂяoȂǕWIȏs
    SpValue onDblClick  = ns->lookup(SymOnDblClick);
    if(onDblClick.isFunc()){
        SpFunc* f = onDblClick.asFunc();
        (*f)(NilObject);
    }
}

void __fastcall TSpEdit::Change(void)
{
    TCustomEdit::Change();        // nȟĂяoȂǕWIȏs
    SpValue onChange  = ns->lookup(SymOnChange);
    if(onChange.isFunc()){
        SpFunc* f = onChange.asFunc();
        (*f)(NilObject);
    }
}


/*
 * class SpEdit
 */

SpValue& SpEdit::make()
{
    SpEdit* edit = new SpEdit(getCurrentNS());
//    static SpValue result;
//    result.setNewObject(edit);
//    return result;
  return SpObjectResult(edit);
}

// Caption
SpValue& SpEdit::getCaption(TWidgetControl* w)
{
    throw SpCaptionException("can't get field.caption");
}

void SpEdit::setCaption(TWidgetControl* w, const char* str)
{
    throw SpCaptionException("can't set field.caption");
}

void SpEdit::creation(SpValue& parentNS, TWidgetControl* parent)
{
    SpNameSpace* assoc = ns.asNameSpace();
    widget = new TSpEdit(parent, assoc);

    SpComponent::after_creation(assoc, parentNS, parent, (TWidgetControl*)widget);

    // set text
    SpValue vtext  = assoc->lookup(SymText);
    if(vtext.isString()){
        ((TEdit*)widget)->Text = vtext.toCStringWithEncoder();
    }

    // set self
    SpValue self(this);
    assoc->internConst(SymSelf, self);

    initProperties(assoc); // SpComponent::initProperties
//    ((TSpEdit*)widget)->initProperties();
}

// primitives
SpValue& SpEdit::primGetText()
{
    SpValue n = getCurrentNS();
    SpNameSpace* ns = n.asNameSpace();
    SpValue self = ns->lookup(SymSelf);
    SpComponent* comp = self.asComponent();
//    static SpValue result;
//    result.setNewObject(new SpString(AnsiString(((TEdit*)comp->widget)->Text).c_str()));
//    return result;
  return SpObjectResult(new SpString(AnsiString(((TEdit*)comp->widget)->Text).c_str()));
}

SpValue& SpEdit::primSetText(SpValue& v)
{
    if(v.isString()){
        SpValue n = getCurrentNS();
        SpNameSpace* ns = n.asNameSpace();
        SpValue self = ns->lookup(SymSelf);
        SpComponent* comp = self.asComponent();
        ((TEdit*)comp->widget)->Text = v.toCStringWithEncoder();
    }
    return TrueObject;
}

// init
static SpValue GetText;
static SpValue SetText;

void SpEdit::initProperties(SpNameSpace* pNS)
{
    SpComponent::initProperties(pNS);
    // Text
    pNS->internPrimProperty(SymText, NilObject, GetText, SetText);
}

void SpEdit::init()
{
    // set namespace to symbol 'std_field'.
    PEditNameSpace = new SpNameSpace(PComponentNameSpace->getMap());
    EditNS.setNewObject(PEditNameSpace);
    SpValue SymStdField(new SpSymbol("std_field"));
    PMainNameSpace->internConst(SymStdField, EditNS);

    GetText.setNewObject(new SpPrim0(primGetText));
    SetText.setNewObject(new SpPrim1(primSetText));

    SpValue PrimMake(new SpPrim0(make));
    PEditNameSpace->internFunc(SymMake, PrimMake);
}

