/*
 * Programming Language SOOPY
 *   (Simple Object Oriented Programming sYstem)
 *
 * Copyright (C) 2002 SUZUKI Jun
 *
 * URL: http://sourceforge.jp/projects/soopy/
 * License: GPL(GNU General Public License)
 *
 *
 * $Id: Dialog.cpp,v 1.3 2004/05/10 09:58:17 randy Exp $
 */

#include <clx.h>
#pragma hdrstop

#include "soopyg.h"

SpNameSpace* POkDialogNameSpace;
SpValue OkDialogNS;
SpNameSpace* POkCancelDialogNameSpace;
SpValue OkCancelDialogNS;
SpNameSpace* PYesNoDialogNameSpace;
SpValue YesNoDialogNS;

/*
 * OkCancelDialog
 */

// creation
SpValue& SpOkDialog::make()
{
    SpValue ns = getCurrentNS();
    SpNameSpace* assoc = ns.asNameSpace();
    SpValue vmessage = assoc->lookup(SymMessage);
    SpValue vcaption = assoc->lookup(SymCaption);
    if(!(vmessage.isString() && vcaption.isString())){
        throw SpException("not string (message dialog)");
    }

    char message[256];
    char caption[256];
    strncpy(message, vmessage.toCStringWithEncoder(), 255);
    strncpy(caption, vcaption.toCStringWithEncoder(), 255);
    message[255] = '\0';
    caption[255] = '\0';
    TMessageButtons b;
    b << smbOK;
    Application->MessageBox(message, caption, b, smsWarning);
    assoc->internVar(SymCanceledP, FalseObject);

//    static SpValue result;
//    result = ns;
//    return result;
    SpValue result;
    result = ns;
    return SpValueResult(result);
}

// init
void SpOkDialog::init()
{
    // set namespace to symbol 'OkDialog'.
    POkDialogNameSpace = new SpNameSpace(PComponentNameSpace->getMap());
    OkDialogNS.setNewObject(POkDialogNameSpace);
    SpValue SymOkDialog(new SpSymbol("okdialog"));
    PMainNameSpace->internConst(SymOkDialog, OkDialogNS);

    POkDialogNameSpace->internVar(SymCaption, new SpString("warning"));
    POkDialogNameSpace->internVar(SymMessage, new SpString("ok?"));

    SpValue PrimMake(new SpPrim0(make));
    POkDialogNameSpace->internFunc(SymMake, PrimMake);
}

/*
 * OkCancelDialog
 */

// creation
SpValue& SpOkCancelDialog::make()
{
    SpValue ns = getCurrentNS();
    SpNameSpace* assoc = ns.asNameSpace();
    SpValue vmessage = assoc->lookup(SymMessage);
    SpValue vcaption = assoc->lookup(SymCaption);
    if(!(vmessage.isString() && vcaption.isString())){
        throw SpException("not string (message dialog)");
    }

    char message[256];
    char caption[256];
    strncpy(message, vmessage.toCStringWithEncoder(), 255);
    strncpy(caption, vcaption.toCStringWithEncoder(), 255);
    message[255] = '\0';
    caption[255] = '\0';
    TMessageButtons b;
    b << smbOK << smbCancel;
    if(Application->MessageBox(message, caption, b, smsWarning) == smbOK){
        assoc->internVar(SymCanceledP, FalseObject);
    }else{
        assoc->internVar(SymCanceledP, TrueObject);
    }
//    static SpValue result;
//    result = ns;
//    return result;
    SpValue result;
    result = ns;
    return SpValueResult(result);
}

// init
void SpOkCancelDialog::init()
{
    // set namespace to symbol 'OkCancelDialog'.
    POkCancelDialogNameSpace = new SpNameSpace(PComponentNameSpace->getMap());
    OkCancelDialogNS.setNewObject(POkCancelDialogNameSpace);
    SpValue SymOkCancelDialog(new SpSymbol("okcanceldialog"));
    PMainNameSpace->internConst(SymOkCancelDialog, OkCancelDialogNS);

    POkCancelDialogNameSpace->internVar(SymCaption, new SpString("select"));
    POkCancelDialogNameSpace->internVar(SymMessage, new SpString("ok? or cancel?"));

    SpValue PrimMake(new SpPrim0(make));
    POkCancelDialogNameSpace->internFunc(SymMake, PrimMake);
}

/*
 * YesNoDialog
 */

// creation
SpValue& SpYesNoDialog::make()
{
    SpValue ns = getCurrentNS();
    SpNameSpace* assoc = ns.asNameSpace();
    SpValue vmessage = assoc->lookup(SymMessage);
    SpValue vcaption = assoc->lookup(SymCaption);
    if(!(vmessage.isString() && vcaption.isString())){
        throw SpException("not string (message dialog)");
    }

    char message[256];
    char caption[256];
    strncpy(message, vmessage.toCStringWithEncoder(), 255);
    strncpy(caption, vcaption.toCStringWithEncoder(), 255);
    message[255] = '\0';
    caption[255] = '\0';
    TMessageButtons b;
    b << smbYes << smbNo;
    if(Application->MessageBox(message, caption, b, smsWarning) == smbYes){
        assoc->internVar(SymCanceledP, FalseObject);
    }else{
        assoc->internVar(SymCanceledP, TrueObject);
    }
//    static SpValue result;
//    result = ns;
//    return result;
    SpValue result;
    result = ns;
    return SpValueResult(result);
}

// init
void SpYesNoDialog::init()
{
    // set namespace to symbol 'YesNoDialog'.
    PYesNoDialogNameSpace = new SpNameSpace(PComponentNameSpace->getMap());
    YesNoDialogNS.setNewObject(PYesNoDialogNameSpace);
    SpValue SymYesNoDialog(new SpSymbol("yesnodialog"));
    PMainNameSpace->internConst(SymYesNoDialog, YesNoDialogNS);

    PYesNoDialogNameSpace->internVar(SymCaption, new SpString("select"));
    PYesNoDialogNameSpace->internVar(SymMessage, new SpString("YES? or NO?"));

    SpValue PrimMake(new SpPrim0(make));
    PYesNoDialogNameSpace->internFunc(SymMake, PrimMake);
}

/*
 * init dialogs
 */
void initDialogs()
{
    SpOkDialog::init();
    SpOkCancelDialog::init();
    SpYesNoDialog::init();
}

