/*
 * Programming Language SOOPY
 *   (Simple Object Oriented Programming sYstem)
 * 
 * Copyright (C) 2002,2003 SUZUKI Jun
 * 
 * URL: http://sourceforge.jp/projects/soopy/
 * License: GPL(GNU General Public License)
 * 
 * 
 * $Id: Time.cpp,v 1.8 2004/07/04 12:32:36 randy Exp $
 */

#include <time.h>
#include "soopy.h"

void SpTime::regular()
{
    // minute
    if(minute < 0){
        while(minute < 0){
            minute += 60;
            hour--;
        }
    }else if(minute >= 60){
        while(minute >= 60){
            minute -= 60;
            hour++;
        }
    }

    // second
    if(second < 0){
        while(second < 0){
            second += 60;
            minute--;
        }
    }else if(second >= 60){
        while(second >= 60){
            second -= 60;
            minute++;
        }
    }
}

SpValue& SpTime::plus(SpValue& e1, SpValue& e2)
{
    SpTime* t1 = e1.asTime();
    SpTime* time;
    if(e2.isInt()){
        SpInt i = e2.getInt();
        time = new SpTime(t1->hour,
                          t1->minute,
                          t1->second + i);
    }else if(e2.isTime()){
        SpTime* t2 = e2.asTime();
        time = new SpTime(t1->hour   + t2->hour,
                          t1->minute + t2->minute,
                          t1->second + t2->second);
    }else{
        throw SpException("not time operator+");
    }
    time->regular();
    //    static SpValue result;
    //    result.setNewObject(time);
    //    return result;
    return SpObjectResult(time);
}

SpValue& SpTime::minus(SpValue& e1, SpValue& e2)
{
    SpTime* t1 = e1.asTime();
    SpTime* time;
    if(e2.isInt()){
        SpInt i = e2.getInt();
        time = new SpTime(t1->hour,
                          t1->minute,
                          t1->second - i);
    }else if(e2.isTime()){
        SpTime* t2 = e2.asTime();
        time = new SpTime(t1->hour   - t2->hour,
                          t1->minute - t2->minute,
                          t1->second - t2->second);
    }else{
        throw SpException("not time operator-");
    }
    time->regular();
    //    static SpValue result;
    //    result.setNewObject(time);
    //    return result;
    return SpObjectResult(time);
}

SpValue& SpTime::eq(SpValue& e1, SpValue& e2)
{
    if(!e2.isTime()){
        return SpBoolResult(false);
    }
    SpTime* t1 = e1.asTime();
    SpTime* t2 = e2.asTime();
    return SpBoolResult((t1->hour == t2->hour) && (t1->minute == t2->minute) && (t1->second == t2->second));
}

SpValue& SpTime::ne(SpValue& e1, SpValue& e2)
{
    if(!e2.isTime()){
        return SpBoolResult(false);
    }
    SpTime* t1 = e1.asTime();
    SpTime* t2 = e2.asTime();
    return SpBoolResult((t1->hour != t2->hour) || (t1->minute != t2->minute) || (t1->second != t2->second));
}

SpValue& SpTime::gt(SpValue& e1, SpValue& e2)
{
    if(!e2.isTime()){
        throw SpException("unmatch type (Time >)");
    }
    SpTime* t1 = e1.asTime();
    SpTime* t2 = e2.asTime();
    if(t1->hour > t2->hour){
        return SpBoolResult(true);
    }else if(t1->hour == t2->hour){
        if(t1->minute > t2->minute){
            return SpBoolResult(true);
        }else if(t1->minute == t2->minute){
            return SpBoolResult(t1->second > t2->second);
        }
    }
    return SpBoolResult(false);
}

SpValue& SpTime::ge(SpValue& e1, SpValue& e2)
{
    if(!e2.isTime()){
        throw SpException("unmatch type (>=)");
    }
    SpTime* t1 = e1.asTime();
    SpTime* t2 = e2.asTime();
    if(t1->hour > t2->hour){
        return SpBoolResult(true);
    }else if(t1->hour == t2->hour){
        if(t1->minute > t2->minute){
            return SpBoolResult(true);
        }else if(t1->minute == t2->minute){
            return SpBoolResult(t1->second >= t2->second);
        }
    }
    return SpBoolResult(false);
}

SpValue& SpTime::lt(SpValue& e1, SpValue& e2)
{
    if(!e2.isTime()){
        throw SpException("unmatch type (<)");
    }
    SpTime* t1 = e1.asTime();
    SpTime* t2 = e2.asTime();
    if(t1->hour < t2->hour){
        return SpBoolResult(true);
    }else if(t1->hour == t2->hour){
        if(t1->minute < t2->minute){
            return SpBoolResult(true);
        }else if(t1->minute == t2->minute){
            return SpBoolResult(t1->second < t2->second);
        }
    }
    return SpBoolResult(false);
}

SpValue& SpTime::le(SpValue& e1, SpValue& e2)
{
    if(!e2.isTime()){
        throw SpException("unmatch type (<=)");
    }
    SpTime* t1 = e1.asTime();
    SpTime* t2 = e2.asTime();
    if(t1->hour < t2->hour){
        return SpBoolResult(true);
    }else if(t1->hour == t2->hour){
        if(t1->minute < t2->minute){
            return SpBoolResult(true);
        }else if(t1->minute == t2->minute){
            return SpBoolResult(t1->second <= t2->second);
        }
    }
    return SpBoolResult(false);
}

SpValue& SpTime::toString()
{
    char buf[10];
    SpString* str = new SpString;
    sprintf(buf, "%d", hour);
    *str += buf;
    sprintf(buf, ":%d", minute);
    *str += buf;
    sprintf(buf, ":%d", second);
    *str += buf;
    //    static SpValue val;
    //    val.setNewObject(str);
    //    return val;
    return SpObjectResult(str);
}

void SpTime::assign(SpValue& feature, SpValue& value)
{
    SpValue v;

    if(feature == SymHour){
        v = value.eval();
        if(!v.isInt()){
            throw SpException("not int(assign time)");
        }
        hour = v.getInt();
    }else if(feature == SymMinute){
        v = value.eval();
        if(!v.isInt()){
            throw SpException("not int(assign time)");
        }
        minute = v.getInt();
    }else if(feature == SymSecond){
        v = value.eval();
        if(!v.isInt()){
            throw SpException("not int(assign time)");
        }
        second = v.getInt();
    }else{
        throw SpException("no such a feature(assign time)");
    }
}

// primitives
SpValue& SpTime::prim_now()
{
    SpInt h, m, s;
    time_t t;
    struct tm* area;

    t = time(NULL);
    area = localtime(&t);
    h = area->tm_hour;
    m = area->tm_min;
    s = area->tm_sec;

    //    static SpValue result;
    //    result.setNewObject(new SpTime(h, m, s));
    //    return result;
    return SpObjectResult(new SpTime(h, m, s));
}

SpValue& SpTime::prim_new(SpValue& v1, SpValue& v2, SpValue& v3)
{
    SpInt h, m, s;

    if(!v1.isInt()){
        throw SpException("not int (Date.new)");
    }
    if(!v2.isInt()){
        throw SpException("not int (Date.new)");
    }
    if(!v3.isInt()){
        throw SpException("not int (Date.new)");
    }
    h = v1.getInt();
    m = v2.getInt();
    s = v3.getInt();

    //    static SpValue result;
    //    result.setNewObject(new SpTime(h, m, s));
    //    return result;
    return SpObjectResult(new SpTime(h, m, s));
}

/*
SpValue& SpTime::prim_succ(SpValue& self)
{
    SpInt h, m, s;
    SpTime* time = self.asTime();

    h = time->hour;
    m = time->minute;
    s = time->second;
    SpTime* time2 = new SpTime(h, m, s+1);
    time2->regular();

    static SpValue result;
    result.setNewObject(time2);
    return result;
}

SpValue& SpTime::prim_pred(SpValue& self)
{
    SpInt h, m, s;
    SpTime* time = self.asTime();

    h = time->hour;
    m = time->minute;
    s = time->second;
    SpTime* time2 = new SpTime(h, m, s-1);
    time2->regular();

    static SpValue result;
    result.setNewObject(time2);
    return result;
}
*/

SpValue& SpTime::prim_getHour(SpValue& self)
{
    SpTime* p = self.asTime();
    //    static SpValue result;
    //    result.setInt(p->hour);
    //    return result;
    return SpIntResult(p->hour);
}

SpValue& SpTime::prim_getMinute(SpValue& self)
{
    SpTime* p = self.asTime();
    //    static SpValue result;
    //    result.setInt(p->minute);
    //    return result;
    return SpIntResult(p->minute);
}

SpValue& SpTime::prim_getSecond(SpValue& self)
{
    SpTime* p = self.asTime();
    //    static SpValue result;
    //    result.setInt(p->second);
    //    return result;
    return SpIntResult(p->second);
}

SpValue& SpTime::prim_fromString(SpValue& time_str)
{
    SpInt h, m, s;
    SpValue temp;
    SpString* str = time_str.asString();

    SpValue v = str->split(MakeSpChar(CodeJIS, ':'));
    SpCons* list = (SpCons*)v.asList();
    if(list->length() != 3){
        throw SpException("illegal time format");
    }

    //h = int_fromString(list->value().asString());
    temp = list->value();
    h = int_fromString(temp.asString());
    temp = list->nextList();
    list = (SpCons*)temp.asList();
    //m = int_fromString(list->value().asString());
    temp = list->value();
    m = int_fromString(temp.asString());
    temp = list->nextList();
    list = (SpCons*)temp.asList();
    //s = int_fromString(list->value().asString());
    temp = list->value();
    s = int_fromString(temp.asString());

    //    static SpValue result;
    //    result.setNewObject(new SpTime(h, m, s));
    //    return result;
    return SpObjectResult(new SpTime(h, m, s));
}


// Message Handler
SpValue& SpTime::onMessage(SpValue& rec, SpValue& msg)
{
    return TimeMsgHandler(rec, msg);
}

// init
void SpTime::init()
{
    SpNameSpace* pTimeNS = new SpNameSpace;
    SpValue TimeNS(pTimeNS);
    PMainNameSpace->internConst(SymTime, TimeNS);

    // for Class
    SpValue SymNow(new SpSymbol("now"));
    SpValue PrimNow(new SpPrim0(prim_now));
    pTimeNS->internPrimProperty(SymNow, NilObject, PrimNow, NilObject);

    SpValue SymNew(new SpSymbol("new"));
    SpValue PrimNew(new SpPrim3(prim_new));
    pTimeNS->internConst(SymNew, PrimNew);

    SpValue SymFromString(new SpSymbol("fromstring"));
    SpValue PrimFromString(new SpPrim1(prim_fromString));
    pTimeNS->internConst(SymFromString, PrimFromString);

    // for Object
    SpValue GetHour(new SpPrim1(prim_getHour));
    TimeMsgHandler.append(SymHour, GetHour);

    SpValue GetMinute(new SpPrim1(prim_getMinute));
    TimeMsgHandler.append(SymMinute, GetMinute);

    SpValue GetSecond(new SpPrim1(prim_getSecond));
    TimeMsgHandler.append(SymSecond, GetSecond);

/*
    SpValue PrimSucc(new SpPrim1(prim_succ));
    TimeMsgHandler.append(SymSucc, PrimSucc);

    SpValue PrimPred(new SpPrim1(prim_pred));
    TimeMsgHandler.append(SymPred, PrimPred);
*/
}


