/*
 * Programming Language SOOPY
 *   (Simple Object Oriented Programming sYstem)
 * 
 * Copyright (C) 2002 SUZUKI Jun
 * 
 * URL: http://sourceforge.jp/projects/soopy/
 * License: GPL(GNU General Public License)
 * 
 * 
 * $Id: Symbol.cpp,v 1.19 2004/03/21 05:48:06 randy Exp $
 */

//
// Soopy Symbol Class
//

#include "soopy.h"

bool SpSymbol::operator==(SpObject& obj)
{
    SpString* p2;
    SpSymbol* sym = dynamic_cast<SpSymbol*>(&obj);
    if(sym != NULL){
//        return str == sym->str;
        p2 = (SpString*)sym;
        if(p2 != NULL){
            return SpString::operator==(*p2);
        }
    }
    return false;
}

bool SpSymbol::operator<(SpObject& obj)
{
    SpString* p2;
    SpSymbol* sym = dynamic_cast<SpSymbol*>(&obj);
    if(sym != NULL){
        p2 = (SpString*)sym;
        if(p2 != NULL){
            return SpString::operator<(obj);
        }
    }
    return SpObject::operator<(obj);
}

SpValue& SpSymbol::eval()
{
    SpValue val = getCurrentNS();
    SpNameSpace* ns = dynamic_cast<SpNameSpace*>(val.getObject());
    SpValue key(new SpSymbol(str));
    //    static SpValue v;
    SpValue v;
    v = ns->lookup(key, ns);
    if(v.isConstructor()){
        v = v.eval();
    }
    //    return v;
    return SpValueResult(v);
}

SpValue& SpSymbol::toString()
{
    //    static SpValue val;
    //    val.setNewObject(new SpString(toCStringWithEncoder()));
    //    return val;
    return SpObjectResult(new SpString(toCStringWithEncoder()));
}

SpValue& SpSymbol::eq(SpValue&, SpValue& e2)
{
    if(!e2.isSymbol()){
        throw SpException("type mismatch in ==(Symbol, ...)");
    }
    SpSymbol* s = e2.asSymbol();
    if(str == s->str){
        return TrueObject;
    }
    return FalseObject;
}

/*
 * Message Handler
 */

SpValue& SpSymbol::onMessage(SpValue& rec, SpValue& msg)
{
    return SymbolMsgHandler(rec, msg);
}

// symbol Primitives


// init Message Handler
void SpSymbol::init()
{
}

/*
 * pattern match
 */

bool SpSymbol::match(SpValue& self, SpValue& val, SpNameSpace* ns)
{
/*
    NSVar* var = new NSVar(self);
    ns->intern(var, val);
*/
    ns->internVar(self, val);
    return true;
}

