/*
 * Programming Language SOOPY
 *   (Simple Object Oriented Programming sYstem)
 * 
 * Copyright (C) 2002 SUZUKI Jun
 * 
 * URL: http://sourceforge.jp/projects/soopy/
 * License: GPL(GNU General Public License)
 * 
 * 
 * $Id: Real.cpp,v 1.7 2004/03/21 05:48:06 randy Exp $
 */

#include <math.h>
#include "soopy.h"

SpValue& real_toInt(SpValue& v)
{
    //    static SpValue res;
    //    res.setInt((SpInt)v.getReal());
    //    return res;
    return SpIntResult((SpInt)v.getReal());
}

SpValue& real_toString(SpValue& v)
{
    SpString* str = new SpString;
    *str += v;
    //    static SpValue res;
    //    res.setNewObject(str);
    //    return res;
    return SpObjectResult(str);
}

SpValue& real_acos(SpValue& v)
{
    //    static SpValue res;
    //    res.setReal(acos(v.getReal()));
    //    return res;
    return SpRealResult(acos(v.getReal()));
}

SpValue& real_asin(SpValue& v)
{
    //    static SpValue res;
    //    res.setReal(asin(v.getReal()));
    //    return res;
    return SpRealResult(asin(v.getReal()));
}

SpValue& real_atan(SpValue& v)
{
    //    static SpValue res;
    //    res.setReal(atan(v.getReal()));
    //    return res;
    return SpRealResult(atan(v.getReal()));
}

SpValue& real_atan2(SpValue& v, SpValue& v2)
{
    if(!v2.isReal()){
        throw SpException("not real (atan2)");
    }
    //    static SpValue res;
    //    res.setReal(atan2(v.getReal(), v2.getReal()));
    //    return res;
    return SpRealResult(atan2(v.getReal(), v2.getReal()));
}

SpValue& real_ceil(SpValue& v)
{
    //    static SpValue res;
    //    res.setReal(ceil(v.getReal()));
    //    return res;
    return SpRealResult(ceil(v.getReal()));
}

SpValue& real_cos(SpValue& v)
{
    //    static SpValue res;
    //    res.setReal(cos(v.getReal()));
    //    return res;
    return SpRealResult(cos(v.getReal()));
}

SpValue& real_cosh(SpValue& v)
{
    //    static SpValue res;
    //    res.setReal(cosh(v.getReal()));
    //    return res;
    return SpRealResult(cosh(v.getReal()));
}

SpValue& real_exp(SpValue& v)
{
    //    static SpValue res;
    //    res.setReal(exp(v.getReal()));
    //    return res;
  return SpRealResult(exp(v.getReal()));
}

SpValue& real_fabs(SpValue& v)
{
    //    static SpValue res;
    //    res.setReal(fabs(v.getReal()));
    //    return res;
    return SpRealResult(fabs(v.getReal()));
}

SpValue& real_floor(SpValue& v)
{
    //    static SpValue res;
    //    res.setReal(floor(v.getReal()));
    //    return res;
    return SpRealResult(floor(v.getReal()));
}

SpValue& real_fmod(SpValue& v, SpValue& v2)
{
    if(!v2.isReal()){
        throw SpException("not real (fmod)");
    }
    //    static SpValue res;
    //    res.setReal(fmod(v.getReal(), v2.getReal()));
    //    return res;
    return SpRealResult(fmod(v.getReal(), v2.getReal()));
}

SpValue& real_frexp(SpValue& v)
{
    int exponent;
    SpReal r = frexp(v.getReal(), &exponent);
    SpValue temp;
    temp.setReal(r);
    SpTuple* t = new SpTuple(temp);
    temp.setInt(exponent);
    t->append(temp);
    //    static SpValue res;
    //    res.setNewObject(t);
    //    return res;
    return SpObjectResult(t);
}

SpValue& real_hypot(SpValue& v, SpValue& v2)
{
    if(!v2.isReal()){
        throw SpException("not real (hypot)");
    }
    //    static SpValue res;
    //    res.setReal(hypot(v.getReal(), v2.getReal()));
    //    return res;
    return SpRealResult(hypot(v.getReal(), v2.getReal()));
}

SpValue& real_ldexp(SpValue& v, SpValue& v2)
{
    if(!v2.isInt()){
        throw SpException("not int (ldexp)");
    }
    //    static SpValue res;
    //    res.setReal(ldexp(v.getReal(), v2.getInt()));
    //    return res;
    return SpRealResult(ldexp(v.getReal(), v2.getInt()));
}

SpValue& real_log(SpValue& v)
{
    //    static SpValue res;
    //    res.setReal(log(v.getReal()));
    //    return res;
    return SpRealResult(log(v.getReal()));
}

SpValue& real_log10(SpValue& v)
{
    //    static SpValue res;
    //    res.setReal(log10(v.getReal()));
    //    return res;
    return SpRealResult(log10(v.getReal()));
}

SpValue& real_modf(SpValue& v)
{
    double ipart;
    SpReal r = modf(v.getReal(), &ipart);
    SpValue temp;
    temp.setReal(r);
    SpTuple* t = new SpTuple(temp);
    temp.setReal(ipart);
    t->append(temp);
    //    static SpValue res;
    //    res.setNewObject(t);
    //    return res;
    return SpObjectResult(t);
}

SpValue& real_pow(SpValue& v, SpValue& v2)
{
    if(!v2.isReal()){
        throw SpException("not real (pow)");
    }
    //    static SpValue res;
    //    res.setReal(pow(v.getReal(), v2.getReal()));
    //    return res;
    return SpRealResult(pow(v.getReal(), v2.getReal()));
}

SpValue& real_sin(SpValue& v)
{
    //    static SpValue res;
    //    res.setReal(sin(v.getReal()));
    //    return res;
  return SpRealResult(sin(v.getReal()));
}

SpValue& real_sinh(SpValue& v)
{
    //    static SpValue res;
    //    res.setReal(sinh(v.getReal()));
    //    return res;
    return SpRealResult(sinh(v.getReal()));
}

SpValue& real_sqrt(SpValue& v)
{
    //    static SpValue res;
    //    res.setReal(sqrt(v.getReal()));
    //    return res;
    return SpRealResult(sqrt(v.getReal()));
}

SpValue& real_tan(SpValue& v)
{
    //    static SpValue res;
    //    res.setReal(tan(v.getReal()));
    //    return res;
    return SpRealResult(tan(v.getReal()));
}

SpValue& real_tanh(SpValue& v)
{
    //    static SpValue res;
    //    res.setReal(tanh(v.getReal()));
    //    return res;
    return SpRealResult(tanh(v.getReal()));
}

void initReal()
{
    RealMsgHandler.append(SymIsReal, PrimTrue);

    SpValue SymToInt(new SpSymbol("toint"));
    SpValue PrimToInt(new SpPrim1(real_toInt));
    RealMsgHandler.append(SymToInt, PrimToInt);

    SpValue PrimToString(new SpPrim1(real_toString));
    RealMsgHandler.append(SymToString, PrimToString);

    SpValue SymFabs(new SpSymbol("abs"));
    SpValue PrimFabs(new SpPrim1(real_fabs));
    RealMsgHandler.append(SymFabs, PrimFabs);

    SpValue SymAcos(new SpSymbol("acos"));
    SpValue PrimAcos(new SpPrim1(real_acos));
    RealMsgHandler.append(SymAcos, PrimAcos);

    SpValue SymAsin(new SpSymbol("asin"));
    SpValue PrimAsin(new SpPrim1(real_asin));
    RealMsgHandler.append(SymAsin, PrimAsin);

    SpValue SymAtan(new SpSymbol("atan"));
    SpValue PrimAtan(new SpPrim1(real_atan));
    RealMsgHandler.append(SymAtan, PrimAtan);

    SpValue SymAtan2(new SpSymbol("atan2"));
    SpValue PrimAtan2(new SpPrim2(real_atan2));
    RealMsgHandler.append(SymAtan2, PrimAtan2);

    SpValue SymCeil(new SpSymbol("ceil"));
    SpValue PrimCeil(new SpPrim1(real_ceil));
    RealMsgHandler.append(SymCeil, PrimCeil);

    SpValue SymCos(new SpSymbol("cos"));
    SpValue PrimCos(new SpPrim1(real_cos));
    RealMsgHandler.append(SymCos, PrimCos);

    SpValue SymCosh(new SpSymbol("cosh"));
    SpValue PrimCosh(new SpPrim1(real_cosh));
    RealMsgHandler.append(SymCosh, PrimCosh);

    SpValue SymExp(new SpSymbol("exp"));
    SpValue PrimExp(new SpPrim1(real_exp));
    RealMsgHandler.append(SymExp, PrimExp);

    SpValue SymFloor(new SpSymbol("floor"));
    SpValue PrimFloor(new SpPrim1(real_floor));
    RealMsgHandler.append(SymFloor, PrimFloor);

    SpValue SymFmod(new SpSymbol("fmod"));
    SpValue PrimFmod(new SpPrim2(real_fmod));
    RealMsgHandler.append(SymFmod, PrimFmod);

    SpValue SymFrexp(new SpSymbol("frexp"));
    SpValue PrimFrexp(new SpPrim1(real_frexp));
    RealMsgHandler.append(SymFrexp, PrimFrexp);

    SpValue SymHypot(new SpSymbol("hypot"));
    SpValue PrimHypot(new SpPrim2(real_hypot));
    RealMsgHandler.append(SymHypot, PrimHypot);

    SpValue SymLdexp(new SpSymbol("ldexp"));
    SpValue PrimLdexp(new SpPrim2(real_ldexp));
    RealMsgHandler.append(SymLdexp, PrimLdexp);

    SpValue SymLog(new SpSymbol("log"));
    SpValue PrimLog(new SpPrim1(real_log));
    RealMsgHandler.append(SymLog, PrimLog);

    SpValue SymLog10(new SpSymbol("log10"));
    SpValue PrimLog10(new SpPrim1(real_log10));
    RealMsgHandler.append(SymLog10, PrimLog10);

    SpValue SymPow(new SpSymbol("pow"));
    SpValue PrimPow(new SpPrim2(real_pow));
    RealMsgHandler.append(SymPow, PrimPow);

    SpValue SymSin(new SpSymbol("sin"));
    SpValue PrimSin(new SpPrim1(real_sin));
    RealMsgHandler.append(SymSin, PrimSin);

    SpValue SymSinh(new SpSymbol("sinh"));
    SpValue PrimSinh(new SpPrim1(real_sinh));
    RealMsgHandler.append(SymSinh, PrimSinh);

    SpValue SymSqrt(new SpSymbol("sqrt"));
    SpValue PrimSqrt(new SpPrim1(real_sqrt));
    RealMsgHandler.append(SymSqrt, PrimSqrt);

    SpValue SymTan(new SpSymbol("tan"));
    SpValue PrimTan(new SpPrim1(real_tan));
    RealMsgHandler.append(SymTan, PrimTan);

    SpValue SymTanh(new SpSymbol("tanh"));
    SpValue PrimTanh(new SpPrim1(real_tanh));
    RealMsgHandler.append(SymTanh, PrimTanh);
}

