/*
 * Programming Language SOOPY
 *   (Simple Object Oriented Programming sYstem)
 * 
 * Copyright (C) 2002,2003 SUZUKI Jun
 * 
 * URL: http://sourceforge.jp/projects/soopy/
 * License: GPL(GNU General Public License)
 * 
 * 
 * $Id: RAW.cpp,v 1.11 2004/05/22 05:22:34 randy Exp $
 */

#include "soopy.h"

/*
 * RawFile
 *   openIn, openOut
 */

SpValue& raw_openIn(SpValue& v)
{
    SpValue name = v.eval();
    if(!name.isString()){
        throw SpException("filename is not string (RawFile.openIn)");
    }
    SpString* str = name.asString();
    char* filename = (char*)str->toCStringWithEncoder();
    ifstream* fin = new ifstream;
#ifdef __WIN32__
    fin->open(filename, ios::binary);
#else
    fin->open(filename);
#endif
    if(fin->fail()){
        delete fin;
        throw SpException("can't open file");
    }
    FileStreamReader* sr = new FileStreamReader(fin, filename);

    return SpObjectResult(sr);
}

SpValue& raw_openOut(SpValue& v)
{
    SpValue name = v.eval();
    if(!name.isString()){
        throw SpException("filename is not string (RawFile.openOut)");
    }
    SpString* str = name.asString();
    char* filename = (char*)str->toCStringWithEncoder();
    ofstream* fout = new ofstream;
#ifdef __WIN32__
    fout->open(filename, ios::binary);
#else
    fout->open(filename);
#endif
    if(fout->fail()){
        delete fout;
        throw SpException("can't open file");
    }
    FileStreamWriter* sw = new FileStreamWriter(fout, filename);
    return SpObjectResult(sw);
}

SpValue& raw_openAppend(SpValue& v)
{
    SpValue name = v.eval();
    if(!name.isString()){
        throw SpException("filename is not string (Raw.openAppend)");
    }
    SpString* str = name.asString();
    char* filename = (char*)str->toCStringWithEncoder();
    ofstream* fout = new ofstream;
#ifdef __WIN32__
    fout->open(filename, ios::app | ios::binary);
#else
    fout->open(filename, ios::app);
#endif
    if(fout->fail()){
        delete fout;
        throw SpException("can't open file");
    }
    FileStreamWriter* sw = new FileStreamWriter(fout, filename);
    return SpObjectResult(sw);
}

void initRawFile()
{
    SpValue SymRawFile(new SpSymbol("raw"));
    SpNameSpace* ns = new SpNameSpace;
    SpValue NSRawFile(ns);
    PMainNameSpace->internConst(SymRawFile, NSRawFile);

    SpValue PrimOpenIn(new SpPrim1(&raw_openIn));
    ns->internConst(SymOpenIn, PrimOpenIn);

    SpValue PrimOpenOut(new SpPrim1(&raw_openOut));
    ns->internConst(SymOpenOut, PrimOpenOut);

    SpValue PrimOpenAppend(new SpPrim1(&raw_openAppend));
    ns->internConst(SymOpenAppend, PrimOpenAppend);
}


