/*
 * Programming Language SOOPY
 *   (Simple Object Oriented Programming sYstem)
 * 
 * Copyright (C) 2002 SUZUKI Jun
 * 
 * URL: http://sourceforge.jp/projects/soopy/
 * License: GPL(GNU General Public License)
 * 
 * 
 * $Id: Prim.cpp,v 1.43 2004/05/22 05:22:34 randy Exp $
 */

#include <stdlib.h>
#ifdef __WIN32__
#include <process.h>
#else
#include <unistd.h>
#endif /* __WIN32__ */

#include "soopy.h"

/*
 * Primitive: arg length  0
 */

SpValue& SpPrim0::operator()(SpValue&)
{
    return func();
}

SpValue& SpPrim0::toString()
{
    SpString* str;

    str = new SpString();
    *str = "#<Primitive: arg length 0>";
    //    static SpValue s;
    //    s.setNewObject(str);
    //    return s;
    return SpObjectResult(str);
}

/*
 * Primitive: arg length  1
 */

SpValue& SpPrim1::operator()(SpValue& arg)
{
    return func(arg);
}

SpValue& SpPrim1::toString()
{
    SpString* str;

    str = new SpString();
    *str = "#<Primitive: arg length 1>";
    //    static SpValue s;
    //    s.setNewObject(str);
    //    return s;
    return SpObjectResult(str);
}

/*
 * Primitive: arg length  2
 */

SpValue& SpPrim2::operator()(SpValue& arg)
{
  if(arg.isTuple()){
    SpTuple* tpl = arg.asTuple();
    if(tpl->length() != 2){
      throw SpException("too much args(primitive<2>)");
    }
    SpValue a1 = (*tpl)[0];
    SpValue a2 = (*tpl)[1];
    return operator()(a1, a2);
  }

  SpValue temp(this);
  SpClosureP2* closure = new SpClosureP2(temp, arg, getCurrentNS());
  //    static SpValue v;
  //    v.setNewObject(closure);
  //    return v;
  return SpObjectResult(closure);
}

SpValue& SpPrim2::operator()(SpValue& arg1, SpValue& arg2)
{
    return func(arg1, arg2);
}

SpValue& SpPrim2::toString()
{
    SpString* str;

    str = new SpString();
    *str = "#<Primitive: arg length 2>";
    //    static SpValue s;
    //    s.setNewObject(str);
    //    return s;
    return SpObjectResult(str);
}

/*
 * Primitive: arg length  3
 */

SpValue& SpPrim3::operator()(SpValue& arg)
{
  if(arg.isTuple()){
    SpTuple* tpl = arg.asTuple();
    if(tpl->length() != 3){
      throw SpException("arg length mismatch(primitive<3>)");
    }
    SpValue a1 = (*tpl)[0];
    SpValue a2 = (*tpl)[1];
    SpValue a3 = (*tpl)[2];
    return operator()(a1, a2, a3);
  }

    SpValue temp(this);
    SpClosureP3_1* closure = new SpClosureP3_1(temp, arg, getCurrentNS());
    //    static SpValue v;
    //    v.setNewObject(closure);
    //    return v;
    return SpObjectResult(closure);
}

SpValue& SpPrim3::operator()(SpValue& arg1, SpValue& arg2)
{
    //    static SpValue v;
    SpValue v;
    if(arg2.isTuple()){
        SpTuple* t = arg2.asTuple();
        if(t->length() != 2){
            throw SpException("too much args");
        }
        SpValue a2 = (*t)[0];
        SpValue a3 = (*t)[1];
        v = func(arg1, a2, a3);
    }else{
        SpValue temp(this);
        SpClosureP3_2* closure = new SpClosureP3_2(temp, arg1, arg2, getCurrentNS());
        v.setNewObject(closure);
    }
    //    return v;
    return SpValueResult(v);
}

SpValue& SpPrim3::operator()(SpValue& arg1, SpValue& arg2, SpValue& arg3)
{
    return func(arg1, arg2, arg3);
}

SpValue& SpPrim3::toString()
{
    SpString* str;

    str = new SpString();
    *str = "#<Primitive: arg length 3>";
    //    static SpValue s;
    //    s.setNewObject(str);
    //    return s;
    return SpObjectResult(str);
}

//
// primitives
//

SpValue PrimPrint;
SpValue PrimPrintLn;
SpValue PrimLoad;

SpValue& primPrint(SpValue& v)
{
    //*spout << v.eval().toString();
    SpValue temp;
    temp = v.eval();
    temp = temp.toString();
    *spout << temp;
    return PrimPrint;
}

SpValue& primPrintLn(SpValue& v)
{
    //*spout << v.eval().toString() << "\n";
    SpValue temp;
    temp = v.eval();
    temp = temp.toString();
    *spout << temp << "\n";
    return PrimPrintLn;
}

SpValue& primLoad(SpValue& v)
{
//    extern int load(const char*);
    extern SpValue& load(const char*);

    SpValue name = v.eval();
    if(!name.isString()){
        throw SpException("filename is not string (load)");
    }
    SpString* str = name.asString();
    const char* filename = str->toCStringWithEncoder();
  /*
    int result = load(filename);
    if(result < 0){
        return FalseObject;
    }
    return TrueObject;
  */
  return load(filename);
}

SpValue& primOpenIn(SpValue& v)
{
    SpValue name = v.eval();
    if(!name.isString()){
        throw SpException("filename is not string (openIn)");
    }
    SpString* str = name.asString();
    char* filename = (char*)str->toCStringWithEncoder();
    ifstream* fin = new ifstream;
#ifdef __WIN32__
    fin->open(filename, ios::binary);
#else
    fin->open(filename);
#endif
    if(fin->fail()){
        delete fin;
        throw SpException("can't open file");
    }
    FileStreamReader* sr = new FileStreamReader(fin, filename);
#ifdef EUC_JP
    ReadEncoder* encoder = new EucJPReadDecoder(sr);
#else
    ReadEncoder* encoder = new SjisReadDecoder(sr);
#endif
    //    static SpValue result;
    //    result.setNewObject(encoder);
    //    return result;
    return SpObjectResult(encoder);
}

SpValue& primOpenOut(SpValue& v)
{
    SpValue name = v.eval();
    if(!name.isString()){
        throw SpException("filename is not string (openOut)");
    }
    SpString* str = name.asString();
    char* filename = (char*)str->toCStringWithEncoder();
    ofstream* fout = new ofstream;
#ifdef __WIN32__
    fout->open(filename, ios::binary);
#else
    fout->open(filename);
#endif
    if(fout->fail()){
        delete fout;
        throw SpException("can't open file");
    }
    FileStreamWriter* sw = new FileStreamWriter(fout, filename);
#ifdef EUC_JP
    WriteEncoder* encoder = new EucJPWriteEncoder(sw);
#else
    WriteEncoder* encoder = new SjisWriteEncoder(sw);
#endif
    //    static SpValue result;
    //    result.setNewObject(encoder);
    //    return result;
    return SpObjectResult(encoder);
}

SpValue& primOpenAppend(SpValue& v)
{
    SpValue name = v.eval();
    if(!name.isString()){
        throw SpException("filename is not string (openAppend)");
    }
    SpString* str = name.asString();
    char* filename = (char*)str->toCStringWithEncoder();
    ofstream* fout = new ofstream;
#ifdef __WIN32__
    fout->open(filename, ios::binary | ios_base::app);
#else
    fout->open(filename, ios::app);
#endif
    if(fout->fail()){
        delete fout;
        throw SpException("can't open file");
    }
    FileStreamWriter* sw = new FileStreamWriter(fout, filename);
#ifdef EUC_JP
    WriteEncoder* encoder = new EucJPWriteEncoder(sw);
#else
    WriteEncoder* encoder = new SjisWriteEncoder(sw);
#endif
    //    static SpValue result;
    //    result.setNewObject(encoder);
    //    return result;
    return SpObjectResult(encoder);
}

SpValue& primSetReader(SpValue& reader)
{
  //if(reader.eq(SymSjisIn).isTrue()){
  SpValue temp;
  temp = reader.eq(SymSjisIn);
  if(temp.isTrue()){
      spin = sjisin;
  }else if((temp = reader.eq(SymEucjpIn)).isTrue()){
      spin = eucjpin;
  }else{
      throw SpException("no such a reader");
  }
  return TrueObject;
}

SpValue& primSystem(SpValue& arg)
{
    if(arg.isString()){
        const char* cmd = arg.toCStringWithEncoder();
        if(system(cmd) == -1){
/*
            switch(errno){
            case ENOENT:
                cout << "no entry\n";
                break;
            case ENOEXEC:
                cout << "not exec\n";
                break;
            case ENOMEM:
                cout << "no memory\n";
                break;
            default:
                cout << "other error\n";
            }
*/
            return FalseObject;
        }
        return TrueObject;
    }
    throw SpException("not string (system)");
}

SpValue& primExec(SpValue& arg)
{
    if(arg.isString()){
        const char* cmd = arg.toCStringWithEncoder();
        char* p = (char*)cmd;
        p = strchr(p, ' ');
        if(p == NULL){
            p = (char*)cmd;
            p = strchr(p, '\t');
        }
        if(p == NULL){
            if(execlp(cmd,cmd,NULL) == -1){
/*
                switch(errno){
                case EACCES:
                    cout << "can't access\n";
                    break;
                    case EMFILE:
                    cout << "too many opened files.\n";
                    break;
                case ENOENT:
                    cout << "no entry\n";
                    break;
                case ENOEXEC:
                    cout << "not exec\n";
                    break;
                case ENOMEM:
                    cout << "no memory\n";
                    break;
                default:
                    cout << "other error\n";
                }
*/
                return FalseObject;
            }
        }else{
            *p = '\0';
            p++;
//cout << "cmd: '" << cmd << "', p: '" << p << "'" << endl;
            if(execlp(cmd,cmd,p,NULL) == -1){
                return FalseObject;
            }
        }
        return TrueObject;
    }
    throw SpException("not string (exec)");
}

SpValue& primQuit()
{
    exit(0);
}

void initPrim()
{
    // set global variables
    SpValue SymPrint(new SpSymbol("print"));
    PrimPrint.setNewObject(new SpPrim1(&primPrint));
    PMainNameSpace->internConst(SymPrint, PrimPrint);

    SpValue SymPrintLn(new SpSymbol("println"));
    PrimPrintLn.setNewObject(new SpPrim1(&primPrintLn));
    PMainNameSpace->internConst(SymPrintLn, PrimPrintLn);

    SpValue SymLoad(new SpSymbol("load"));
    PrimLoad.setNewObject(new SpPrim1(&primLoad));
    PMainNameSpace->internConst(SymLoad, PrimLoad);

    SpValue PrimOpenIn(new SpPrim1(&primOpenIn));
    PMainNameSpace->internConst(SymOpenIn, PrimOpenIn);

    SpValue PrimOpenOut(new SpPrim1(&primOpenOut));
    PMainNameSpace->internConst(SymOpenOut, PrimOpenOut);

    SpValue PrimOpenAppend(new SpPrim1(&primOpenAppend));
    PMainNameSpace->internConst(SymOpenAppend, PrimOpenAppend);

    SpValue SymSystem(new SpSymbol("system"));
    SpValue PrimSystem(new SpPrim1(&primSystem));
    PMainNameSpace->internConst(SymSystem, PrimSystem);

    SpValue SymExec(new SpSymbol("exec"));
    SpValue PrimExec(new SpPrim1(&primExec));
    PMainNameSpace->internConst(SymExec, PrimExec);

    SpValue SymQuit(new SpSymbol("quit"));
    SpValue PrimQuit(new SpPrim0(&primQuit));
    PMainNameSpace->internConst(SymQuit, PrimQuit);

    // set 'SOOPY'
    SpValue SymSetReader(new SpSymbol("setreader"));
    SpValue PrimSetReader(new SpPrim1(primSetReader));
    PSoopyNameSpace->internConst(SymSetReader, PrimSetReader);
}
