/*
 * Programming Language SOOPY
 *   (Simple Object Oriented Programming sYstem)
 * 
 * Copyright (C) 2002 SUZUKI Jun
 * 
 * URL: http://sourceforge.jp/projects/soopy/
 * License: GPL(GNU General Public License)
 * 
 * 
 * $Id: Loop.cpp,v 1.10 2004/03/25 13:25:48 randy Exp $
 */

#include "soopy.h"

/*
 * class SpLoop
 */

SpValue& SpLoop::eval()
{
    //static SpValue result;
    SpValue result;
    SpValue temp;
    bool stepp  = !step.isNil();
    bool whilep = !while_cond.isNil();
    bool untilp = !until_cond.isNil();
    bool body_is_list = body.isList();
    if(!from.isNil()){
        if(from.isList()){
            SpValue L = from;
            while(L.isList()){
                SpList* list = dynamic_cast<SpList*>(L.getObject());
                //temp = list->value().eval();
                temp = list->value();
                temp = temp.eval();
                L = list->nextList();
            }
        }else{
            temp = from.eval();
        }
    }
    while(true){
start:
        // check while
        if(whilep){
            SpValue cond = while_cond.eval();
            if(cond.isFalse()){
                break;
            }
        }
        // check until
        if(untilp){
            SpValue cond = until_cond.eval();
            if(cond.isTrue()){
                break;
            }
        }
        // do body
        try {
            if(body_is_list){
                SpValue L = body;
                while(L.isList()){
                    SpList* list = dynamic_cast<SpList*>(L.getObject());
                    SpValue v = list->value();
                    result = v.eval();
                    L = list->nextList();
                }
            }else{
                result = body.eval();
            }
        }catch(SpExitException& e){
            if(e.symbol.isNil()){
                result = e.val;
            }else if(symbol == e.symbol){
                result = e.val;
            }else{
                throw;
            }
            break;
        }catch(SpNextException& e){
            if(e.symbol.isNil()){
                goto start;
            }else if(symbol == e.symbol){
                goto start;
            }
            throw;
        }
        // check variant
        // check invariant
        // step
        if(stepp){
            if(step.isList()){
                SpValue L = step;
                while(L.isList()){
                    SpList* list = dynamic_cast<SpList*>(L.getObject());
                    temp = list->value();
                    temp = temp.eval();
                    L = list->nextList();
                }
            }else{
                temp = step.eval();
            }
        }
    }
    //    return result;
    return SpValueResult(result);
}

SpValue& SpLoop::toString()
{
    SpString* str;

    str = new SpString();
    *str += "loop ";
    if(!symbol.isNil()){
        *str += symbol.toString();
    }
    *str += " {\n";
    if(!while_cond.isNil()){
        *str += "  while: ";
        *str += while_cond;
        *str += "\n";
    }
    if(!until_cond.isNil()){
        *str += "  until: ";
        *str += until_cond;
        *str += "\n";
    }
    if(!body.isNil()){
        *str += "  do: ";
        *str += body;
        *str += "\n";
    }
    if(!variant.isNil()){
        *str += "  variant: ";
        *str += variant;
        *str += "\n";
    }
    if(!invariant.isNil()){
        *str += "  invariant: ";
        *str += invariant;
        *str += "\n";
    }

    *str += "}";
    //    static SpValue s;
    //    s.setNewObject(str);
    //    return s;
    return SpObjectResult(str);
}

/*
 * class SpExit
 */

SpValue& SpExit::eval()
{
    //    static SpValue val;
    SpValue val;
    val = expr.eval();
    SpValueResult(val);
    throw SpExitException(symbol, val, "uncaught exit");
}

SpValue& SpExit::toString()
{
    SpString* str;

    str = new SpString();
    if(!symbol.isNil()){
        *str += symbol;
        *str += ".";
    }
    *str += "exit";
    if(!expr.isNil()){
        *str += "(";
        *str += expr;
        *str += ")";
    }
    //    static SpValue s;
    //    s.setNewObject(str);
    //    return s;
    return SpObjectResult(str);
}

/*
 * class SpNext
 */

SpValue& SpNext::eval()
{
    throw SpNextException(symbol, "uncaught next");
}

SpValue& SpNext::toString()
{
    SpString* str;

    str = new SpString();
    if(!symbol.isNil()){
        *str += symbol;
        *str += ".";
    }
    *str += "next";
    //    static SpValue s;
    //    s.setNewObject(str);
    //    return s;
    return SpObjectResult(str);
}

