/*
 * Programming Language SOOPY
 *   (Simple Object Oriented Programming sYstem)
 * 
 * Copyright (C) 2002,2003 SUZUKI Jun
 * 
 * URL: http://sourceforge.jp/projects/soopy/
 * License: GPL(GNU General Public License)
 * 
 * 
 * $Id: Load.cpp,v 1.25 2007/01/29 11:46:16 randy Exp $
 */

#ifdef __WIN32__
#include <io.h>
#else
#include <unistd.h>
#include <stdio.h>
#endif

#include "soopy.h"

SpValue program;

int openWithLibPaths(ifstream& fin, const char* fname)
{
    if(access(fname, 04) == 0){
        fin.open(fname);
        if(fin.fail()){
            return -1; // failure
        }
    }else{
        char* name = new char[strlen(fname) + MaxLibPathBuffer];
        for(int i=0; i < NumberOfLibPath; i++){
#ifdef __WIN32__
            sprintf(name, "%s\\%s", LibPaths[i], fname);
#else
            sprintf(name, "%s/%s", LibPaths[i], fname);
#endif
            if(access(name, 04) == 0){
                fin.open(name);
                if(!fin.fail()){
                    delete name;
                    return 1;
                }else{
                    break; // failure
                }
            }
        }
        delete name;
        return -1; // failure
    }
    return 1;
}

extern int yyparse();

//int load(const char* fname)
SpValue& load(const char* fname)
{
    SpValue evaled;
    int result;
    int status = 1;
    char old_name[SP_NAME_MAX];
    unsigned int old_line;
    ifstream fin;

    if(openWithLibPaths(fin, fname) < 0){
        cerr << "can't open file '" << fname  << "'" << endl;
//        return -1;
        return NilObject;
    }

    strcpy(old_name, Filename);
    setFilename((char*)fname);
    old_line = lineno;
    StreamReader* reader = new StreamReader(&fin);
    JapaneseReadDecoder* encoder = new JapaneseReadDecoder(reader);
    SpValue taker(encoder);
    ReadEncoder* old_lexer_encoder = Lexer::getReadEncoder();
    Lexer::setReadEncoder(encoder);
    try{
      while(status >= 0){
          try{
              result = yyparse();
              if(result == 0){
                  // status = 1;
                  break;
              }
              evaled = program.eval();
          }
          catch(const SpException& e){
              cout << "Uncaught exception: " << e.what() << endl;
              status = -1;
          }
          catch(const exception& e){
              cout << "Exception: " << e.what() << endl;
              status = -2;
          }
          catch(...){
              cout << "Unknown exception" << endl;
              status = -3;
          }
      }
    }catch(...){
      //status = -1;
      evaled = NilObject;
    }
    setFilename(old_name);
    lineno = old_line;
    Lexer::setReadEncoder(old_lexer_encoder);

//    return status;
  return SpValueResult(evaled);
}

int interaction(bool p)
{
    int result, status;

    while(true){
        if(p){
            *spout << "\n> ";
        }
        try{
            result = yyparse();
            if(result == 0){
                if(p){
                    *spout << "bye.\n";
                }
                status = 1;
                break;
            }
            SpValue evaled = program.eval();
            if(p){
                *spout << evaled;
            }
        }
        catch(const SpException& e){
            cout << "Uncaught exception: " << e.what() << endl;
        }
        catch(const exception& e){
            cout << "Exception: " << e.what() << endl;
        }
        catch(...){
            cout << "Unknown exception" << endl;
            status = -1;
            break;
        }
    }
    return status;
}

