/*
 * Programming Language SOOPY
 *   (Simple Object Oriented Programming sYstem)
 * 
 * Copyright (C) 2002 SUZUKI Jun
 * 
 * URL: http://sourceforge.jp/projects/soopy/
 * License: GPL(GNU General Public License)
 * 
 * 
 * $Id: Func.cpp,v 1.29 2004/03/25 13:29:57 randy Exp $
 */


#include "soopy.h"

/*
 * class SpArg
 */

SpValue& SpArg::toString()
{
    SpString* str;
    SpValue v1, v2;

    str = new SpString();
    *str += name.toString();
    *str += ":";
    *str += typ.toString();
    //    static SpValue s;
    //    s.setNewObject(str);
    //    return s;
    return SpObjectResult(str);
}

/*
 * class SpUsrFunc
 */

void SpUsrFunc::checkRequire()
{
    SpValue temp;
    if(!requir.isList()){
        //if(requir.eval().isFalse()){
        temp = requir.eval();
        if(temp.isFalse()){
            throw SpRequireException("pre conditon error");
        }
        return;
    }
    SpValue v = requir;
    while(!v.isNil()){
        SpList* list = v.asList();
        //if(list->value().eval().isFalse()){
        temp = list->value();
        temp = temp.eval();
        if(temp.isFalse()){
            throw SpRequireException("pre conditon error");
        }
        v = list->nextList();
    }
}

void SpUsrFunc::checkEnsure()
{
    SpValue temp;
    if(!ensure.isList()){
        //if(ensure.eval().isFalse()){
        temp = ensure.eval();
        if(temp.isFalse()){
            throw SpEnsureException("post conditon error");
        }
        return;
    }
    SpValue v = ensure;
    while(!v.isNil()){
        SpList* list = v.asList();
        //if(list->value().eval().isFalse()){
        temp = list->value();
        temp = temp.eval();
        if(temp.isFalse()){
            throw SpEnsureException("post conditon error");
        }
        v = list->nextList();
    }
}

// if retry, return true
bool SpUsrFunc::doRescue()
{
    try{
        if(!rescue.isList()){
            rescue.eval();
            return false;
        }
        SpValue v = rescue;
        while(!v.isNil()){
            SpList* list = v.asList();
            //list->value().eval();
            SpValue temp;
            temp = list->value();
            temp = temp.eval();
            v = list->nextList();
        }
    }catch(SpRetryException& e){
        return true;
    }
    return false;
}

SpValue& SpUsrFunc::operator()(SpValue& arg)
{
    //    static SpValue result;
    SpValue result;
    SpNameSpace* ns = new SpNameSpace(getCurrentNS());
    SpValue v_ns(ns);
    SpValue v_f(this);

    // init args
    if(argLen == 0){
        if(!arg.isNil()){
            throw SpException("too many args");
        }
    }else if(argLen == 1){
        SpTuple* ptr = dynamic_cast<SpTuple*>(args.getObject());
	//        SpArg* p = ((*ptr)[0]).asArg();
	SpValue temp = (*ptr)[0];
        SpArg* p = temp.asArg();
        temp = arg.eval();
        CheckType(p->typ, temp);
	//        ns->internVar(p->getVarName(), temp);
	SpValue temp2 = p->getVarName();
        ns->internVar(temp2, temp);
    }else{ // argLen >= 2
        if(!arg.isTuple()){
            result.setNewObject(new SpClosureN(v_f, arg, v_ns));
	    //            return result;
	    return SpValueResult(result);
        }else{
            SpTuple* t = dynamic_cast<SpTuple*>(arg.getObject());
            if((SpInt)argLen != t->length()){



                throw SpException("arg length mismatch");
            }
            // set args
            SpTuple* ptr = dynamic_cast<SpTuple*>(args.getObject());
            SpValueVector::iterator it, it2;
            it = ptr->begin();
            it2 = t->begin();
            for(; it != ptr->end(); it++, it2++){
                SpArg* p = it->asArg();
                SpValue temp = it2->eval();
                CheckType(p->typ, temp);
//                ns->internVar(p->getVarName(), it2->eval());
		SpValue temp2 = p->getVarName();
                ns->internVar(temp2, temp);
            }
        }
    }

    // set locals
    SpValue temp = vars;
    if(temp.isSymbol()){
        ns->internVar(temp, NilObject);
    }else{
        while(!temp.isNil()){
            SpList* list = temp.asList();
	    //            ns->internVar(list->value(), NilObject);
	    temp = list->value();
            ns->internVar(temp, NilObject);
            temp = list->nextList();
        }
    }

    /*
     * Main
     */
    pushCurrentNS(v_ns);
    try{
        // check pre conditions
        checkRequire();
retry:
        // do body
        try{
            result = doBody();
        }catch(SpExitException& e){
            if(e.symbol.isNil()){
                result = e.val;
            }else if(name == e.symbol){
                result = e.val;
            }else{
                // throw;
                if(!rescue.isNil()){
                    if(doRescue()){ // doRescue() == true , then retry
                        goto retry;
                    }
                }
                throw SpException("uncaught exit");
            }
        }catch(SpException& e){
            if(!rescue.isNil()){
                if(doRescue()){ // doRescue() == true , then retry
                    goto retry;
                }
            }
            throw;
        }
        // check post conditions
        try{
            checkEnsure();
        //}catch(SpEnsureException& e){
        }catch(SpException& e){
            if(!rescue.isNil()){
                if(doRescue()){ // doRescue() == true , then retry
                    goto retry;
                }
            }
            throw;
        }
    }catch(...){
      popCurrentNS();
      throw;
    }
    popCurrentNS();

    //    return result;
    return SpValueResult(result);
}

SpValue& SpUsrFunc::doBody()
{
    //    static SpValue result;
    SpValue result;
    if(!body.isList()){
        result = body.eval();
	//        return result;
	return SpValueResult(result);
    }
    // body is list.
    SpValue L = body;
    while(L.isList()){
        SpList* list = dynamic_cast<SpList*>(L.getObject());
        SpValue v = list->value();
        result = v.eval();
        L = list->nextList();
    }

    //    return result;
    return SpValueResult(result);
}

/*
SpValue& SpUsrFunc::onMessage(SpValue& rec, SpValue& msg)
{
    return (*this)(msg);
}
*/

SpValue& SpUsrFunc::toString()
{
    SpString* str;
    SpValue v1, v2;

    str = new SpString();
    *str = "fun ";
    *str += name.toString();
    *str += args.toString();
    *str += "\n";
/*
    *str += "{\n";
    *str += body.toString();
    *str += "\n}\n";
*/
    //    static SpValue s;
    //    s.setNewObject(str);
    //    return s;
    return SpObjectResult(str);
}

SpUsrFunc* SpUsrFunc::fromNameSpace(SpNameSpace*ns)
{
    extern void checkAllSymbols(SpValue& list);
    SpValue name, args, vars, require, body, ensure, rescue;

    SpValue a = ns->lookup(SymArg);
    checkAllSymbols(a);
    if(a.isNil()){
        args = NilObject;
    }else if(a.isList()){
        SpValueVector vec;
        while(!a.isNil()){
            SpList* ptr = a.asList();
	    //            SpValue v(new SpArg(ptr->value(), NilObject));
	    SpValue temp;
	    temp = ptr->value();
            SpValue v(new SpArg(temp, NilObject));
            vec.push_back(v);
            a = ptr->nextList();
        }
        args.setNewObject(new SpTuple(vec));
    }else{ // isSymbol
        SpValueVector vec;
        vec.push_back(a);
        args.setNewObject(new SpTuple(vec)); /* this tuple can't print */
    }

    name    = ns->lookup(SymName);
    vars    = ns->lookup(SymVar);
    checkAllSymbols(vars);
    require = ns->lookup(SymRequire);
    body    = ns->lookup(SymDo);
    ensure  = ns->lookup(SymEnsure);
    rescue  = ns->lookup(SymRescue);

    return new SpUsrFunc(name,
                          args,
                          vars,
                          require,
                          body,
                          ensure,
                          rescue);
}

/*
 * class SpRetry
 */

SpValue& SpRetry::toString()
{
    SpString* str;
    str = new SpString("retry");
    //    static SpValue v;
    //    v.setNewObject(str);
    //    return v;
    return SpObjectResult(str);
}
